/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.RabatnaPolitika;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.util.RabatnaPolitikaManager;

public class BrowserRabatiPanel
extends BrowserComponent {
    private static final long serialVersionUID = -8155289270776226396L;
    public static final String ID = "RABATI_PANEL";
    private Komitent komitent;
    private RabatnaPolitikaManager rpm;
    private JScrollPane scrollPane;
    private PzTable table;
    private JPanel pnlUkupno;
    private JLabel lblUkupanRabatZa;
    private PzDoubleField dblUkupno;

    public BrowserRabatiPanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(1, 3, 1, 1));
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(0, 0));
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane, "Center");
        this.table = new PzTable();
        this.table.setId("TABLE_RABATI");
        this.table.setEnterAction(null);
        this.table.setFilter(new PzEntityFilter(){

            public Object[] getValues(PzEntity entity) {
                RabatnaPolitika rp = (RabatnaPolitika)entity;
                return new Object[]{rp.getOpis(), rp.getProcenat()};
            }

            public String[] getColumnNames() {
                return new String[]{"Opis", "% rabata"};
            }
        });
        this.scrollPane.setViewportView((Component)this.table);
        this.pnlUkupno = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.pnlUkupno.getLayout();
        flowLayout.setAlignment(2);
        this.add(this.pnlUkupno, "South");
        this.lblUkupanRabatZa = new JLabel("Ukupan rabat za komitenta:");
        this.pnlUkupno.add(this.lblUkupanRabatZa);
        this.dblUkupno = this.table.createExpresionField("$1$");
        this.dblUkupno.setForeground(Color.BLUE);
        this.dblUkupno.setFont(new Font("SansSerif", 1, 14));
        this.dblUkupno.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        this.pnlUkupno.add((Component)this.dblUkupno);
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
    }

    @Override
    public void updateData(Stanjeartikal a, Object parentComponent) {
        this.rpm = (RabatnaPolitikaManager)PzApplication.getApplication().getSession().getRuntimeStore().get("RPM_TEKUCI_KOMITENT");
        PzDokument f = (PzDokument)PzApplication.getApplication().getSession().getRuntimeStore().get("TRENUTNI_DOKUMENT");
        if (this.rpm == null) {
            return;
        }
        this.komitent = f.getKomitent();
        if (this.komitent == null) {
            return;
        }
        try {
            this.table.setData(this.rpm.getRabatnePolitike(a, this.komitent), RabatnaPolitika.class);
            this.table.calculateFields();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void focusGained() {
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "Rabati";
    }

    @Override
    public boolean isCloseable() {
        return true;
    }

    @Override
    public PzToolBarIcon getSwitchIcon() {
        PzToolBarIcon icnRabatnaPolitika = new PzToolBarIcon();
        icnRabatnaPolitika.setIcon((Icon)new ImageIcon(PzArtikliBrowser.class.getResource("/rs/pezar/sifarnici/resource/img/percent.png")));
        icnRabatnaPolitika.setText("Rabatna|politika|(ALT+R)");
        icnRabatnaPolitika.setActionCommand("rabati");
        icnRabatnaPolitika.setShortcut("ALT+R");
        icnRabatnaPolitika.addActionListener(this.createSwitchActionListener());
        icnRabatnaPolitika.setVisible((RabatnaPolitikaManager)PzApplication.getApplication().getSession().getRuntimeStore().get("RPM_TEKUCI_KOMITENT") != null);
        return icnRabatnaPolitika;
    }

    @Override
    public boolean shouldBeShown() {
        return (RabatnaPolitikaManager)PzApplication.getApplication().getSession().getRuntimeStore().get("RPM_TEKUCI_KOMITENT") != null;
    }
}

