/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.eclipse.persistence.queries.FetchGroup;
import rs.pezar.core.PzApplication;
import rs.pezar.core.log.PzLogger;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Robnagrupa;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.PzDialogRobneGrupe;
import rs.pezar.sifarnici.gui.artikli.PodesavanjePretrage;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserTablePanel;
import rs.pezar.sifarnici.gui.artikli.browser.tools.BrowserQueryAction;
import rs.pezar.sifarnici.gui.artikli.browser.tools.QueryTool1;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.event.PzShortcutListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.util.StopWatch;

public class BrowserSearchPanel
extends BrowserComponent {
    private static final long serialVersionUID = -7084737804763384234L;
    public static final String ID = "PANEL_SEARCH";
    private static final String PRET_SIFRA = "PRETRAGA_PO_SIFRI";
    private static final String PRET_NAZIV = "PRETRAGA_PO_NAZIVU";
    private static final String PRET_KAT_BROJ = "PRETRAGA_PO_KAT_BROJU";
    private JLabel lblNazivArtikla;
    private JLabel lblBliiOpisf;
    private JLabel lblModel;
    private JLabel lblDobavljaf;
    private JLabel lblModelf;
    private JLabel lblRobnaGrupaf;
    private PzTextField txtNaziv;
    private PzTextField txtBliziOpis;
    private PzTextField txtProizvodjac;
    private PzTextField txtDobavljac;
    private PzTextField txtModel;
    private PzTextField txtRobnaGrupa;
    private JLabel lblifraf;
    private JLabel lblKatalokiBroj;
    private JLabel lblOeBrojatlf;
    private PzTextField txtSifra;
    private PzTextField txtKataloskiBroj;
    private PzTextField txtOeBroj;
    private PzButton btnTrazi;
    private PzButton btnCisti;
    private PzComponentGroup cgr1;
    private PzComponentGroup cgr2;
    private Radnajedinica rj;
    private EntityManager em;
    private BrowserTablePanel tablePanel;
    private JLabel lblBrPogodaka;
    private String query;
    private int row = 0;
    private BrowserQueryAction action;
    private FetchGroup grpStanjeArtikal;
    private static String lastQuery;
    private JLabel lblPrSifra;
    private JCheckBox cbKolicina;
    private static Radnajedinica lastRj;
    private static int lastRow;
    private static boolean advancedSearch;
    private List<Stanjeartikal> list = null;
    private PzTextField txtPrSifra;
    private String pretragaNaziv;
    private String pretragaSifra;
    private String pretragaKatBroj;
    private String pretragaSifraPro;

    static {
        lastRow = -1;
        advancedSearch = false;
    }

    public BrowserSearchPanel() {
        this.initGUI();
        this.initParameters();
        this.loadHints1();
        this.setComponentLocation(new BrowserComponent.Location(0, 0, 1, 1));
    }

    private void initParameters() {
        if (this.pretragaNaziv == null) {
            this.pretragaNaziv = PzParameter.getParameterValue((String)PRET_NAZIV, (String)"po_delu_reci");
        }
        if (this.pretragaSifra == null) {
            this.pretragaSifra = PzParameter.getParameterValue((String)PRET_SIFRA, (String)"po_celoj_sifri");
        }
        if (this.pretragaKatBroj == null) {
            this.pretragaKatBroj = PzParameter.getParameterValue((String)PRET_KAT_BROJ, (String)"po_celoj_sifri");
        }
        if (this.pretragaSifraPro == null) {
            this.pretragaSifraPro = PzParameter.getParameterValue((String)PRET_SIFRA, (String)"po_celoj_sifri");
        }
    }

    private void initGUI() {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent arg0) {
                BrowserSearchPanel.this.thisancestorAdded(arg0);
            }

            @Override
            public void ancestorMoved(AncestorEvent arg0) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent arg0) {
            }
        });
        this.setBorder(new TitledBorder(null, "Kriterijumi pretrage", 4, 2, null, null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWidths = new int[]{100, 100, 100, 100, 100, 100};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 1.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.setPreferredSize(new Dimension(541, 186));
        this.cgr1 = new PzComponentGroup();
        this.cgr2 = new PzComponentGroup();
        this.lblNazivArtikla = new JLabel("Naziv (F8)");
        GridBagConstraints gbc_lblNazivArtikla = new GridBagConstraints();
        gbc_lblNazivArtikla.anchor = 15;
        gbc_lblNazivArtikla.insets = new Insets(0, 0, 0, 5);
        gbc_lblNazivArtikla.gridx = 0;
        gbc_lblNazivArtikla.gridy = 0;
        this.add(this.lblNazivArtikla, gbc_lblNazivArtikla);
        this.lblBliiOpisf = new JLabel("Bli\u017ei opis (F9)");
        GridBagConstraints gbc_lblBliiOpisf = new GridBagConstraints();
        gbc_lblBliiOpisf.anchor = 15;
        gbc_lblBliiOpisf.insets = new Insets(0, 0, 0, 5);
        gbc_lblBliiOpisf.gridx = 1;
        gbc_lblBliiOpisf.gridy = 0;
        this.add(this.lblBliiOpisf, gbc_lblBliiOpisf);
        this.lblModel = new JLabel("Proizvo\u0111a\u010d (F4)");
        GridBagConstraints gbc_lblModel = new GridBagConstraints();
        gbc_lblModel.anchor = 15;
        gbc_lblModel.insets = new Insets(0, 0, 0, 5);
        gbc_lblModel.gridx = 2;
        gbc_lblModel.gridy = 0;
        this.add(this.lblModel, gbc_lblModel);
        this.lblDobavljaf = new JLabel("Dobavlja\u010d (F6)");
        GridBagConstraints gbc_lblDobavljaf = new GridBagConstraints();
        gbc_lblDobavljaf.anchor = 15;
        gbc_lblDobavljaf.insets = new Insets(0, 0, 0, 5);
        gbc_lblDobavljaf.gridx = 3;
        gbc_lblDobavljaf.gridy = 0;
        this.add(this.lblDobavljaf, gbc_lblDobavljaf);
        this.lblModelf = new JLabel("Model (F5)");
        GridBagConstraints gbc_lblModelf = new GridBagConstraints();
        gbc_lblModelf.anchor = 15;
        gbc_lblModelf.insets = new Insets(0, 0, 0, 5);
        gbc_lblModelf.gridx = 4;
        gbc_lblModelf.gridy = 0;
        this.add(this.lblModelf, gbc_lblModelf);
        this.lblRobnaGrupaf = new JLabel("Robna grupa (F12)");
        GridBagConstraints gbc_lblRobnaGrupaf = new GridBagConstraints();
        gbc_lblRobnaGrupaf.anchor = 15;
        gbc_lblRobnaGrupaf.gridx = 5;
        gbc_lblRobnaGrupaf.gridy = 0;
        this.add(this.lblRobnaGrupaf, gbc_lblRobnaGrupaf);
        this.txtNaziv = BrowserSearchPanel.createPzTextField();
        this.txtNaziv.removeEnterBehaviour();
        this.cgr1.add((Component)this.txtNaziv);
        GridBagConstraints gbc_txtNaziv = new GridBagConstraints();
        gbc_txtNaziv.anchor = 11;
        gbc_txtNaziv.insets = new Insets(0, 0, 5, 5);
        gbc_txtNaziv.fill = 2;
        gbc_txtNaziv.gridx = 0;
        gbc_txtNaziv.gridy = 1;
        this.add((Component)this.txtNaziv, gbc_txtNaziv);
        this.txtBliziOpis = BrowserSearchPanel.createPzTextField();
        this.txtBliziOpis.removeEnterBehaviour();
        this.cgr1.add((Component)this.txtBliziOpis);
        GridBagConstraints gbc_txtBliziOpis = new GridBagConstraints();
        gbc_txtBliziOpis.anchor = 11;
        gbc_txtBliziOpis.insets = new Insets(0, 0, 5, 5);
        gbc_txtBliziOpis.fill = 2;
        gbc_txtBliziOpis.gridx = 1;
        gbc_txtBliziOpis.gridy = 1;
        this.add((Component)this.txtBliziOpis, gbc_txtBliziOpis);
        this.txtProizvodjac = BrowserSearchPanel.createPzTextField();
        this.txtProizvodjac.removeEnterBehaviour();
        this.cgr1.add((Component)this.txtProizvodjac);
        GridBagConstraints gbc_txtProizvodjac = new GridBagConstraints();
        gbc_txtProizvodjac.anchor = 11;
        gbc_txtProizvodjac.insets = new Insets(0, 0, 5, 5);
        gbc_txtProizvodjac.fill = 2;
        gbc_txtProizvodjac.gridx = 2;
        gbc_txtProizvodjac.gridy = 1;
        this.add((Component)this.txtProizvodjac, gbc_txtProizvodjac);
        this.txtDobavljac = BrowserSearchPanel.createPzTextField();
        this.txtDobavljac.removeEnterBehaviour();
        this.cgr1.add((Component)this.txtDobavljac);
        GridBagConstraints gbc_txtDobavljac = new GridBagConstraints();
        gbc_txtDobavljac.anchor = 11;
        gbc_txtDobavljac.insets = new Insets(0, 0, 5, 5);
        gbc_txtDobavljac.fill = 2;
        gbc_txtDobavljac.gridx = 3;
        gbc_txtDobavljac.gridy = 1;
        this.add((Component)this.txtDobavljac, gbc_txtDobavljac);
        this.txtModel = BrowserSearchPanel.createPzTextField();
        this.txtModel.removeEnterBehaviour();
        this.cgr1.add((Component)this.txtModel);
        GridBagConstraints gbc_txtModel = new GridBagConstraints();
        gbc_txtModel.anchor = 11;
        gbc_txtModel.insets = new Insets(0, 0, 5, 5);
        gbc_txtModel.fill = 2;
        gbc_txtModel.gridx = 4;
        gbc_txtModel.gridy = 1;
        this.add((Component)this.txtModel, gbc_txtModel);
        this.txtRobnaGrupa = BrowserSearchPanel.createPzTextField();
        this.txtRobnaGrupa.setFKField(Robnagrupa.class, PzDialogRobneGrupe.class, false, null);
        this.cgr1.add((Component)this.txtRobnaGrupa);
        GridBagConstraints gbc_txtRobnaGrupa = new GridBagConstraints();
        gbc_txtRobnaGrupa.anchor = 11;
        gbc_txtRobnaGrupa.insets = new Insets(0, 0, 5, 0);
        gbc_txtRobnaGrupa.fill = 2;
        gbc_txtRobnaGrupa.gridx = 5;
        gbc_txtRobnaGrupa.gridy = 1;
        this.add((Component)this.txtRobnaGrupa, gbc_txtRobnaGrupa);
        this.lblifraf = new JLabel("\u0160ifra (F7)");
        GridBagConstraints gbc_lblifraf = new GridBagConstraints();
        gbc_lblifraf.insets = new Insets(0, 0, 0, 5);
        gbc_lblifraf.gridx = 0;
        gbc_lblifraf.gridy = 2;
        this.add(this.lblifraf, gbc_lblifraf);
        this.lblKatalokiBroj = new JLabel("Katalo\u0161ki broj (F10)");
        GridBagConstraints gbc_lblKatalokiBroj = new GridBagConstraints();
        gbc_lblKatalokiBroj.insets = new Insets(0, 0, 0, 5);
        gbc_lblKatalokiBroj.gridx = 1;
        gbc_lblKatalokiBroj.gridy = 2;
        this.add(this.lblKatalokiBroj, gbc_lblKatalokiBroj);
        this.lblOeBrojatlf = new JLabel("OE broj (ATL+F11)");
        GridBagConstraints gbc_lblOeBrojatlf = new GridBagConstraints();
        gbc_lblOeBrojatlf.insets = new Insets(0, 0, 0, 5);
        gbc_lblOeBrojatlf.gridx = 2;
        gbc_lblOeBrojatlf.gridy = 2;
        this.add(this.lblOeBrojatlf, gbc_lblOeBrojatlf);
        this.txtSifra = BrowserSearchPanel.createPzTextField();
        this.txtSifra.removeEnterBehaviour();
        this.txtSifra.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                BrowserSearchPanel.this.cgr2KeyReleased(arg0);
            }
        });
        this.cgr2.add((Component)this.txtSifra);
        GridBagConstraints gbc_txtSifra = new GridBagConstraints();
        gbc_txtSifra.anchor = 11;
        gbc_txtSifra.insets = new Insets(0, 0, 0, 5);
        gbc_txtSifra.fill = 2;
        gbc_txtSifra.gridx = 0;
        gbc_txtSifra.gridy = 3;
        this.add((Component)this.txtSifra, gbc_txtSifra);
        this.txtKataloskiBroj = BrowserSearchPanel.createPzTextField();
        this.txtKataloskiBroj.removeEnterBehaviour();
        this.txtKataloskiBroj.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                BrowserSearchPanel.this.cgr2KeyReleased(arg0);
            }
        });
        this.cgr2.add((Component)this.txtKataloskiBroj);
        GridBagConstraints gbc_txtKataloskiBroj = new GridBagConstraints();
        gbc_txtKataloskiBroj.anchor = 11;
        gbc_txtKataloskiBroj.insets = new Insets(0, 0, 0, 5);
        gbc_txtKataloskiBroj.fill = 2;
        gbc_txtKataloskiBroj.gridx = 1;
        gbc_txtKataloskiBroj.gridy = 3;
        this.add((Component)this.txtKataloskiBroj, gbc_txtKataloskiBroj);
        this.txtOeBroj = BrowserSearchPanel.createPzTextField();
        this.txtOeBroj.removeEnterBehaviour();
        this.txtOeBroj.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                BrowserSearchPanel.this.cgr2KeyReleased(arg0);
            }
        });
        this.cgr2.add((Component)this.txtOeBroj);
        GridBagConstraints gbc_txtOeBroj = new GridBagConstraints();
        gbc_txtOeBroj.anchor = 11;
        gbc_txtOeBroj.insets = new Insets(0, 0, 0, 5);
        gbc_txtOeBroj.fill = 2;
        gbc_txtOeBroj.gridx = 2;
        gbc_txtOeBroj.gridy = 3;
        this.add((Component)this.txtOeBroj, gbc_txtOeBroj);
        this.btnTrazi = new PzButton();
        this.btnTrazi.setText("Tra\u017ei");
        this.btnTrazi.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = 7410239984809721706L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserSearchPanel.this.btnTraziactionPerformed(arg0);
            }
        });
        this.btnTrazi.setShortcut("enter");
        this.btnTrazi.setIcon((Icon)new ImageIcon(BrowserSearchPanel.class.getResource("/rs/pezar/sifarnici/resource/img/find.png")));
        GridBagConstraints gbc_btnTrazi = new GridBagConstraints();
        gbc_btnTrazi.fill = 1;
        gbc_btnTrazi.insets = new Insets(0, 0, 0, 5);
        gbc_btnTrazi.gridx = 4;
        gbc_btnTrazi.gridy = 3;
        this.add((Component)this.btnTrazi, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.btnCisti = new PzButton();
        this.btnCisti.addActionListener((ActionListener)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserSearchPanel.this.btnPodesavanjeActionPerformed(arg0);
            }
        });
        this.btnCisti.setIcon((Icon)new ImageIcon(BrowserSearchPanel.class.getResource("/rs/pezar/sifarnici/resource/img/gear.png")));
        this.btnCisti.setText("Pode\u0161avanje");
        GridBagConstraints gbc_btnCisti = new GridBagConstraints();
        gbc_btnCisti.fill = 1;
        gbc_btnCisti.gridx = 4;
        gbc_btnCisti.gridy = 3;
        this.add((Component)this.btnCisti, new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.cbKolicina = new JCheckBox("Koli\u010dina pozitivna");
        this.txtPrSifra = BrowserSearchPanel.createPzTextField();
        this.txtPrSifra.removeEnterBehaviour();
        this.txtPrSifra.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                BrowserSearchPanel.this.cgr2KeyReleased(arg0);
            }
        });
        this.cgr2.add((Component)this.txtPrSifra);
        this.add((Component)this.txtPrSifra, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.lblPrSifra = new JLabel("Proiz. \u0161ifra (F11)");
        this.add(this.lblPrSifra, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void loadHints1() {
        this.txtModel.setAutoCompletionList((List)PzApplication.getApplication().getSession().getRuntimeStore().get("list_modeli"));
        this.txtDobavljac.setAutoCompletionList((List)PzApplication.getApplication().getSession().getRuntimeStore().get("list_komitenti"));
        this.txtProizvodjac.setAutoCompletionList((List)PzApplication.getApplication().getSession().getRuntimeStore().get("list_komitenti"));
    }

    protected PzShortcutListener getShortcutListener() {
        return new PzShortcutListener(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(PzShortcutListener.PzShortcutEvent evt) {
                String command = evt.getShortcut();
                if (command.equals("f8")) {
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                    BrowserSearchPanel.this.txtNaziv.requestFocusInWindow();
                    BrowserSearchPanel.this.txtNaziv.selectAll();
                } else if (command.equals("f9")) {
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                    BrowserSearchPanel.this.txtBliziOpis.requestFocusInWindow();
                } else if (command.equals("f5")) {
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                    BrowserSearchPanel.this.txtModel.requestFocusInWindow();
                } else if (command.equals("f4")) {
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                    BrowserSearchPanel.this.txtProizvodjac.requestFocusInWindow();
                } else if (command.equals("f6")) {
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                    BrowserSearchPanel.this.txtDobavljac.requestFocusInWindow();
                } else if (command.equals("f12")) {
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                    BrowserSearchPanel.this.txtRobnaGrupa.requestFocusInWindow();
                } else if (command.equals("alt+f11")) {
                    BrowserSearchPanel.this.txtOeBroj.setEnabled(true);
                    BrowserSearchPanel.this.txtOeBroj.requestFocusInWindow();
                } else if (command.equals("f7")) {
                    BrowserSearchPanel.this.txtSifra.setEnabled(true);
                    BrowserSearchPanel.this.txtSifra.requestFocusInWindow();
                } else if (command.equals("f10")) {
                    BrowserSearchPanel.this.txtKataloskiBroj.setEnabled(true);
                    BrowserSearchPanel.this.txtKataloskiBroj.requestFocusInWindow();
                } else if (command.equals("f11")) {
                    BrowserSearchPanel.this.txtPrSifra.setEnabled(true);
                    BrowserSearchPanel.this.txtPrSifra.requestFocusInWindow();
                } else if (command.equals("ctrl+q")) {
                    BrowserSearchPanel.this.cgr1.clearAll();
                    BrowserSearchPanel.this.cgr1.enableAll();
                    BrowserSearchPanel.this.cgr2.clearAll();
                    BrowserSearchPanel.this.cgr2.enableAll();
                }
            }
        };
    }

    public void setRadnajedinica(Radnajedinica rj) {
        this.rj = rj;
    }

    public void setTablePanel(BrowserTablePanel tablePanel) {
        this.tablePanel = tablePanel;
    }

    public void createEm() {
        this.em = PzEntityManagerFactory.getInstance().createEm();
    }

    public void closeEm() {
        if (this.em != null && this.em.isOpen()) {
            this.em.clear();
            this.em.close();
        }
    }

    public static PzTextField createPzTextField() {
        PzTextField field = new PzTextField();
        field.setFont(new Font("SansSerif", 0, 12));
        return field;
    }

    public static PzNumericOnlyTextField createPzNumericField() {
        PzNumericOnlyTextField field = new PzNumericOnlyTextField();
        field.setFont(new Font("SansSerif", 0, 12));
        return field;
    }

    protected void btnTraziactionPerformed(ActionEvent arg0) {
        if (this.rj != null) {
            this.searchInStanjeartikal();
        } else {
            this.searchInArtikal();
        }
    }

    public void searchInStanjeartikal() {
        if (this.tablePanel.isLocked()) {
            return;
        }
        this.tablePanel.setLocked(true);
        SwingWorker<List, Object> worker = new SwingWorker<List, Object>(){

            @Override
            protected List<Stanjeartikal> doInBackground() throws Exception {
                StopWatch sw = new StopWatch();
                sw.start();
                if (lastQuery != null && lastRj != null && lastRj.getId().equals((Object)BrowserSearchPanel.this.rj.getId())) {
                    BrowserSearchPanel.this.query = lastQuery;
                    BrowserSearchPanel.this.row = lastRow;
                    lastQuery = null;
                    lastRj = null;
                    lastRow = -1;
                    if (advancedSearch) {
                        BrowserSearchPanel.this.list = null;
                    } else {
                        try {
                            BrowserSearchPanel.this.list = (List)PzApplication.getApplication().getPropManager().loadBufferedObject("artikalLista.sav", Stanjeartikal.class.getClassLoader());
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    String kolicinaCriteria;
                    BrowserSearchPanel.this.list = null;
                    BrowserSearchPanel.this.query = BrowserSearchPanel.this.createQuery();
                    BrowserSearchPanel.this.row = 0;
                    String string = kolicinaCriteria = BrowserSearchPanel.this.cbKolicina.isSelected() ? " AND a.kolicina - a.alocKolicina > 0" : "";
                    if (BrowserSearchPanel.this.query != null && !BrowserSearchPanel.this.query.equals("") && !BrowserSearchPanel.this.query.toLowerCase().contains("order by")) {
                        BrowserSearchPanel browserSearchPanel = BrowserSearchPanel.this;
                        browserSearchPanel.query = String.valueOf(browserSearchPanel.query) + " AND a.id.oznRj = '" + BrowserSearchPanel.this.rj.getId().getOznRj() + "' AND a.id.oznOgranak='" + BrowserSearchPanel.this.rj.getId().getOznOgranak() + "'" + kolicinaCriteria + " ORDER BY a.naziv, a.bliziOpis";
                    }
                }
                if (BrowserSearchPanel.this.list == null) {
                    if (BrowserSearchPanel.this.query == null || BrowserSearchPanel.this.query.equals("")) {
                        return null;
                    }
                    Query q = BrowserSearchPanel.this.em.createQuery(BrowserSearchPanel.this.query);
                    q.setHint("eclipselink.read-only", (Object)true);
                    BrowserSearchPanel.this.list = q.getResultList();
                    BrowserSearchPanel.this.saveData(BrowserSearchPanel.this.list);
                }
                sw.stop();
                System.out.println("Search time : " + sw.getTimeInMills());
                return BrowserSearchPanel.this.list;
            }

            @Override
            protected void done() {
                try {
                    BrowserSearchPanel.this.tablePanel.saveTableState();
                    ArrayList l = (ArrayList)this.get();
                    if (l == null) {
                        if (BrowserSearchPanel.this.tablePanel.getTable() != null) {
                            l = new ArrayList();
                            BrowserSearchPanel.this.tablePanel.setData(Stanjeartikal.class, l);
                        }
                        return;
                    }
                    try {
                        BrowserSearchPanel.this.tablePanel.setData(Stanjeartikal.class, l);
                        if (l.size() > 0 && BrowserSearchPanel.this.row != -1) {
                            BrowserSearchPanel.this.row = this.findRow(BrowserSearchPanel.this.row);
                            BrowserSearchPanel.this.tablePanel.setSelectedRow(BrowserSearchPanel.this.row);
                            BrowserSearchPanel.this.tablePanel.getTable().scrollRowToVisible(BrowserSearchPanel.this.row);
                            BrowserSearchPanel.this.tablePanel.fireSelectionChanged();
                            BrowserSearchPanel.this.row = 0;
                        }
                        BrowserSearchPanel.this.lblBrPogodaka.setText("Broj pogodaka: " + l.size());
                        BrowserSearchPanel.this.list = null;
                        advancedSearch = false;
                        if (BrowserSearchPanel.this.action != null) {
                            BrowserSearchPanel.this.action.run();
                            BrowserSearchPanel.this.action = null;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)BrowserSearchPanel.this), (Throwable)e);
                    }
                }
                finally {
                    BrowserSearchPanel.this.tablePanel.setLocked(false);
                }
            }

            private int findRow(int row) {
                if (row != 0) {
                    return row;
                }
                int r = 0;
                int i = 0;
                while (i < BrowserSearchPanel.this.tablePanel.getTable().getRowCount() && r == 0) {
                    Stanjeartikal sa = (Stanjeartikal)BrowserSearchPanel.this.tablePanel.getTable().getEntity(i);
                    if (!BrowserSearchPanel.this.txtSifra.isEmpty() && sa.getId().getSfrProizvod().toLowerCase().equals(BrowserSearchPanel.this.txtSifra.getVal().toLowerCase().trim())) {
                        r = i;
                    } else if (!BrowserSearchPanel.this.txtKataloskiBroj.isEmpty() && sa.getDobSifra().toLowerCase().equals(BrowserSearchPanel.this.txtKataloskiBroj.getVal().toLowerCase().trim())) {
                        r = i;
                    } else if (!BrowserSearchPanel.this.txtPrSifra.isEmpty() && sa.getPrSifra().toLowerCase().equals(BrowserSearchPanel.this.txtPrSifra.getVal().toLowerCase().trim())) {
                        r = i;
                    }
                    ++i;
                }
                return r != 0 ? r : row;
            }
        };
        worker.execute();
    }

    private String createQuery() throws Exception {
        String query = "";
        if (this.txtNaziv.isEnabled()) {
            query = this.createQuery1(this.txtNaziv.getText().toLowerCase(), this.txtProizvodjac.getText().toLowerCase(), this.txtDobavljac.getText().toLowerCase(), this.txtModel.getText().toLowerCase(), this.txtBliziOpis.getText().toLowerCase(), this.txtRobnaGrupa.getText(), "", false, false);
        } else if (this.txtSifra.isEnabled()) {
            QueryTool1.PRETRAGA = this.pretragaSifra;
            query = QueryTool1.getPosQuery("sfrProizvod", this.txtSifra.getVal(), Stanjeartikal.class, this.rj);
        } else if (this.txtKataloskiBroj.isEnabled()) {
            QueryTool1.PRETRAGA = this.pretragaKatBroj;
            query = QueryTool1.getPosQuery("dobSifra", this.txtKataloskiBroj.getVal().toLowerCase(), Stanjeartikal.class, this.rj);
        } else if (this.txtOeBroj.isEnabled()) {
            query = this.createQuery2(this.txtOeBroj.getVal(), this.txtSifra.getVal(), false, false);
        } else if (this.txtPrSifra.isEnabled()) {
            query = QueryTool1.getPosQuery("prSifra", this.txtPrSifra.getVal(), Stanjeartikal.class, this.rj);
        }
        return query;
    }

    private FetchGroup createFetchGroupStanjeartikal() {
        if (this.grpStanjeArtikal == null) {
            FetchGroup grpId = new FetchGroup("id");
            grpId.addAttribute("sfrProizvod");
            grpId.addAttribute("oznRj");
            grpId.addAttribute("oznOgranak");
            this.grpStanjeArtikal = new FetchGroup("group");
            this.grpStanjeArtikal.addAttribute("id", grpId);
            this.grpStanjeArtikal.addAttribute("naziv");
            this.grpStanjeArtikal.addAttribute("bliziOpis");
            this.grpStanjeArtikal.addAttribute("jedMere");
            this.grpStanjeArtikal.addAttribute("kolicina");
            this.grpStanjeArtikal.addAttribute("alocKolicina");
            this.grpStanjeArtikal.addAttribute("konsKolicina");
            this.grpStanjeArtikal.addAttribute("konsAlocirana");
            this.grpStanjeArtikal.addAttribute("prodCena");
            this.grpStanjeArtikal.addAttribute("dobSifra");
            this.grpStanjeArtikal.addAttribute("nazivProizvodjac");
            this.grpStanjeArtikal.addAttribute("nazivModela");
            this.grpStanjeArtikal.addAttribute("standPak");
        }
        return this.grpStanjeArtikal;
    }

    private void saveData(final List<Stanjeartikal> l) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PzApplication.getApplication().getPropManager().saveBufferedObject((Object)l, "artikalLista.sav");
                }
                catch (IOException e) {
                    PzLogger.getInstance().logException((Throwable)e);
                }
            }
        });
        t.start();
    }

    private void searchInArtikal() {
        PzWorkerDialog.showStatus((String)"Pretraga u toku. Molim, sa\u010dekajte.", (PzDialog)((PzDialog)SwingUtilities.getRoot((Component)((Object)this))));
        SwingWorker<List<Artikal>, Object> worker = new SwingWorker<List<Artikal>, Object>(){

            @Override
            protected List<Artikal> doInBackground() throws Exception {
                String query = BrowserSearchPanel.this.txtNaziv.isEnabled() ? BrowserSearchPanel.this.createQuery1(BrowserSearchPanel.this.txtNaziv.getText().toLowerCase(), BrowserSearchPanel.this.txtProizvodjac.getText().toLowerCase(), BrowserSearchPanel.this.txtDobavljac.getText().toLowerCase(), BrowserSearchPanel.this.txtModel.getText().toLowerCase(), BrowserSearchPanel.this.txtBliziOpis.getText().toLowerCase(), BrowserSearchPanel.this.txtRobnaGrupa.getText(), BrowserSearchPanel.this.txtKataloskiBroj.getText(), false, true) : BrowserSearchPanel.this.createQuery2(BrowserSearchPanel.this.txtOeBroj.getText(), BrowserSearchPanel.this.txtSifra.getText(), false, true);
                Query q = BrowserSearchPanel.this.em.createQuery(query);
                return q.getResultList();
            }

            @Override
            protected void done() {
                try {
                    try {
                        List data = (List)this.get();
                        BrowserSearchPanel.this.tablePanel.setData(Artikal.class, data);
                        BrowserSearchPanel.this.lblBrPogodaka.setText("Broj pogodaka: " + data.size());
                        if (BrowserSearchPanel.this.action != null) {
                            BrowserSearchPanel.this.action.run();
                            BrowserSearchPanel.this.action = null;
                        }
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)BrowserSearchPanel.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public void saveQuery() {
        try {
            lastQuery = this.query;
            lastRj = this.rj;
            lastRow = this.tablePanel.getTable() != null ? this.tablePanel.getTable().getSelectedRow() : 0;
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    protected void cgr2KeyReleased(KeyEvent arg0) {
        JTextComponent field = (JTextComponent)arg0.getSource();
        if (field.getText().equals("")) {
            this.cgr1.enableAll();
            this.cgr2.enableAll();
        } else {
            this.cgr1.disableAll();
            this.cgr2.enable((Component)field);
        }
    }

    public String createQuery1(String naziv, String proizvodjac, String dobavljac, String model, String bliziOpis, String rgr, String katBroj, boolean brojPogodaka, boolean artikal) {
        String tableName = !artikal ? "Stanjeartikal" : "Artikal";
        String poljeProizvodjac = artikal ? "proizvodjac.naziv" : "nazivProizvodjac";
        String poljeDobavljac = artikal ? "dobavljac.naziv" : "nazivDobavljac";
        String poljeModel = artikal ? "model.naziv" : "nazivModela";
        String poljeRgr = artikal ? "robnagrupa.oznRobGr" : "oznRobGr";
        String query1 = "SELECT " + (brojPogodaka ? "COUNT(a)" : "a") + " FROM " + tableName + " a WHERE ";
        Robnagrupa rgrupa = rgr.equals("") ? null : (Robnagrupa)this.em.find(Robnagrupa.class, (Object)rgr.trim());
        String[] array = new String[]{this.createKritKeywordNaziv(naziv, "naziv"), this.createKritStartsWith(katBroj, "dobSifra"), this.createKritKeyword(proizvodjac, poljeProizvodjac), this.createKritKeyword(dobavljac, poljeDobavljac), this.createKritKeyword(model, poljeModel), this.createKritKeyword(bliziOpis, "bliziOpis"), rgrupa == null ? null : "a." + poljeRgr + " IN " + ((Robnagrupa)this.em.find(Robnagrupa.class, (Object)rgr.trim())).getRobnaGrupaListAsString()};
        String query2 = "";
        boolean first = true;
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                query2 = String.valueOf(query2) + (i != 0 && !first ? " AND " : "") + array[i];
                first = false;
            }
            ++i;
        }
        return !"".equals(query2) ? String.valueOf(query1) + query2 : null;
    }

    private String createKritKeywordNaziv(String input, String nazivPolja) {
        if (input.equals("")) {
            return null;
        }
        if (input.length() == 1) {
            return "( LOWER(a." + nazivPolja + ") LIKE '" + input + "%' ) ";
        }
        if (this.pretragaNaziv.equals("po_pocetku")) {
            return "( LOWER(a." + nazivPolja + ") LIKE '" + input + "%' ) ";
        }
        String result = "(";
        String[] parts = input.split(" ");
        String temp = "";
        int i = 0;
        while (i < parts.length) {
            temp = parts[i].contains("*") ? parts[i].replace("*", "%").trim() : "%" + parts[i].trim() + "%";
            result = String.valueOf(result) + (i > 0 ? "AND " : "") + "LOWER(a." + nazivPolja + ") LIKE '" + temp + "'";
            ++i;
        }
        return String.valueOf(result) + ")";
    }

    private String createKritKeyword(String input, String nazivPolja) {
        if (input.equals("")) {
            return null;
        }
        if (input.length() == 1) {
            return "( LOWER(a." + nazivPolja + ") LIKE '" + input + "%' ) ";
        }
        if (input.contains("*")) {
            return "( LOWER(a." + nazivPolja + ") LIKE '" + input.replace("*", "%") + "' ) ";
        }
        String result = "(";
        String[] parts = input.split(" ");
        String temp = "";
        int i = 0;
        while (i < parts.length) {
            temp = parts[i].contains("*") ? parts[i].replace("*", "%").trim() : "%" + parts[i].trim() + "%";
            result = String.valueOf(result) + (i > 0 ? "AND " : "") + "LOWER(a." + nazivPolja + ") LIKE '" + temp + "'";
            ++i;
        }
        return String.valueOf(result) + ")";
    }

    private String createKritStartsWith(String input, String nazivPolja) {
        if (input.equals("")) {
            return null;
        }
        String result = "(";
        String[] parts = input.split(" ");
        int i = 0;
        while (i < parts.length) {
            result = String.valueOf(result) + (i > 0 ? "AND " : "") + "LOWER(a." + nazivPolja + ") LIKE '" + parts[i].trim() + "%'";
            ++i;
        }
        return String.valueOf(result) + ")";
    }

    public String createQuery2(String oeBroj, String sifra, boolean brojPogodaka, boolean artikal) {
        String tableName = !artikal ? "Stanjeartikal" : "Artikal";
        String poljeSifra = artikal ? "sfrProizvod" : "id.sfrProizvod";
        String query = "SELECT " + (brojPogodaka ? "COUNT(a)" : "a") + " FROM " + tableName + " a ";
        if (!oeBroj.equals("")) {
            query = String.valueOf(query) + ", OEBroj oe WHERE a." + poljeSifra + " = oe.id.sfrProizvod AND LOWER(oe.oemStripped) LIKE '" + oeBroj.replaceAll("\\.|-|\\s", "").toLowerCase().trim() + "%'";
        }
        if (!sifra.equals("")) {
            query = String.valueOf(query) + "WHERE a." + poljeSifra + " LIKE '" + sifra.trim() + "%'";
        }
        return query;
    }

    protected void btnPodesavanjeActionPerformed(ActionEvent arg0) {
        ((PzDialog)SwingUtilities.getRoot((Component)((Object)this))).showDialog(PodesavanjePretrage.class);
    }

    protected void btnCistiactionPerformed(ActionEvent arg0) {
        this.cgr1.clearAll();
        this.cgr1.enableAll();
        this.cgr2.clearAll();
        this.cgr2.enableAll();
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
    }

    @Override
    public void updateData(Stanjeartikal a, Object parentComponent) {
    }

    @Override
    public void focusGained() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    BrowserSearchPanel.this.txtNaziv.requestFocus();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void thisancestorAdded(AncestorEvent arg0) {
        ((PzDialog)SwingUtilities.getRoot((Component)((Object)this))).setShortcutListener(this.getShortcutListener());
        ((PzDialog)SwingUtilities.getRoot((Component)((Object)this))).registerShortcuts(new String[]{"f4", "f5", "f6", "f7", "f8", "f9", "f10", "alt+f11", "f12", "f11", "ctrl+q"});
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "Pretraga";
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    public void setLabelBrPogodaka(JLabel lblBrPogodaka) {
        this.lblBrPogodaka = lblBrPogodaka;
    }

    public void search(String query, Radnajedinica rj, BrowserQueryAction action) {
        this.action = action;
        this.rj = rj;
        lastQuery = query;
        lastRj = rj;
        advancedSearch = true;
        if (rj != null) {
            this.searchInStanjeartikal();
        } else {
            this.searchInArtikal();
        }
    }

    @Override
    public void setEntity(PzEntity e, Component c) {
        if (c == this.txtRobnaGrupa) {
            this.txtRobnaGrupa.setVal((Object)((Robnagrupa)e).getOznRobGr());
        }
    }

    public void purge() {
        this.cgr1.clearAll();
        this.cgr1.enableAll();
        this.cgr2.clearAll();
        this.cgr2.enableAll();
    }
}

