/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.artikli.browser.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import rs.pezar.core.PzApplication;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.artikli.browser.component.BrowserComponent;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzManageableTable;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.renderers.PzDoubleCellRenderer;
import rs.pezar.swing.renderers.StanjeRenderer;
import rs.pezar.util.RabatnaPolitikaManager;

public class BrowserTablePanel
extends BrowserComponent {
    private static final long serialVersionUID = -7978490052216939819L;
    public static final String ID = "TABLE_PANEL";
    private JScrollPane scp;
    private PzTable pzTable;
    private PzManageableTable table;
    private PzPanel content;
    private PzBusyPainterUI layerUI;
    private JXLayer<JScrollPane> layer;
    private Vector<BrowserComponent> subscribers;
    private Radnajedinica rj;
    private int selrow;
    boolean wait = false;
    private Timer t;
    private final StanjeRenderer r = new StanjeRenderer();

    public BrowserTablePanel() {
        this.initGUI();
        this.setComponentLocation(new BrowserComponent.Location(0, 1, 1, 1));
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.content = new PzPanel();
        this.add((Component)this.content, "Center");
        this.content.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.scp = new JScrollPane();
        this.layerUI = new PzBusyPainterUI();
        this.layer = new JXLayer((Component)this.scp, (LayerUI)this.layerUI);
        this.content.add(this.layer);
    }

    public PzManageableTable getTable() {
        return this.table;
    }

    public void setData(Class<?> entityClass, List data) {
        if (this.pzTable == null) {
            this.pzTable = new PzTable();
            this.pzTable.getActionMap().put("ENTER", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (((PzDialog)SwingUtilities.getRoot((Component)((Object)BrowserTablePanel.this))).shouldCloseOnEnter()) {
                        PzTable.selectedEntity = (PzEntity)BrowserTablePanel.this.getSelectedEntity();
                        BrowserTablePanel.this.pzTable.closeDialog();
                    }
                }
            });
            this.pzTable.getSelectionModel().addListSelectionListener(this.getSelectionListener());
            this.table = this.pzTable;
            this.pzTable.setId("PZ_TABLE." + this.rj.getTip());
            this.scp.setViewportView((Component)this.pzTable);
        }
        this.pzTable.setData(data, entityClass);
        this.pzTable.getColumnByName("<html>Rasp. Koli\u010dina<br/>(Magacin)</html>").setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKolicinaFormat()));
        this.pzTable.getColumnByName("<html>Aloc. Koli\u010dina<br/>(Magacin)</html>").setCellRenderer((TableCellRenderer)new PzDoubleCellRenderer(PzFormatFactory.getKolicinaFormat()));
        System.out.println(this.pzTable.getColumnName(5));
        this.adjustColumn0();
        this.requestFocus();
    }

    public void saveTableState() {
        try {
            if (this.getTable() != null) {
                PzApplication.getApplication().getSession().getSessionStorage().save((Component)this.getTable(), String.valueOf(SwingUtilities.getRoot((Component)((Object)this)).getClass().getName()) + "." + this.getTable().getId() + ".xml");
            }
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void setSelectedRow(int row) {
        if (row == -1) {
            return;
        }
        if (this.table != null) {
            this.table.setRowSelectionInterval(row, row);
        }
        this.selrow = row;
    }

    @Override
    public void updateData(Artikal a, Object parentComponent) {
    }

    @Override
    public void updateData(Stanjeartikal a, Object parentComponent) {
    }

    @Override
    public void focusGained() {
    }

    public void setLocked(boolean locked) {
        if (this.pzTable != null) {
            this.pzTable.setVisible(!locked);
        }
        if (this.layerUI != null) {
            this.layerUI.setLocked(locked);
        }
    }

    public boolean isLocked() {
        return this.layerUI.isLocked();
    }

    public void requestFocus() {
        super.requestFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (BrowserTablePanel.this.pzTable != null) {
                    BrowserTablePanel.this.pzTable.requestFocus();
                }
            }
        });
    }

    public void addSubscriber(BrowserComponent component) {
        if (this.subscribers == null) {
            this.subscribers = new Vector();
        }
        this.subscribers.add(component);
    }

    private ListSelectionListener getSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BrowserTablePanel.this.wait = true;
            }
        };
    }

    public void fireSelectionChanged() {
        if (!this.getBrowser().isVisible()) {
            return;
        }
        if (this.table == null) {
            return;
        }
        Artikal a = null;
        Stanjeartikal sa = null;
        if (this.table.getSelectedEntity() instanceof Artikal) {
            a = (Artikal)this.table.getSelectedEntity();
        } else {
            RabatnaPolitikaManager rpm;
            sa = (Stanjeartikal)this.table.getSelectedEntity();
            if (sa != null) {
                sa = (Stanjeartikal)PzEntityManager.findEntity(Stanjeartikal.class, (Object)sa.getId());
                this.table.updateSelectedEntity((PzEntity)sa, false);
            }
            if ((rpm = (RabatnaPolitikaManager)PzApplication.getApplication().getSession().getRuntimeStore().get("RPM_TEKUCI_KOMITENT")) != null) {
                try {
                    rpm.primeniRabat(sa);
                }
                catch (Exception e) {
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            }
        }
        for (BrowserComponent subscriber : this.subscribers) {
            if (!subscriber.isVisible()) continue;
            if (this.table.getSelectedEntity() instanceof Artikal) {
                subscriber.updateData(a, (Object)this);
                continue;
            }
            subscriber.updateData(sa, (Object)this);
        }
    }

    public Object getSelectedEntity() {
        return this.table != null ? this.table.getSelectedEntity() : null;
    }

    public void setRadnajedinica(Radnajedinica rj) {
        this.rj = rj;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getTitle() {
        return "Rezultati pretrage";
    }

    @Override
    public boolean isCloseable() {
        return false;
    }

    public void activateTimer() {
        this.selrow = -1;
        if (this.t != null) {
            this.t.restart();
        } else {
            this.t = new Timer(400, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (BrowserTablePanel.this.table != null && BrowserTablePanel.this.table.getRowCount() > 0) {
                        if (BrowserTablePanel.this.table.getSelectedRow() == BrowserTablePanel.this.selrow) {
                            return;
                        }
                        if (!BrowserTablePanel.this.wait) {
                            BrowserTablePanel.this.fireSelectionChanged();
                            BrowserTablePanel.this.selrow = BrowserTablePanel.this.table.getSelectedRow();
                        }
                        BrowserTablePanel.this.wait = false;
                    }
                }
            });
        }
        this.t.start();
    }

    public void deactivateTimer() {
        if (this.t.isRunning()) {
            this.t.stop();
        }
    }

    private void adjustColumn0() {
        if (this.table.convertColumnIndexToView(0) != -1 && this.table.getColumn(0).getCellRenderer() != this.r) {
            this.table.getColumn(0).setMinWidth(20);
            this.table.getColumn(0).setMaxWidth(20);
            this.table.getColumn(0).setPreferredWidth(20);
            this.table.getColumn(0).setCellRenderer((TableCellRenderer)this.r);
        }
    }
}

