/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.grupeKomitenata;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentgrupa;
import rs.pezar.sifarnici.gui.grupeKomitenata.DodavanjeClana;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class SadrzajGrupe
extends PzDialog {
    private static String KORISNICKA_GRUPA = "korisnickaGrupa";
    private static String KRITICNA_GRUPA = "kriticnaGrupa";
    private static String CRNA_GRUPA = "crnaGrupa";
    private static String KRITICNA_GRUPA_TIP = "KRITICNA";
    private static String CRNA_GRUPA_TIP = "CRNA";
    private PzPanel pnlGlavni;
    private JToolBar toolbar;
    private PzToolBarIcon icnNoviClan;
    private PzToolBarIcon icnBrisanjeClana;
    private JScrollPane scrollPane;
    private PzTable tblClanovi;
    private Komitentgrupa grupa;
    private final String parameter;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brStavki = new JLabel();

    public SadrzajGrupe(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.postInit();
        this.initializeTable();
    }

    public SadrzajGrupe(PzDialog dialog) {
        super(dialog);
        this.parameter = KORISNICKA_GRUPA;
        this.initGUI();
        this.postInit();
        this.initializeTable();
    }

    private void postInit() {
        if (this.parameter.equals(KORISNICKA_GRUPA)) {
            this.grupa = (Komitentgrupa)this.getSession().getParameter("grupa");
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.BLUE, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
        } else if (this.parameter.equals(KRITICNA_GRUPA)) {
            this.grupa = this.getGrupa(KRITICNA_GRUPA);
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.RED, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
        } else if (this.parameter.equals(CRNA_GRUPA)) {
            this.grupa = this.getGrupa(CRNA_GRUPA);
            this.pnlGlavni.setPaintGradient(true);
            this.pnlGlavni.setGradient(Color.BLACK, Color.WHITE, PzPanel.GRADIENT_SOUTH_NORTH);
        }
        this.setTitle("Sadr\u017eaj grupe - " + this.grupa.getNaziv());
    }

    private void initializeTable() {
        this.tblClanovi.setData(this.grupa.getKomitents(), Komitent.class);
        this.brStavki.setText(Integer.toString(this.grupa.getKomitents().size()));
    }

    private Komitentgrupa getGrupa(String tip) {
        EntityManager em = PzEntityManager.getEm();
        Komitentgrupa grupa = null;
        Query q = em.createQuery("SELECT g FROM Komitentgrupa g Where g.tip=:tip");
        if (tip.equals(KRITICNA_GRUPA)) {
            q.setParameter("tip", (Object)KRITICNA_GRUPA_TIP);
        } else {
            q.setParameter("tip", (Object)CRNA_GRUPA_TIP);
        }
        try {
            grupa = (Komitentgrupa)q.getSingleResult();
        }
        catch (Exception exception) {
            grupa = null;
        }
        if (grupa == null) {
            em.getTransaction().begin();
            grupa = new Komitentgrupa();
            Integer broj = (Integer)em.createQuery("SELECT MAX(g.idKomitentGrupa) FROM Komitentgrupa g ").getSingleResult();
            broj = broj == null ? Integer.valueOf(1) : Integer.valueOf(broj + 1);
            grupa.setIdKomitentGrupa(broj);
            if (tip.equals(KRITICNA_GRUPA)) {
                grupa.setNaziv("Kriticna grupa");
                grupa.setTip(KRITICNA_GRUPA_TIP);
            } else {
                grupa.setNaziv("Crna grupa");
                grupa.setTip(CRNA_GRUPA_TIP);
            }
            grupa.setPzuser(PzApplication.getApplication().getSession().getLoggedUser());
            em.persist((Object)grupa);
            em.getTransaction().commit();
        }
        return grupa;
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.1, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{101, 7, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnNoviClan = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnNoviClan);
            this.icnNoviClan.setText("Dodavanje|(INS)");
            this.icnNoviClan.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessman_new.png")));
            this.icnNoviClan.setActionCommand("dodaj");
            this.icnNoviClan.addActionListener((ActionListener)((Object)this));
            this.icnNoviClan.setShortcut("INSERT");
            this.icnBrisanjeClana = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanjeClana);
            this.icnBrisanjeClana.setText("Brisanje|(DELETE)");
            this.icnBrisanjeClana.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessman_delete.png")));
            this.icnBrisanjeClana.setActionCommand("brisi");
            this.icnBrisanjeClana.addActionListener((ActionListener)((Object)this));
            this.icnBrisanjeClana.setShortcut("DELETE");
            this.scrollPane = new JScrollPane();
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tblClanovi = new PzTable();
            this.scrollPane.setViewportView((Component)this.tblClanovi);
            this.tblClanovi.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Komitent dok = (Komitent)entity;
                    return new Object[]{dok.getSfrKomitent(), dok.getNaziv()};
                }

                public String[] getColumnNames() {
                    return new String[]{"\u0160ifra komitenta", "Naziv komitenta"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj komitenata u grupi");
            this.statusBar.add((Component)this.brStavki);
            this.brStavki.setFocusable(false);
            this.brStavki.setOpaque(false);
            this.setSize(627, 410);
            this.setMinimumSize(new Dimension(537, 410));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                int rez;
                if (actionCommand.equals("dodaj")) {
                    if (!this.parameter.equals(KORISNICKA_GRUPA)) {
                        this.getSession().putParameter("grupa", (Object)this.grupa);
                    }
                    this.getSession().putParameter("update", (Object)false);
                    this.showDialog(DodavanjeClana.class);
                    this.initializeTable();
                } else if (actionCommand.equals("brisi") && this.tblClanovi.getSelectedRow() != -1 && (rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false)) == 0) {
                    em.getTransaction().begin();
                    List clanovi = this.grupa.getKomitents();
                    clanovi.remove(this.tblClanovi.getSelectedEntity());
                    this.grupa.setKomitents(clanovi);
                    em.merge((Object)this.grupa);
                    em.getTransaction().commit();
                    this.initializeTable();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

