/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.komintenti;

import com.cloudgarden.resource.ArrayFocusTraversalPolicy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Email;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.db.entity.KomitentparameterPK;
import rs.pezar.db.entity.Tekuciracun;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzChoice;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzRadioGroup;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.event.PzRadioGroupEvent;
import rs.pezar.swing.event.PzRadioGroupListener;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.webservice.client.nbs.NBS;

public class Dodavanje
extends PzDialogInsert {
    private static final String TEREN = "TEREN";
    private static final long serialVersionUID = -3362895422040638148L;
    private PzPanel panel;
    private PzFieldIndikator indNaziv;
    private PzFieldIndikator indSifra;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private PzTextField registracioni;
    private PzNumericOnlyTextField maticni;
    private PzTextField email;
    private PzNumericOnlyTextField oznakaPIB;
    private PzTextField delatnost;
    private PzTextField brojFaxa;
    private PzTextField telefoni;
    private PzTextField grad;
    private PzTextField adresa;
    private PzTextField kontakt;
    private PzTextField pdvBroj;
    private PzTextField zemlja;
    private PzButton btnOK;
    private PzTextField naziv;
    private PzNumericOnlyTextField sifra;
    private PzNumericOnlyTextField postanskiBr;
    private PzFieldIndikator indBrojFaxa;
    private JCheckBox maticnaFirma;
    private PzTextField tfPak;
    private JLabel lblPAK;
    private JLabel lblVal;
    private PzTextField txtValuta;
    private PzRadioGroup rgrValuta;
    private JPanel pnlValuta;
    private JLabel lblTeren;
    private PzTextField tfTeren;
    private JLabel lblTolDana;
    private JLabel lblValDana;
    private PzIntegerField tfTolerancijaPlacanja;
    private JLabel lblTolerancija;
    private PzIntegerField tfValutniLimit;
    private JLabel lblValutaLimit;
    private PzDoubleField dfNovcaniLimit;
    private JLabel lblNovcaniLimit;
    private JComboBox cbTip;
    private JLabel jLabel14;
    private PzFieldIndikator indOznakaPIB;
    private PzFieldIndikator indPostanskiBr;
    private PzFieldIndikator indGrad;
    private PzFieldIndikator indAdresa;
    private PzFieldIndikator indZemlja;
    private PzFieldIndikator indPDVbroj;
    private JCheckBox pravnoLice;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel13;
    private JLabel jLabel12;
    private JLabel jLabel5;
    private JLabel jLabel11;
    private JLabel jLabel10;
    private JLabel jLabel9;
    private JLabel jLabel8;
    private JLabel jLabel7;
    private JLabel jLabel6;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private PzPanelHeader header;
    private ButtonGroup buttonGroupPDV;
    private ButtonGroup buttonGroupZemlja;
    private ButtonGroup buttonGroupRegija;
    private JRadioButton srbija;
    private JRadioButton kosovo;
    private JRadioButton domaci;
    private JRadioButton inostrani;
    private JRadioButton nijePdvObveznik;
    private JRadioButton jestePdvObveznik;
    private Komitent komitent;
    private Komitentparameter kp;
    private Komitentparameter pak;
    private PzTable tabela;
    private Komitentparameter kpT;
    private static final String DOMACA = "Doma\u0107a";
    private static final String STRANA = "Strana";

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                Dodavanje inst = new Dodavanje(frame);
                inst.setVisible(true);
            }
        });
    }

    public Dodavanje() {
    }

    public Dodavanje(JFrame frame) {
        super(frame);
    }

    public Dodavanje(PzDialog dialog) {
        super(dialog);
    }

    public Dodavanje(PzDialog dialog, boolean izmena, Object data1, Object data2) {
        super(dialog, izmena, (PzTable)data1, data2);
    }

    protected void initGUI() {
        try {
            this.header = new PzPanelHeader();
            this.header.setIcon(this.getHeaderIcon());
            this.header.setTitle(this.getHeaderTitle());
            this.getContentPane().add((Component)this.header, "North");
            this.panel = new PzPanel();
            this.getContentPane().add((Component)this.panel, "Center");
            GridBagLayout panelLayout = new GridBagLayout();
            panelLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            int[] nArray = new int[19];
            nArray[2] = 26;
            nArray[3] = 7;
            nArray[4] = 7;
            nArray[5] = 7;
            nArray[6] = 7;
            nArray[7] = 7;
            nArray[8] = 7;
            nArray[9] = 7;
            nArray[10] = 7;
            nArray[11] = 26;
            nArray[12] = 20;
            nArray[13] = 20;
            nArray[14] = 7;
            nArray[15] = 7;
            nArray[16] = 29;
            nArray[17] = 20;
            nArray[18] = 20;
            panelLayout.rowHeights = nArray;
            panelLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.0, 0.0, 0.0, 0.1, 0.1};
            panelLayout.columnWidths = new int[]{129, 115, 135, 40, 33, 20, 20, 7};
            this.panel.setLayout((LayoutManager)panelLayout);
            this.panel.setName("panel");
            this.jLabel1 = new JLabel();
            this.panel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel1.setName("jLabel1");
            this.jLabel2 = new JLabel();
            this.panel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel2.setName("jLabel2");
            this.jLabel3 = new JLabel();
            this.panel.add((Component)this.jLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel3.setName("jLabel3");
            this.jLabel4 = new JLabel();
            this.panel.add((Component)this.jLabel4, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel4.setName("jLabel4");
            this.jLabel5 = new JLabel();
            this.panel.add((Component)this.jLabel5, (Object)new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel5.setName("jLabel5");
            this.jLabel6 = new JLabel();
            this.panel.add((Component)this.jLabel6, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel6.setName("jLabel6");
            this.jLabel7 = new JLabel();
            this.panel.add((Component)this.jLabel7, (Object)new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel7.setName("jLabel7");
            this.jLabel8 = new JLabel();
            this.panel.add((Component)this.jLabel8, (Object)new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel8.setName("jLabel8");
            this.jLabel9 = new JLabel();
            this.panel.add((Component)this.jLabel9, (Object)new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel9.setName("jLabel9");
            this.jLabel10 = new JLabel();
            this.panel.add((Component)this.jLabel10, (Object)new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel10.setName("jLabel10");
            this.jLabel11 = new JLabel();
            this.panel.add((Component)this.jLabel11, (Object)new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel11.setName("jLabel11");
            this.jLabel12 = new JLabel();
            this.panel.add((Component)this.jLabel12, (Object)new GridBagConstraints(0, 14, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel12.setName("jLabel12");
            this.jLabel13 = new JLabel();
            this.panel.add((Component)this.jLabel13, (Object)new GridBagConstraints(0, 15, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel13.setName("jLabel13");
            this.pravnoLice = new JCheckBox();
            this.panel.add((Component)this.pravnoLice, (Object)new GridBagConstraints(4, 15, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.pravnoLice.setText("Povezano pravno lice");
            this.sifra = new PzNumericOnlyTextField();
            this.panel.add((Component)this.sifra, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.sifra.setVerifyInput(true);
            this.sifra.setPKField(Komitent.class, null);
            this.naziv = new PzTextField();
            this.panel.add((Component)this.naziv, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.naziv.setVerifyInput(true);
            this.postanskiBr = new PzNumericOnlyTextField();
            this.panel.add((Component)this.postanskiBr, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.postanskiBr.setVerifyInput(true);
            this.postanskiBr.setMaxLength(5);
            this.adresa = new PzTextField();
            this.panel.add((Component)this.adresa, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.adresa.setVerifyInput(true);
            this.grad = new PzTextField();
            this.panel.add((Component)this.grad, (Object)new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.grad.setVerifyInput(true);
            this.telefoni = new PzTextField();
            this.panel.add((Component)this.telefoni, (Object)new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.brojFaxa = new PzTextField();
            this.panel.add((Component)this.brojFaxa, (Object)new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.brojFaxa.setMaxLength(30);
            this.delatnost = new PzTextField();
            this.panel.add((Component)this.delatnost, (Object)new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.delatnost.setMaxLength(8);
            this.oznakaPIB = new PzNumericOnlyTextField();
            this.panel.add((Component)this.oznakaPIB, (Object)new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.oznakaPIB.setMaxLength(15);
            this.oznakaPIB.setVerifyInput(true);
            this.email = new PzTextField();
            this.panel.add((Component)this.email, (Object)new GridBagConstraints(1, 14, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.kontakt = new PzTextField();
            this.panel.add((Component)this.kontakt, (Object)new GridBagConstraints(1, 15, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.maticni = new PzNumericOnlyTextField();
            this.panel.add((Component)this.maticni, (Object)new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.maticni.setFont(new Font("Tahoma", 0, 14));
            this.maticni.setMaxLength(13);
            this.jPanel1 = new JPanel();
            VerticalLayout jPanel1Layout = new VerticalLayout(1);
            jPanel1Layout.setGap(5);
            this.panel.add((Component)this.jPanel1, (Object)new GridBagConstraints(4, 1, 3, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder("PDV"));
            this.jPanel1.setPreferredSize(new Dimension(420, 90));
            this.jLabel17 = new JLabel();
            this.jLabel17.setText("PDV broj");
            this.buttonGroupPDV = new ButtonGroup();
            this.nijePdvObveznik = new JRadioButton("Nije obveznik PDV-a");
            this.jestePdvObveznik = new JRadioButton("Obveznik PDV-a");
            this.jestePdvObveznik.setSelected(true);
            this.nijePdvObveznik.setActionCommand("nijePdvObveznik");
            this.nijePdvObveznik.addActionListener((ActionListener)((Object)this));
            this.jestePdvObveznik.setActionCommand("jestePdvObveznik");
            this.jestePdvObveznik.addActionListener((ActionListener)((Object)this));
            this.jPanel1.add((Component)this.jestePdvObveznik, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jPanel1.add((Component)this.nijePdvObveznik, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonGroupPDV.add(this.nijePdvObveznik);
            this.buttonGroupPDV.add(this.jestePdvObveznik);
            this.jPanel2 = new JPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.panel.add((Component)this.jPanel2, (Object)new GridBagConstraints(4, 4, 3, 7, 0.0, 0.0, 10, 1, new Insets(5, 0, 10, 5), 0, 0));
            jPanel2Layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            jPanel2Layout.rowHeights = new int[]{22, 22, 22, 22, 22, 25};
            jPanel2Layout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            jPanel2Layout.columnWidths = new int[]{25, 111, 7, 7};
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setBorder(BorderFactory.createTitledBorder("Zemlja komitenta"));
            this.buttonGroupRegija = new ButtonGroup();
            this.srbija = new JRadioButton("Srbija");
            this.srbija.setSelected(true);
            this.jPanel2.add((Component)this.srbija, new GridBagConstraints(1, 1, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.kosovo = new JRadioButton("Kosovo");
            this.jPanel2.add((Component)this.kosovo, new GridBagConstraints(1, 2, 3, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonGroupRegija.add(this.srbija);
            this.buttonGroupRegija.add(this.kosovo);
            this.buttonGroupZemlja = new ButtonGroup();
            this.domaci = new JRadioButton("Domaci komitent");
            this.domaci.setSelected(true);
            this.domaci.setActionCommand("domaci");
            this.domaci.addActionListener((ActionListener)((Object)this));
            this.jPanel2.add((Component)this.domaci, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.inostrani = new JRadioButton("Inostrani komitent");
            this.inostrani.setActionCommand("inostrani");
            this.inostrani.addActionListener((ActionListener)((Object)this));
            this.jPanel2.add((Component)this.inostrani, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.buttonGroupZemlja.add(this.domaci);
            this.domaci.setName("domaci");
            this.buttonGroupZemlja.add(this.inostrani);
            this.jLabel18 = new JLabel();
            this.jPanel2.add((Component)this.jLabel18, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jLabel18.setText("Zemlja komitenta");
            this.zemlja = new PzTextField();
            this.jPanel2.add((Component)this.zemlja, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.zemlja.setEnabled(false);
            this.zemlja.setMaxLength(20);
            this.zemlja.setVerifyInput(true);
            this.indZemlja = new PzFieldIndikator();
            this.jPanel2.add((Component)this.indZemlja, new GridBagConstraints(3, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indZemlja.setVisible(false);
            this.zemlja.setStateIndikator(this.indZemlja);
            this.registracioni = new PzTextField();
            this.panel.add((Component)this.registracioni, (Object)new GridBagConstraints(1, 9, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.registracioni.setMaxLength(12);
            this.indSifra = new PzFieldIndikator();
            this.panel.add((Component)this.indSifra, (Object)new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indNaziv = new PzFieldIndikator();
            this.panel.add((Component)this.indNaziv, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indAdresa = new PzFieldIndikator();
            this.panel.add((Component)this.indAdresa, (Object)new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indGrad = new PzFieldIndikator();
            this.panel.add((Component)this.indGrad, (Object)new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indPostanskiBr = new PzFieldIndikator();
            this.panel.add((Component)this.indPostanskiBr, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.indBrojFaxa = new PzFieldIndikator();
            this.indOznakaPIB = new PzFieldIndikator();
            this.panel.add((Component)this.indOznakaPIB, (Object)new GridBagConstraints(3, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.jLabel14 = new JLabel();
            this.panel.add((Component)this.jLabel14, (Object)new GridBagConstraints(4, 14, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.jLabel14.setName("jLabel14");
            this.cbTip = new JComboBox();
            this.panel.add((Component)this.cbTip, (Object)new GridBagConstraints(5, 14, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 3, 100), 0, 0));
            this.cbTip.addItem(new PzChoice("Pravno lice", (Object)0));
            this.cbTip.addItem(new PzChoice("Banka", (Object)1));
            this.cbTip.addItem(new PzChoice("Fizi\u010dko lice", (Object)2));
            this.cbTip.addItem(new PzChoice("Carina", (Object)3));
            this.cbTip.setName("cbTip");
            this.lblNovcaniLimit = new JLabel("Nov\u010dani limit:");
            this.panel.add((Component)this.lblNovcaniLimit, (Object)new GridBagConstraints(0, 11, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblNovcaniLimit.setName("lblNovcaniLimit");
            this.dfNovcaniLimit = new PzDoubleField();
            this.panel.add((Component)this.dfNovcaniLimit, (Object)new GridBagConstraints(1, 11, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.dfNovcaniLimit.setName("dfNovcaniLimit");
            this.btnOK = new PzButton();
            this.btnOK.setText("Unesi podatke");
            this.panel.add((Component)this.btnOK, (Object)new GridBagConstraints(1, 18, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnOK.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/check.png")));
            this.btnOK.setName("btnOK");
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.lblValutaLimit = new JLabel();
            this.panel.add((Component)this.lblValutaLimit, (Object)new GridBagConstraints(0, 12, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblValutaLimit.setName("lblValutaLimit");
            this.tfValutniLimit = new PzIntegerField();
            this.panel.add((Component)this.tfValutniLimit, (Object)new GridBagConstraints(1, 12, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblTolerancija = new JLabel();
            this.panel.add((Component)this.lblTolerancija, (Object)new GridBagConstraints(0, 13, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblTolerancija.setName("lblTolerancija");
            this.tfTolerancijaPlacanja = new PzIntegerField();
            this.panel.add((Component)this.tfTolerancijaPlacanja, (Object)new GridBagConstraints(1, 13, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblValDana = new JLabel();
            this.panel.add((Component)this.lblValDana, (Object)new GridBagConstraints(2, 12, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblValDana.setName("lblValDana");
            this.lblTolDana = new JLabel();
            this.panel.add((Component)this.lblTolDana, (Object)new GridBagConstraints(2, 13, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblTolDana.setName("lblTolDana");
            this.tfTeren = new PzTextField();
            this.panel.add((Component)this.tfTeren, (Object)new GridBagConstraints(1, 16, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.lblTeren = new JLabel();
            this.panel.add((Component)this.lblTeren, (Object)new GridBagConstraints(0, 16, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblTeren.setName("lblTeren");
            this.pnlValuta = new JPanel();
            GridBagLayout pnlValutaLayout = new GridBagLayout();
            this.panel.add((Component)this.pnlValuta, (Object)new GridBagConstraints(4, 11, 3, 3, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlValuta.setBorder(BorderFactory.createTitledBorder(null, "Valuta za fakturisanje", 4, 0));
            pnlValutaLayout.rowWeights = new double[]{0.1, 0.1};
            pnlValutaLayout.rowHeights = new int[]{7, 7};
            pnlValutaLayout.columnWeights = new double[]{0.0, 0.0};
            pnlValutaLayout.columnWidths = new int[]{7, 7};
            this.pnlValuta.setLayout(pnlValutaLayout);
            this.rgrValuta = new PzRadioGroup();
            this.rgrValuta.setValues((Object[])new String[]{DOMACA, STRANA});
            this.rgrValuta.setSelectedIndex(0);
            this.rgrValuta.addRadioGroupListener(new PzRadioGroupListener(){

                public void selectionChanged(PzRadioGroupEvent evt) {
                    Dodavanje.this.rgrValutaSelectionChanged(evt);
                }
            });
            this.pnlValuta.add((Component)this.rgrValuta, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtValuta = new PzTextField();
            this.pnlValuta.add((Component)this.txtValuta, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.txtValuta.setName("txtValuta");
            this.txtValuta.setEnabled(false);
            this.lblVal = new JLabel("Oznaka valute:");
            this.pnlValuta.add((Component)this.lblVal, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 5), 0, 0));
            this.lblPAK = new JLabel();
            this.panel.add((Component)this.lblPAK, (Object)new GridBagConstraints(0, 17, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.lblPAK.setName("lblPAK");
            this.tfPak = new PzTextField();
            this.panel.add((Component)this.tfPak, (Object)new GridBagConstraints(1, 17, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.maticnaFirma = new JCheckBox("Mati\u010dna firma");
            this.maticnaFirma.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        Dodavanje.this.pravnoLice.setSelected(false);
                        Dodavanje.this.pravnoLice.setEnabled(false);
                    } else {
                        Dodavanje.this.pravnoLice.setEnabled(true);
                    }
                }
            });
            this.panel.add((Component)this.maticnaFirma, (Object)new GridBagConstraints(4, 16, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.sifra.setStateIndikator(this.indSifra);
            this.naziv.setStateIndikator(this.indNaziv);
            this.adresa.setStateIndikator(this.indAdresa);
            this.postanskiBr.setStateIndikator(this.indPostanskiBr);
            this.grad.setStateIndikator(this.indGrad);
            this.brojFaxa.setStateIndikator(this.indBrojFaxa);
            this.oznakaPIB.setStateIndikator(this.indOznakaPIB);
            this.pack();
            this.setSize(738, 664);
            this.setRestorable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void rgrValutaSelectionChanged(PzRadioGroupEvent evt) {
        if (evt.getStateChange() == 1) {
            if (evt.getValue().equals(DOMACA)) {
                this.lblVal.setEnabled(false);
                this.txtValuta.setVal((Object)"");
            } else {
                this.lblVal.setEnabled(true);
                this.txtValuta.setVal((Object)PzParameter.getParameterValue((String)"DEF_VALUTA"));
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equalsIgnoreCase("odustajanje")) {
            this.dispose();
        } else if (actionCommand.equals("domaci")) {
            this.zemlja.setEnabled(false);
            this.zemlja.setVal((Object)"");
            this.srbija.setEnabled(true);
            this.kosovo.setEnabled(true);
        } else if (actionCommand.equals("inostrani")) {
            this.zemlja.setEnabled(true);
            this.indZemlja.setVisible(true);
            this.zemlja.requestFocusInWindow();
            this.srbija.setEnabled(false);
            this.srbija.setSelected(false);
            this.kosovo.setEnabled(false);
            this.kosovo.setSelected(false);
        } else if (actionCommand.equals("insert") || actionCommand.equals("update")) {
            if (!this.panel.validateForm(true)) {
                return;
            }
            if (!this.dozvoljenaSifra(this.sifra.getVal()) && actionCommand.equals("insert")) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)("Gre\u0161ka! \u0160ifra komitenta mora biti u intervalu " + this.getInterval()));
                return;
            }
            boolean pibCh = this.pibCheck();
            if (!pibCh) {
                this.setFirstComponentInFocus((Component)this.oznakaPIB);
                this.indOznakaPIB.setState(PzFieldIndikator.STATE_INVALID);
                return;
            }
            PzTable table = this.komitent != null && this.komitent.getSfrKomitent().equals("NBS") ? this.getSession().getParameter("komitenti_table") : this.tabela;
            Komitent k = null;
            k = actionCommand.equals("insert") ? new Komitent() : (Komitent)this.getSession().getParameter("komitent");
            k.setSfrKomitent(this.sifra.getVal());
            k.setAdresa(this.adresa.getVal());
            k.setBrFaxa(this.brojFaxa.getVal());
            k.setDomaciKomitent((short)(this.domaci.isSelected() ? 1 : 0));
            k.setEmail(this.email.getVal());
            k.setGrad(this.grad.getVal());
            k.setKontakt(this.kontakt.getVal());
            k.setNovcaniLimit(this.dfNovcaniLimit.getBigDecimal());
            k.setMatBroj(this.maticni.getText());
            k.setNaziv(this.naziv.getVal());
            k.setObveznikPDV((short)(this.jestePdvObveznik.isSelected() ? 1 : 0));
            k.setPib(this.oznakaPIB.getVal());
            k.setPostBroj(this.postanskiBr.getVal());
            k.setPovPravnoLice((short)(this.maticnaFirma.isSelected() ? 2 : 0));
            if (!this.maticnaFirma.isSelected()) {
                k.setPovPravnoLice((short)(this.pravnoLice.isSelected() ? 1 : 0));
            }
            k.setRegBroj(this.registracioni.getVal());
            k.setSifDelatnosti(this.delatnost.getVal());
            k.setDomaciKomitent((short)(this.domaci.isSelected() ? 1 : 0));
            k.setSrbija((short)(this.srbija.isSelected() ? 1 : 0));
            k.setTelefoni(this.telefoni.getVal());
            k.setZemljaKomitenta(this.zemlja.getVal());
            k.setValutniLimit(new BigDecimal(this.tfValutniLimit.getVal()));
            k.setTip(((Integer)((PzChoice)this.cbTip.getSelectedItem()).getValue()).intValue());
            if (k.getKomitentparameters() == null) {
                k.setKomitentparameters(new ArrayList());
            }
            if (actionCommand.equals("insert")) {
                if (this.rgrValuta.getSelectedIndex() != 0) {
                    Komitentparameter vlt = new Komitentparameter();
                    vlt.setId(new KomitentparameterPK(k.getSfrKomitent(), "FAKVAL"));
                    vlt.setValue(this.txtValuta.getVal());
                    k.getKomitentparameters().add(vlt);
                }
                if (!this.tfTeren.getVal().equals("")) {
                    Komitentparameter lokacija = new Komitentparameter();
                    lokacija.setId(new KomitentparameterPK(k.getSfrKomitent(), TEREN));
                    lokacija.setValue(this.tfTeren.getVal());
                    k.getKomitentparameters().add(lokacija);
                }
                if (!this.tfPak.getVal().equals("")) {
                    Komitentparameter pak = new Komitentparameter();
                    pak.setId(new KomitentparameterPK(k.getSfrKomitent(), "PAK"));
                    pak.setValue(this.tfTeren.getVal());
                    k.getKomitentparameters().add(pak);
                }
                if (this.tfTolerancijaPlacanja.getVal() != 0) {
                    Komitentparameter a = new Komitentparameter();
                    a.setId(new KomitentparameterPK(k.getSfrKomitent(), "TOLERANCIJA_PLACANJA"));
                    a.setValue(this.tfTolerancijaPlacanja.getVal().toString());
                    k.getKomitentparameters().add(a);
                }
                if (this.komitent != null) {
                    int opt;
                    if (this.komitent.getEmails() != null) {
                        k.setEmails(this.komitent.getEmails());
                        for (Email ee : k.getEmails()) {
                            ee.setKomitent(k);
                        }
                    }
                    if ((opt = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li \u017eelite da automatski preuzmem podatke o teku\u0107im ra\u010dunima komitenta iz sistema NBS?", (String)"Unos podataka o racunima", null, (boolean)false)) == 0) {
                        try {
                            k.setTekuciracuns(new Vector());
                            List racuni = NBS.getTekuciRacuni((Komitent)k);
                            for (Tekuciracun r : racuni) {
                                if (PzEntityManager.find(Tekuciracun.class, (Object)r.getBrRacuna()) != null) continue;
                                k.getTekuciracuns().add(r);
                            }
                            if (k.getTekuciracuns() != null) {
                                for (Tekuciracun t : k.getTekuciracuns()) {
                                    t.setKomitent(k);
                                }
                            }
                        }
                        catch (Exception e1) {
                            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                        }
                    }
                }
                if (table.insert((PzEntity)k, true)) {
                    PzSwingUtility.showInformationMessage((Component)((Object)this), (String)"Novi komitent je uspe\u0161no unet.");
                }
                PzApplication.getApplication().getSession().getRuntimeStore().put("KOMITENT_ID", (Object)Integer.valueOf(this.sifra.getVal()));
            } else {
                Komitentparameter a;
                if (this.kp == null) {
                    if (this.tfTolerancijaPlacanja.getVal() != 0) {
                        a = new Komitentparameter();
                        a.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), "TOLERANCIJA_PLACANJA"));
                        a.setValue(this.tfTolerancijaPlacanja.getVal().toString());
                        k.getKomitentparameters().add(a);
                    }
                } else {
                    this.kp.setValue(this.tfTolerancijaPlacanja.getVal() == 0 ? "" : this.tfTolerancijaPlacanja.getVal().toString());
                }
                if (this.pak == null) {
                    if (!this.tfPak.getVal().equals("")) {
                        Komitentparameter p = new Komitentparameter();
                        p.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), "PAK"));
                        p.setValue(this.tfPak.getVal().toString());
                        k.getKomitentparameters().add(p);
                    }
                } else {
                    this.pak.setValue(this.tfPak.getVal().equals("") ? "" : this.tfPak.getVal().toString());
                }
                if (this.kpT == null) {
                    if (!this.tfTeren.getVal().equals("")) {
                        a = new Komitentparameter();
                        a.setId(new KomitentparameterPK(this.komitent.getSfrKomitent(), TEREN));
                        a.setValue(this.tfTeren.getVal());
                        k.getKomitentparameters().add(a);
                    }
                } else {
                    this.kpT.setValue(this.tfTeren.getVal());
                }
                if (this.rgrValuta.getSelectedIndex() != 0) {
                    Komitentparameter vlt = new Komitentparameter();
                    vlt.setId(new KomitentparameterPK(k.getSfrKomitent(), "FAKVAL"));
                    vlt.setValue(this.txtValuta.getVal());
                    k.getKomitentparameters().add(vlt);
                } else {
                    k.getKomitentparameters().remove(k.getKomitentparameter("FAKVAL"));
                }
                table.updateSelectedEntity((PzEntity)k, true);
            }
            this.dispose();
        }
    }

    private boolean getFaktureUPripremi(Komitent komitent) {
        boolean rez = false;
        EntityManager em = PzEntityManager.getEm();
        Query q = em.createQuery("Select f From Faktura f where f.komitent =:komitent and f.arhiviran = 0");
        q.setParameter("komitent", (Object)komitent);
        List data = q.getResultList();
        if (data.size() != 0) {
            rez = true;
        }
        return rez;
    }

    private boolean pibCheck() {
        int j;
        Komitent kom;
        if (this.btnOK.getActionCommand().equals("update") && this.oznakaPIB.getVal().equals(this.komitent.getPib())) {
            return true;
        }
        boolean option = true;
        EntityManager emPIB = PzEntityManager.getEm();
        Query q = emPIB.createQuery("SELECT k FROM Komitent k where k.pib='" + this.oznakaPIB.getVal() + "'");
        List komitenti = q.getResultList();
        Komitent komitent = kom = komitenti.size() > 0 ? (Komitent)komitenti.get(0) : null;
        if (kom != null && (j = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)("<html>Komitent sa ovim PIB-om ve\u0107 postoji:<br>[ " + kom.getSfrKomitent() + " ] " + kom.getNaziv() + "<br>\u017delite li da nastavite sa unosom?</html>"), (String)"Upozorenje", null, (boolean)true)) != 0) {
            option = false;
        }
        if (option) {
            q = emPIB.createQuery("SELECT k FROM Komitent k where k.matBroj='" + this.maticni.getVal() + "'");
            komitenti = q.getResultList();
            Komitent komitent2 = kom = komitenti.size() > 0 ? (Komitent)komitenti.get(0) : null;
            if (kom != null && (j = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)("<html>Komitent sa ovim mati\u010dnim brojem ve\u0107 postoji:<br>[ " + kom.getSfrKomitent() + " ] " + kom.getNaziv() + "<br>\u017delite li da nastavite sa unosom?</html>"), (String)"Upozorenje", null, (boolean)true)) != 0) {
                option = false;
            }
        }
        emPIB.close();
        return option;
    }

    public Dodavanje(Boolean initGUI) {
    }

    protected void onInsert() {
        try {
            this.tabela = (PzTable)this.getSession().getParameter("tabela");
            this.setFocusTraversalPolicy((FocusTraversalPolicy)new ArrayFocusTraversalPolicy(new Component[]{this.sifra, this.naziv, this.adresa, this.postanskiBr, this.grad, this.telefoni, this.brojFaxa, this.delatnost, this.maticni, this.registracioni, this.oznakaPIB, this.dfNovcaniLimit, this.tfValutniLimit, this.tfTolerancijaPlacanja, this.email, this.kontakt, this.tfTeren, this.tfPak, this.btnOK}));
            this.btnOK.setActionCommand("insert");
            Integer id = (Integer)PzApplication.getApplication().getSession().getRuntimeStore().get("KOMITENT_ID");
            String intervalStart = this.getInterval().split("-")[0];
            String intervalEnd = this.getInterval().split("-")[1];
            String res = null;
            if (id == null) {
                List sifre = PzEntityManager.getEm().createNativeQuery(String.format("SELECT k.sfrKomitent FROM Komitent k WHERE CAST(k.sfrKomitent AS INT) > %s and CAST(k.sfrKomitent AS INT) < %s", intervalStart, intervalEnd)).getResultList();
                Collections.sort(sifre, new Comparator<String>(){

                    @Override
                    public int compare(String arg0, String arg1) {
                        block4: {
                            try {
                                if (Integer.parseInt(arg0) <= Integer.parseInt(arg1)) break block4;
                                return 1;
                            }
                            catch (NumberFormatException numberFormatException) {
                                return 0;
                            }
                        }
                        if (Integer.parseInt(arg0) < Integer.parseInt(arg1)) {
                            return -1;
                        }
                        return 0;
                    }
                });
                res = sifre.size() > 0 ? String.valueOf(Integer.parseInt((String)sifre.get(sifre.size() - 1)) + 1) : intervalStart;
            } else {
                res = String.valueOf(id + 1);
            }
            this.sifra.setVal((Object)res);
            this.dozvole();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    private boolean dozvoljenaSifra(String sif) {
        if (!PzParameter.getBoolean((String)"KOMITENT_INTERVAL_STRICT", (boolean)false).booleanValue()) {
            return true;
        }
        String[] interval = this.getInterval().split("\\-");
        return Integer.parseInt(sif) <= Integer.parseInt(interval[1]) && Integer.parseInt(sif) >= Integer.parseInt(interval[0]);
    }

    private String getInterval() {
        return PzParameter.getParameterValue((String)"KOMITENT_INTERVAL", (String)"1-999999999");
    }

    private void dozvole() {
        if (!PzApplication.getApplication().getSession().getLoggedUser().isModerator()) {
            this.dfNovcaniLimit.setEnabled(false);
            this.tfTolerancijaPlacanja.setEnabled(false);
            this.tfValutniLimit.setEnabled(false);
        }
    }

    protected void onUpdate() {
        Komitentparameter vlt;
        this.komitent = (Komitent)this.getSession().getParameter("komitent");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.naziv.setVal((Object)this.komitent.getNaziv());
        this.registracioni.setVal((Object)this.komitent.getRegBroj());
        this.maticni.setVal((Object)this.komitent.getMatBroj());
        this.email.setVal((Object)this.komitent.getEmail());
        this.oznakaPIB.setVal((Object)this.komitent.getPib());
        this.dfNovcaniLimit.setVal((Object)this.komitent.getNovcaniLimit());
        this.delatnost.setVal((Object)this.komitent.getSifDelatnosti());
        this.brojFaxa.setVal((Object)this.komitent.getBrFaxa());
        this.telefoni.setVal((Object)this.komitent.getTelefoni());
        this.grad.setVal((Object)this.komitent.getGrad());
        this.adresa.setVal((Object)this.komitent.getAdresa());
        this.kontakt.setVal((Object)this.komitent.getKontakt());
        this.zemlja.setVal((Object)this.komitent.getZemljaKomitenta());
        this.tfValutniLimit.setVal((Object)(this.komitent.getValutniLimit() != null ? this.komitent.getValutniLimit().intValue() : 0));
        this.postanskiBr.setVal((Object)this.komitent.getPostBroj());
        this.pravnoLice.setSelected(this.komitent.getPovPravnoLice() != 0 && this.komitent.getPovPravnoLice() != 2);
        this.maticnaFirma.setSelected(this.komitent.getPovPravnoLice() == 2);
        this.domaci.setSelected(this.komitent.getDomaciKomitent() != 0);
        this.inostrani.setSelected(this.komitent.getDomaciKomitent() == 0);
        this.srbija.setSelected(this.komitent.getSrbija() != 0);
        this.kosovo.setSelected(this.komitent.getSrbija() == 0);
        this.nijePdvObveznik.setSelected(this.komitent.getObveznikPDV() == 0);
        this.jestePdvObveznik.setSelected(this.komitent.getObveznikPDV() != 0);
        this.indZemlja.setVisible(this.komitent.getDomaciKomitent() == 0);
        int i = 0;
        while (i < this.cbTip.getItemCount()) {
            PzChoice choice = (PzChoice)this.cbTip.getItemAt(i);
            if (choice.getValue().equals(this.komitent.getTip())) {
                this.cbTip.setSelectedItem(choice);
            }
            ++i;
        }
        if (this.komitent.getDomaciKomitent() == 0) {
            this.zemlja.setEnabled(true);
            this.srbija.setEnabled(false);
            this.kosovo.setEnabled(false);
            this.indZemlja.setVisible(true);
        } else {
            this.zemlja.setText("");
            this.zemlja.setEnabled(false);
            this.srbija.setEnabled(true);
            this.kosovo.setEnabled(true);
        }
        this.kp = this.komitent.getKomitentparameter("TOLERANCIJA_PLACANJA");
        this.kpT = this.komitent.getKomitentparameter(TEREN);
        this.pak = this.komitent.getKomitentparameter("PAK");
        if (this.kp != null) {
            this.tfTolerancijaPlacanja.setVal((Object)this.kp.getValue());
        }
        if (this.kpT != null) {
            this.tfTeren.setVal((Object)this.kpT.getValue());
        }
        if (this.pak != null) {
            this.tfPak.setVal((Object)this.pak.getValue());
        }
        if ((vlt = this.komitent.getKomitentparameter("FAKVAL")) != null && !vlt.getValue().equals("")) {
            this.rgrValuta.setSelectedIndex(1);
            this.txtValuta.setVal((Object)vlt.getValue());
            this.lblVal.setEnabled(true);
        }
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        Long count = (Long)em.createQuery("SELECT COUNT(d) FROM Dokument d WHERE d.komitent=:k").setParameter("k", (Object)this.komitent).getSingleResult();
        em.close();
        if (count.compareTo(new Long(0L)) > 0) {
            this.zemlja.setEnabled(false);
            this.srbija.setEnabled(false);
            this.kosovo.setEnabled(false);
            this.domaci.setEnabled(false);
            this.inostrani.setEnabled(false);
        }
        this.panel.updateAllFieldsState();
        if (this.komitent.getSfrKomitent().equals("NBS")) {
            if (this.komitent.getNaziv().toLowerCase().indexOf("doo") == -1 && this.komitent.getOpis().toLowerCase().indexOf("doo") != -1) {
                this.naziv.setVal((Object)(String.valueOf(this.komitent.getNaziv()) + " DOO"));
            }
            if (this.komitent.getNaziv().toLowerCase().indexOf("agencija") == -1 && this.komitent.getOpis().toLowerCase().indexOf("agencija") != -1) {
                this.naziv.setVal((Object)(String.valueOf(this.komitent.getNaziv()) + " AGENCIJA"));
            }
            this.onInsert();
        } else {
            this.setFocusTraversalPolicy((FocusTraversalPolicy)new ArrayFocusTraversalPolicy(new Component[]{this.naziv, this.adresa, this.postanskiBr, this.grad, this.telefoni, this.brojFaxa, this.delatnost, this.maticni, this.registracioni, this.oznakaPIB, this.dfNovcaniLimit, this.tfValutniLimit, this.tfTolerancijaPlacanja, this.email, this.kontakt, this.tfTeren, this.tfPak, this.btnOK}));
            this.btnOK.setActionCommand("update");
            this.sifra.setVal((Object)this.komitent.getSfrKomitent());
            this.sifra.setEnabled(false);
            this.sifra.setFocusable(false);
        }
        this.dozvole();
    }

    public void setEntity(PzEntity entity, Component component) {
    }

    protected void setHeaderOnInsert() {
        this.setHeaderTitle("Dodavanje novog komitenta");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessman_new.png")));
    }

    protected void setHeaderOnUpdate() {
        this.setHeaderTitle("Izmena podataka o komitentu");
        this.setHeaderIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessman_edit.png")));
    }
}

