/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.gui.komintenti;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.application.Application;
import org.jdesktop.swingx.JXStatusBar;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.VerticalLayout;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.entity.Komitent;
import rs.pezar.sifarnici.gui.komintenti.Dodavanje;
import rs.pezar.swing.PzAbstractTable;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzIntegerField;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.webservice.client.nbs.NBS;

public class PretragaNBS
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private JPanel pnlContent;
    private JPanel pnlFields;
    private PzIntegerField txtMbr;
    private JLabel lblMbr;
    private JXStatusBar statusBar;
    private PzTable table;
    private JScrollPane scpane;
    private PzPanelHeader header;
    private PzIntegerField txtPib;
    private JLabel lblPib;
    private HintTextField txtNaziv;
    private JLabel lblGrad;
    private PzButton btnApr;
    private JTextArea lblPunNaziv;
    private JScrollPane jScrollPane1;
    private JPanel jPanel1;
    private PzTable tblDet;
    private JXTitledPanel pnlDetalji;
    private JSplitPane jSplitPane1;
    private HintTextField txtGrad;
    private PzButton btnDodaj;
    private JLabel lblNaziv;
    private PzButton bntTrazi;
    private JLabel lblBrPogodaka;
    private boolean restored;
    private String parameter;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PretragaNBS inst = new PretragaNBS(frame);
                inst.setVisible(true);
            }
        });
    }

    public PretragaNBS(JFrame frame) {
        super(frame);
        this.initGUI();
        this.parameter = (String)this.getSession().getParameter("parameter");
    }

    public PretragaNBS(PzDialog frame) {
        super(frame);
        this.initGUI();
        this.parameter = (String)this.getSession().getParameter("parameter");
    }

    private void initGUI() {
        try {
            this.setTitle("Pretraga NBS");
            this.pnlContent = new JPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{20, 7, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout(pnlContentLayout);
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pnlFields = new JPanel();
            FlowLayout pnlFieldsLayout = new FlowLayout();
            pnlFieldsLayout.setAlignment(0);
            pnlFieldsLayout.setHgap(15);
            this.pnlFields.setLayout(pnlFieldsLayout);
            this.pnlContent.add((Component)this.pnlFields, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlFields.setBorder(BorderFactory.createTitledBorder("Kriterijumi za pretragu"));
            this.lblPib = new JLabel();
            this.pnlFields.add(this.lblPib);
            this.lblPib.setName("lblPib");
            this.txtPib = new PzIntegerField();
            this.pnlFields.add((Component)this.txtPib);
            this.txtPib.setName("txtPib");
            this.lblMbr = new JLabel();
            this.pnlFields.add(this.lblMbr);
            this.lblMbr.setName("lblMbr");
            this.txtMbr = new PzIntegerField();
            this.pnlFields.add((Component)this.txtMbr);
            this.txtMbr.setName("txtMbr");
            this.lblNaziv = new JLabel();
            this.pnlFields.add(this.lblNaziv);
            this.lblNaziv.setName("lblNaziv");
            this.txtNaziv = new HintTextField();
            this.txtNaziv.setHint("minimum 3 slova");
            this.pnlFields.add((Component)((Object)this.txtNaziv));
            this.txtNaziv.setName("txtNaziv");
            this.lblGrad = new JLabel();
            this.pnlFields.add(this.lblGrad);
            this.lblGrad.setName("lblGrad");
            this.txtGrad = new HintTextField();
            this.txtGrad.setHint("minimum 2 slova");
            this.pnlFields.add((Component)((Object)this.txtGrad));
            this.txtGrad.setName("txtGrad");
            this.bntTrazi = new PzButton();
            this.bntTrazi.setText("Tra\u017ei");
            this.bntTrazi.setBounds(12, 12, 165, 25);
            this.bntTrazi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/find.png")));
            this.bntTrazi.setActionCommand("trazi");
            this.bntTrazi.setShortcut("enter");
            this.pnlFields.add((Component)this.bntTrazi);
            this.bntTrazi.addActionListener((ActionListener)((Object)this));
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/nbs.png")));
            this.header.setTitle("Pretraga privrednih dru\u0161tava i preduzetnika u sistemu NBS");
            this.header.setText("Unesite makar jedan od kriterijuma za pretragu");
            this.pnlContent.add((Component)this.header, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1 = new JSplitPane();
            this.pnlContent.add((Component)this.jSplitPane1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.scpane = new JScrollPane();
            this.jSplitPane1.add((Component)this.scpane, "left");
            this.jSplitPane1.setDividerLocation(750);
            this.table = new PzTable();
            this.table.setId("PRETRAGA_NBS_TABLE");
            this.table.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    Komitent k = (Komitent)entity;
                    return new Object[]{k.getNaziv(), String.valueOf(k.getGrad()) + " (" + k.getPostBroj() + ")", k.getAdresa()};
                }

                public String[] getColumnNames() {
                    return new String[]{"Naziv", "Grad", "Adresa"};
                }
            });
            this.table.getSelectionModel().addListSelectionListener(this.createListSelectionListener());
            this.table.setEnterAction(new AbstractAction(){
                private static final long serialVersionUID = 4094237967630687500L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PretragaNBS.this.saveKomitent();
                }
            });
            this.scpane.setViewportView((Component)this.table);
            this.jPanel1 = new JPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.jPanel1.setLayout(jPanel1Layout);
            this.jSplitPane1.add((Component)this.jPanel1, "right");
            this.jPanel1.setPreferredSize(new Dimension(224, 317));
            jPanel1Layout.rowWeights = new double[]{0.1, 0.0, 0.0};
            jPanel1Layout.rowHeights = new int[]{7, 7, 20};
            jPanel1Layout.columnWeights = new double[]{0.1};
            jPanel1Layout.columnWidths = new int[]{7};
            this.btnDodaj = new PzButton();
            this.jPanel1.add((Component)this.btnDodaj, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnDodaj.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/businessman_add_small.png")));
            this.btnDodaj.setName("btnDodaj");
            this.btnDodaj.addActionListener((ActionListener)((Object)this));
            this.btnDodaj.setHorizontalAlignment(10);
            this.pnlDetalji = new JXTitledPanel();
            this.jPanel1.add((Component)this.pnlDetalji, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.pnlDetalji.setTitle("Detaljni podaci");
            this.pnlDetalji.setTitleFont(new Font("SansSerif", 1, 13));
            VerticalLayout pnlDetaljiLayout = new VerticalLayout(1);
            pnlDetaljiLayout.setGap(0);
            this.pnlDetalji.setLayout((LayoutManager)pnlDetaljiLayout);
            this.tblDet = new PzTable();
            this.pnlDetalji.add((Component)this.tblDet);
            this.lblPunNaziv = new JTextArea();
            this.pnlDetalji.add((Component)this.lblPunNaziv);
            this.lblPunNaziv.setLineWrap(true);
            this.lblPunNaziv.setFont(new Font("SansSerif", 1, 13));
            this.lblPunNaziv.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.btnApr = new PzButton();
            this.btnApr.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/sifarnici/resource/img/apr.png")));
            this.jPanel1.add((Component)this.btnApr, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnApr.setName("btnApr");
            this.btnApr.addActionListener((ActionListener)((Object)this));
            this.btnApr.setHorizontalAlignment(10);
            this.statusBar = new JXStatusBar();
            this.statusBar.add((Component)new JLabel("Broj pogodaka:"));
            this.lblBrPogodaka = new JLabel("0");
            this.statusBar.add((Component)this.lblBrPogodaka);
            this.pnlContent.add((Component)this.statusBar, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(1000, 543);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trazi() {
        if (!this.validiraj()) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Pretraga je u toku. Ova operacija moze da potraje u zavisnosti od unetih kriterijuma. Molimo, sa\u010dekajte!", (PzDialog)this);
        SwingWorker<List<Komitent>, Object> worker = new SwingWorker<List<Komitent>, Object>(){

            @Override
            protected List<Komitent> doInBackground() throws Exception {
                String naziv = !PretragaNBS.this.txtNaziv.isEmpty() ? "\"" + PretragaNBS.this.txtNaziv.getVal() + "\"" : null;
                String grad = !PretragaNBS.this.txtGrad.isEmpty() ? PretragaNBS.this.txtGrad.getVal() : null;
                List komitenti = NBS.getKomitenti((Integer)PretragaNBS.this.txtMbr.getVal(), (Integer)PretragaNBS.this.txtPib.getVal(), (String)naziv, (String)grad);
                return komitenti;
            }

            @Override
            protected void done() {
                block9: {
                    boolean ok = false;
                    try {
                        try {
                            List komitenti = (List)this.get();
                            if (komitenti.size() > 0) {
                                PretragaNBS.this.restoreTableState();
                                PretragaNBS.this.table.setData(komitenti, Komitent.class);
                                PretragaNBS.this.lblBrPogodaka.setText(String.valueOf(komitenti.size()));
                                PretragaNBS.this.table.requestFocusInWindow();
                                ok = true;
                                break block9;
                            }
                            int rez = PzSwingUtility.daNeDijalog((Component)((Object)PretragaNBS.this), (Object)"U registru kompanija NBS nije pronadjena ni jedna firma koja ispunjava kriterijume. \nDa li \u017eelite da poku\u0161am da dobavim podatke iz registra imalaca teku\u0107ih ra\u010duna?", (String)"Obave\u0161tenje", null, (boolean)false);
                            if (rez == 0) {
                                PretragaNBS.this.trazi2();
                                break block9;
                            }
                            ok = true;
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PretragaNBS.this), (Throwable)e);
                            if (ok) {
                                PzWorkerDialog.hideStatus();
                            }
                        }
                    }
                    finally {
                        if (ok) {
                            PzWorkerDialog.hideStatus();
                        }
                    }
                }
            }
        };
        worker.execute();
    }

    private void trazi2() {
        if (!this.validiraj()) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Pretraga je u toku. Ova operacija moze da potraje u zavisnosti od unetih kriterijuma. Molimo, sa\u010dekajte!", (PzDialog)this);
        SwingWorker<List<Komitent>, Object> worker = new SwingWorker<List<Komitent>, Object>(){

            @Override
            protected List<Komitent> doInBackground() throws Exception {
                String naziv = !PretragaNBS.this.txtNaziv.isEmpty() ? PretragaNBS.this.txtNaziv.getVal() : null;
                String grad = !PretragaNBS.this.txtGrad.isEmpty() ? PretragaNBS.this.txtGrad.getVal() : null;
                List komitenti = NBS.getKomitentRacun((Integer)PretragaNBS.this.txtMbr.getVal(), (String)(PretragaNBS.this.txtPib.getText().equals("") ? null : PretragaNBS.this.txtPib.getText()), (String)naziv, (String)grad);
                return komitenti;
            }

            @Override
            protected void done() {
                try {
                    try {
                        List komitenti = (List)this.get();
                        PretragaNBS.this.restoreTableState();
                        PretragaNBS.this.table.setData(komitenti, Komitent.class);
                        PretragaNBS.this.lblBrPogodaka.setText(String.valueOf(komitenti.size()));
                        PretragaNBS.this.table.requestFocusInWindow();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PretragaNBS.this), (Throwable)e);
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private boolean validiraj() {
        if (!this.txtNaziv.isEmpty() && this.txtNaziv.getText().length() < 3) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Polje 'Naziv' mora sadr\u017eati najmanje 3 slova");
            return false;
        }
        if (!this.txtGrad.isEmpty() && this.txtGrad.getText().length() < 2) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Polje 'Grad' mora sadr\u017eati najmanje 2 slova");
            return false;
        }
        if (!this.txtGrad.isEmpty() && this.txtNaziv.isEmpty()) {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ukoliko se popunjava polje 'Grad', tada i polje 'Naziv' mora biti popunjeno");
            return false;
        }
        return true;
    }

    private ListSelectionListener createListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DefaultTableModel model = new DefaultTableModel();
                Komitent k = (Komitent)PretragaNBS.this.table.getSelectedEntity();
                if (k == null) {
                    PretragaNBS.this.tblDet.setModel((TableModel)new DefaultTableModel());
                    return;
                }
                Object[][] data = new Object[][]{{"Skra\u0107eno ime", k.getNaziv()}, {"Grad", k.getGrad()}, {"Po\u0161tanski broj", k.getPostBroj()}, {"Adresa", k.getAdresa()}, {"Telefon", k.getTelefoni()}, {"Email", k.getEmail()}, {"PIB", k.getPib()}, {"Mati\u010dni broj", k.getMatBroj()}};
                model.setDataVector(data, new Object[]{"", ""});
                PretragaNBS.this.tblDet.setModel((TableModel)model);
                PretragaNBS.this.tblDet.packAll();
                PretragaNBS.this.lblPunNaziv.setText(k.getOpis());
            }
        };
    }

    public void restoreTableState() {
        if (!this.restored) {
            this.restored = true;
            ((PzDialog)SwingUtilities.getRoot((Component)((Object)this))).restoreTable((PzAbstractTable)this.table);
        }
    }

    public void saveTableState() {
        try {
            if (this.table != null) {
                PzApplication.getApplication().getSession().getSessionStorage().save((Component)this.table, String.valueOf(SwingUtilities.getRoot((Component)((Object)this)).getClass().getName()) + "." + this.table.getId() + ".xml");
            }
        }
        catch (IOException e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bntTrazi) {
            this.trazi();
        } else if (e.getSource() == this.btnDodaj) {
            this.saveKomitent();
        } else if (e.getSource() == this.btnApr) {
            this.idiNaApr();
        }
    }

    private void idiNaApr() {
        if (this.table.getSelectedEntity() == null) {
            return;
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(((Komitent)this.table.getSelectedEntity()).getMatBroj()), new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                });
                Desktop.getDesktop().browse(new URI("http://pretraga2.apr.gov.rs/ObjedinjenePretrage/Search/Search"));
            }
            catch (Exception e) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        } else {
            PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Ova operacija nije podr\u017eana od strane va\u0161e platforme");
        }
    }

    private void saveKomitent() {
        this.getSession().putParameter("update", (Object)Boolean.TRUE);
        this.getSession().putParameter("komitent", (Object)this.table.getSelectedEntity());
        if (this.parameter.equals("sifarnici")) {
            this.showDialog(Dodavanje.class);
        } else {
            this.dispose();
        }
    }

    private static class HintTextField
    extends PzTextField
    implements FocusListener {
        private static final long serialVersionUID = 1L;
        private String hint;

        public HintTextField(String hint) {
            super(hint);
            this.hint = hint;
            super.addFocusListener((FocusListener)this);
        }

        public HintTextField() {
            this("");
        }

        public void setHint(String hint) {
            this.hint = hint;
            this.setHintText(hint);
        }

        private void setHintText(String txt) {
            super.setForeground(Color.GRAY);
            super.setVal((Object)txt);
        }

        private void removeHintText() {
            super.setForeground(Color.BLACK);
            super.setText("");
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (this.getText().isEmpty()) {
                this.removeHintText();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (this.getText().isEmpty()) {
                this.setHintText(this.hint);
            }
        }

        public String getText() {
            String typed = super.getText();
            return typed.equals(this.hint) ? "" : typed;
        }

        public boolean isEmpty() {
            return this.getText().equals("");
        }
    }
}

