/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.sifarnici.util;

import java.math.BigDecimal;
import java.sql.Date;
import javax.persistence.EntityManager;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Komitentparameter;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.util.PzDateUtility;

public class KomitentPrometUtility {
    private static String RACUN_KUPCA_USLOV;
    private static String RACUN_DOBAVLJACA_USLOV;

    static {
        String tipoviKupac = "'" + TipDokumentConfig.get().FAKTURA + "','" + TipDokumentConfig.get().FAKTURA_SERVISA + "','" + TipDokumentConfig.get().FAKTURA_USLUGA + "'";
        RACUN_KUPCA_USLOV = " f.arhiviran=1 and f.storno=0 and f.tip IN (" + tipoviKupac + ") ";
        String cfr_ignored_0 = "'" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + ", '" + "'" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "'";
        RACUN_DOBAVLJACA_USLOV = " k.arhiviran=1 and k.storno=0 and (k.podTip NOT IN ('" + TipDokumentConfig.get().PODTIP_KALKULACIJA_OTPREMNICA + "', " + "'" + TipDokumentConfig.get().PODTIP_KALKULACIJA_PRENOSNICA + "') OR k.podTip IS NULL) ";
    }

    public static BigDecimal getBigDecimalValue(String upit) {
        EntityManager em = PzEntityManager.getEm();
        BigDecimal res = new BigDecimal(0);
        if (em.createQuery(upit).getSingleResult() != null) {
            res = (BigDecimal)em.createQuery(upit).getSingleResult();
        }
        return res;
    }

    public static String getUplate(Komitent k, Boolean kupac) {
        String upit = "";
        upit = kupac != false ? "Select SUM(f.uplata) From Faktura f where f.arhiviran=1 and f.storno=0 and f.komitent.sfrKomitent=" + k.getSfrKomitent() : "Select SUM(-k.uplata) From Kalkulacija k where k.arhiviran=1 and k.storno=0 and k.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getUplateRacun(Komitent k) {
        String upit = "";
        upit = "Select SUM(r.uplata) From RacunDobavljaca r where r.arhiviran=1 and r.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getFakturisao(Komitent k, Boolean kupac) {
        String upit = "";
        upit = kupac != false ? "Select SUM(f.iznos-f.stornoIznos) From Faktura f where " + RACUN_KUPCA_USLOV + " and f.komitent.sfrKomitent='" + k.getSfrKomitent() + "'" : "Select SUM(k.iznos-k.stornoIznos) From Kalkulacija k where " + RACUN_DOBAVLJACA_USLOV + " and k.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getFakturisaoRacun(Komitent k) {
        String upit = "";
        upit = "Select SUM(r.iznos) From RacunDobavljaca r where r.arhiviran=1 and r.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getOtpremnica(Komitent k, Boolean kupac) {
        String upit = "";
        upit = kupac != false ? "Select SUM(f.iznos-f.stornoIznos) From Faktura f where f.arhiviran=1 and f.storno=0 and f.tip='OTPREMNICA' and f.komitent.sfrKomitent=" + k.getSfrKomitent() : "Select SUM(-(k.iznos-k.stornoIznos)) From Kalkulacija k where k.arhiviran=1 and k.storno=0 and k.podTip='OTPREMNICA' and k.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getAvansi(Komitent k, Boolean kupac) {
        String upit = "";
        upit = kupac != false ? "Select SUM(CASE \t\t\t\tWHEN u.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' THEN u.iznos " + "\t\t\t\tWHEN u.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ + "' THEN  -u.iznos " + "\t\t\t\tWHEN u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' THEN  -u.iznos " + "\t\t\t\tELSE 0 " + "\t\t\t END) " + "FROM Dokument u WHERE (u.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' OR u.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ + "' OR u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "')" + " and u.komitent.sfrKomitent='" + k.getSfrKomitent() + "' AND u.arhiviran = 1 " : "Select SUM(CASE \t\t\t\tWHEN u.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' THEN -u.iznos " + "\t\t\t\tWHEN u.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' THEN  u.iznos " + "\t\t\t\tWHEN u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' THEN  u.iznos " + "\t\t\t\tELSE 0 " + "\t\t\t END) " + "FROM Dokument u WHERE (u.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' OR u.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' OR u.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "')" + " and u.komitent.sfrKomitent='" + k.getSfrKomitent() + "' AND u.arhiviran = 1 ";
        return upit;
    }

    public static BigDecimal getOstatakAvansaKupci(String sfrKomitent) throws Exception {
        BigDecimal zatvaranje;
        BigDecimal povracaj;
        String query;
        EntityManager em = PzEntityManager.getEm();
        BigDecimal primljen = (BigDecimal)em.createQuery(query = "SELECT SUM(a.iznos) FROM Dokument a WHERE a.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS + "' AND a.komitent.sfrKomitent = '" + sfrKomitent + "' AND a.arhiviran != -1").getSingleResult();
        if (primljen == null) {
            primljen = new BigDecimal(0.0);
        }
        if ((povracaj = (BigDecimal)em.createQuery(query = "SELECT SUM(a.iznos) FROM Dokument a WHERE a.tip = '" + TipDokumentConfig.get().UPLATA_PRIMLJEN_AVANS_POVRACAJ + "' AND a.komitent.sfrKomitent = '" + sfrKomitent + "' AND a.arhiviran != -1").getSingleResult()) == null) {
            povracaj = new BigDecimal(0.0);
        }
        if ((zatvaranje = (BigDecimal)em.createQuery(query = "SELECT SUM(a.iznos) FROM Dokument a WHERE a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_KUPAC + "' AND a.komitent.sfrKomitent = '" + sfrKomitent + "' AND a.arhiviran != -1").getSingleResult()) == null) {
            zatvaranje = new BigDecimal(0.0);
        }
        em.close();
        BigDecimal rezultat = primljen.subtract(povracaj).subtract(zatvaranje);
        return rezultat;
    }

    public static BigDecimal getOstatakAvansaDobavljaci(String sfrKomitent) throws Exception {
        BigDecimal zatvaranje;
        BigDecimal povracaj;
        String query;
        EntityManager em = PzEntityManager.getEm();
        BigDecimal primljen = (BigDecimal)em.createQuery(query = "SELECT SUM(a.iznos) FROM Dokument a WHERE a.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS + "' AND a.komitent.sfrKomitent = '" + sfrKomitent + "' AND a.arhiviran != -1").getSingleResult();
        if (primljen == null) {
            primljen = new BigDecimal(0.0);
        }
        if ((povracaj = (BigDecimal)em.createQuery(query = "SELECT SUM(a.iznos) FROM Dokument a WHERE a.tip = '" + TipDokumentConfig.get().UPLATA_DAT_AVANS_POVRACAJ + "' AND a.komitent.sfrKomitent = '" + sfrKomitent + "' AND a.arhiviran != -1").getSingleResult()) == null) {
            povracaj = new BigDecimal(0.0);
        }
        if ((zatvaranje = (BigDecimal)em.createQuery(query = "SELECT SUM(a.iznos) FROM Dokument a WHERE a.tip = '" + TipDokumentConfig.get().ZATVARANJE_AVANSOM_DOBAVLJAC + "' AND " + "a.komitent.sfrKomitent = '" + sfrKomitent + "' AND a.arhiviran != -1").getSingleResult()) == null) {
            zatvaranje = new BigDecimal(0.0);
        }
        em.close();
        BigDecimal rezultat = primljen.subtract(povracaj).subtract(zatvaranje);
        return rezultat;
    }

    public static String getUkupanDug(Komitent k, Boolean kupac) {
        String upit = "";
        upit = kupac != false ? "Select SUM(f.iznos-f.stornoIznos-f.uplata) From Faktura f where " + RACUN_KUPCA_USLOV + "and f.komitent.sfrKomitent=" + k.getSfrKomitent() : "Select SUM(k.iznos-k.stornoIznos-k.uplata) From Kalkulacija k where " + RACUN_DOBAVLJACA_USLOV + " and k.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getIznosVanValute(Komitent k, Boolean kupac) {
        String upit = "";
        Date today = PzDateUtility.getServerDate();
        upit = kupac != false ? "Select SUM(f.iznos-f.stornoIznos-f.uplata) From Faktura f where f.datValute < '" + today + "' and " + RACUN_KUPCA_USLOV + " and f.komitent.sfrKomitent=" + k.getSfrKomitent() : "Select SUM(k.iznos-k.stornoIznos-k.uplata) From Kalkulacija k where k.datValute < '" + today + "' and " + RACUN_DOBAVLJACA_USLOV + " and k.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }

    public static String getIznosVanTolerancije(Komitent k, Boolean kupac) {
        String upit = "";
        int tolerancija = 0;
        Komitentparameter kp = k.getKomitentparameter("TOLERANCIJA_PLACANJA");
        if (kp != null) {
            tolerancija = Integer.parseInt(kp.getValue());
        }
        Date today = PzDateUtility.add((Date)PzDateUtility.getServerDate(), (int)(-tolerancija));
        upit = kupac != false ? "Select SUM(f.iznos-f.stornoIznos-f.uplata) From Faktura f where f.datValute < '" + today + "' and " + RACUN_KUPCA_USLOV + " and f.komitent.sfrKomitent=" + k.getSfrKomitent() : "Select SUM(k.iznos-k.stornoIznos-k.uplata) From Kalkulacija k where k.datValute < '" + today + "' and " + RACUN_DOBAVLJACA_USLOV + " and k.komitent.sfrKomitent=" + k.getSfrKomitent();
        return upit;
    }
}

