/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference.preferences;

import bibliothek.extension.gui.dock.preference.DefaultPreference;
import bibliothek.extension.gui.dock.preference.preferences.choice.DefaultChoice;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.util.Path;

public class ChoiceDockPropertyPreference<V>
extends DefaultPreference<String> {
    private DockProperties properties;
    private PropertyKey<V> key;
    private DefaultChoice<V> choice;

    public ChoiceDockPropertyPreference(DockProperties properties, PropertyKey<V> key, Path path, DefaultChoice<V> choice) {
        super(Path.TYPE_STRING_CHOICE_PATH, path);
        this.properties = properties;
        this.choice = choice;
        this.key = key;
        this.setValueInfo(choice);
    }

    @Override
    public void write() {
        this.properties.setOrRemove(this.key, this.choice.identifierToValue((String)this.getValue()), Priority.CLIENT);
    }

    @Override
    public void read() {
        V property = this.properties.get(this.key, Priority.CLIENT);
        if (property == null) {
            this.setValue(this.choice.getDefaultChoice());
        } else {
            String value = this.choice.valueToIdentifier(property);
            if (value != null || this.choice.isNullEntryAllowed()) {
                this.setValue(value);
            }
        }
    }
}

