/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack;

import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.CombinedTab;
import bibliothek.gui.dock.station.stack.tab.AbstractTab;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.Icon;
import javax.swing.event.MouseInputListener;

public class EclipseTab
extends AbstractTab
implements CombinedTab {
    private TabComponent component;
    private EclipseTabPane parent;

    public EclipseTab(EclipseTabPane parent, Dockable dockable, TabComponent delegate) {
        super(parent, dockable);
        this.parent = parent;
        this.component = delegate;
        this.component.setIcon(dockable.getTitleIcon());
        this.component.setText(dockable.getTitleText());
        this.component.setTab(this);
    }

    @Override
    public Component getComponent() {
        return this.component.getComponent();
    }

    public TabComponent getTabComponent() {
        return this.component;
    }

    @Override
    public void setPaneVisible(boolean visible) {
        this.parent.getTabHandler().setVisible(this, visible);
    }

    @Override
    public boolean isPaneVisible() {
        return this.parent.getTabHandler().isVisible(this);
    }

    @Override
    public void setZOrder(int order) {
        this.parent.getTabHandler().setZOrder(this, order);
    }

    @Override
    public int getZOrder() {
        return this.parent.getTabHandler().getZOrder(this);
    }

    @Override
    public void setIcon(Icon icon) {
        this.component.setIcon(icon);
    }

    @Override
    public void setText(String text) {
        this.component.setText(text);
    }

    @Override
    public void setTooltip(String tooltip) {
        this.component.setTooltip(tooltip);
    }

    @Override
    public void setOrientation(TabPlacement orientation) {
        super.setOrientation(orientation);
        this.component.setOrientation(orientation);
    }

    @Override
    public void addMouseInputListener(MouseInputListener listener) {
        this.component.addMouseInputListener(listener);
    }

    @Override
    public Dimension getMinimumSize(Tab[] tabs) {
        return this.component.getMinimumSize(this.extract(tabs));
    }

    @Override
    public Dimension getPreferredSize(Tab[] tabs) {
        return this.component.getPreferredSize(this.extract(tabs));
    }

    private TabComponent[] extract(Tab[] tabs) {
        TabComponent[] components = new TabComponent[tabs.length];
        int i = 0;
        while (i < tabs.length) {
            if (tabs[i] instanceof EclipseTab) {
                components[i] = ((EclipseTab)tabs[i]).getTabComponent();
            }
            ++i;
        }
        return components;
    }

    @Override
    public DockElement getElement() {
        return this.getDockable();
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        return null;
    }

    @Override
    public boolean isUsedAsTitle() {
        return true;
    }

    @Override
    public boolean shouldFocus() {
        return true;
    }

    @Override
    public boolean shouldTransfersFocus() {
        return true;
    }

    @Override
    public void removeMouseInputListener(MouseInputListener listener) {
        this.component.removeMouseInputListener(listener);
    }

    @Override
    public void bind() {
        this.component.bind();
        super.bind();
    }

    @Override
    public void unbind() {
        this.component.unbind();
        super.unbind();
    }

    @Override
    public Insets getOverlap(TabPaneComponent other) {
        if (other instanceof EclipseTab) {
            EclipseTab tab = (EclipseTab)other;
            return this.getTabComponent().getOverlap(tab.getTabComponent());
        }
        return super.getOverlap(other);
    }

    public void setPaintIconWhenInactive(boolean paint) {
        this.component.setPaintIconWhenInactive(paint);
    }

    @Override
    protected void informFocusChanged(boolean focused) {
        this.component.setFocused(focused);
    }

    @Override
    protected void informSelectionChanged(boolean selected) {
        this.component.setSelected(selected);
    }

    public String toString() {
        Dockable dockable = this.component.getElement().asDockable();
        if (dockable == null) {
            return String.valueOf(this.getClass().getSimpleName()) + "@[component=" + this.component + "]";
        }
        return String.valueOf(this.getClass().getSimpleName()) + "@[dockable title=" + dockable.getTitleText() + "]";
    }
}

