/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.extension.gui.dock.theme.flat.FlatTabPane;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.menu.AbstractCombinedMenu;
import bibliothek.gui.dock.themes.color.MenuColor;
import bibliothek.gui.dock.util.BackgroundPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class FlatMenu
extends AbstractCombinedMenu {
    private FlatTabPane pane;
    private Component component;
    private FlatMenuColor buttonEdge = new FlatMenuColor("stack.menu.edge");
    private FlatMenuColor buttonMiddle = new FlatMenuColor("stack.menu.middle");
    private FlatMenuColor buttonEdgeSelected = new FlatMenuColor("stack.menu.edge.selected");
    private FlatMenuColor buttonMiddleSelected = new FlatMenuColor("stack.menu.middle.selected");

    public FlatMenu(FlatTabPane parent) {
        super(parent, parent.getMenuHandler());
        this.pane = parent;
    }

    @Override
    protected Component createComponent() {
        this.component = new Button();
        return this.component;
    }

    @Override
    protected void selected(Dockable dockable) {
        this.pane.setSelectedDockable(dockable);
    }

    @Override
    public void setController(DockController controller) {
        super.setController(controller);
        this.buttonEdge.connect(controller);
        this.buttonMiddle.connect(controller);
        this.buttonEdgeSelected.connect(controller);
        this.buttonMiddleSelected.connect(controller);
    }

    private class Button
    extends BackgroundPanel {
        private boolean mouseInsideButton;

        public Button() {
            super(true, false);
            this.mouseInsideButton = false;
            this.setBackground(FlatMenu.this.getBackground());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Button.this.mouseInsideButton = true;
                    Button.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Button.this.mouseInsideButton = false;
                    Button.this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    FlatMenu.this.open();
                }
            });
            this.setPreferredSize(new Dimension(20, 20));
        }

        @Override
        public void paintBackground(Graphics g) {
            super.paintComponent(g);
            Color edge = null;
            Color middle = null;
            if (this.mouseInsideButton) {
                edge = FlatMenu.this.buttonEdgeSelected.color();
                middle = FlatMenu.this.buttonMiddleSelected.color();
            }
            if (edge == null) {
                edge = FlatMenu.this.buttonEdge.color();
            }
            if (middle == null) {
                middle = FlatMenu.this.buttonMiddleSelected.color();
            }
            if (edge == null) {
                edge = this.getBackground();
            }
            if (middle == null) {
                middle = this.getBackground();
            }
            Graphics2D g2 = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, edge, (width + 1) / 2, 0.0f, middle));
            g2.drawLine(0, 0, width, 0);
            g2.drawLine(0, height - 1, width, height - 1);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, edge, 0.0f, (height + 1) / 2, middle));
            g2.drawLine(0, 0, 0, height);
            g2.drawLine(width - 1, 0, width - 1, height);
        }
    }

    private class FlatMenuColor
    extends MenuColor {
        public FlatMenuColor(String id) {
            super(id, FlatMenu.this.pane.getStation(), FlatMenu.this, null);
        }

        @Override
        protected void changed(Color oldValue, Color newValue) {
            if (FlatMenu.this.component != null) {
                FlatMenu.this.component.repaint();
            }
        }
    }
}

