/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.perspective;

import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.perspective.CElementPerspective;
import bibliothek.gui.dock.common.perspective.CPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.SingleCDockablePerspective;
import bibliothek.gui.dock.frontend.FrontendPerspectiveCache;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.layout.DockLayout;
import bibliothek.gui.dock.layout.DockLayoutComposition;
import bibliothek.gui.dock.perspective.Perspective;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.util.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CControlPerspective {
    private CControlAccess control;

    public CControlPerspective(CControlAccess control) {
        if (control == null) {
            throw new IllegalArgumentException("control must not be null");
        }
        this.control = control;
    }

    public CPerspective createEmptyPerspective() {
        CPerspective perspective = new CPerspective(this.control);
        for (CStation<?> station : this.control.getOwner().getStations()) {
            perspective.addRoot(station.createPerspective());
        }
        return perspective;
    }

    public CPerspective getPerspective(boolean includeWorkingAreas) {
        Setting setting = this.control.getOwner().intern().getSetting(!includeWorkingAreas);
        return this.convert((CSetting)setting, includeWorkingAreas);
    }

    public String[] getNames() {
        return this.control.getOwner().layouts();
    }

    public CPerspective getPerspective(String name) {
        Setting setting = this.control.getOwner().intern().getSetting(name);
        if (setting == null) {
            return null;
        }
        return this.convert((CSetting)setting, false);
    }

    public void setPerspective(CPerspective perspective, boolean includeWorkingAreas) {
        this.control.getOwner().intern().setSetting(this.convert(perspective, includeWorkingAreas), !includeWorkingAreas);
    }

    public void setPerspective(String name, CPerspective perspective) {
        this.control.getOwner().intern().setSetting(name, this.convert(perspective, false));
    }

    public void removePerspective(String name) {
        this.control.getOwner().delete(name);
    }

    public void renamePerspective(String source, String destination) {
        if (source == null) {
            throw new IllegalArgumentException("source is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        CDockFrontend frontend = this.control.getOwner().intern();
        Setting layout = frontend.getSetting(source);
        if (layout == null) {
            throw new IllegalArgumentException("no perspective registered with name '" + source + "'");
        }
        frontend.setSetting(destination, layout);
        frontend.delete(source);
        if (source.equals(frontend.getCurrentSetting())) {
            frontend.setCurrentSettingName(destination);
        }
    }

    private Setting convert(CPerspective perspective, boolean includeWorkingAreas) {
        CSetting setting = new CSetting();
        Perspective conversion = this.control.getOwner().intern().getPerspective(!includeWorkingAreas, new PerspectiveElementFactory(perspective, null));
        conversion.getSituation().add(new CommonSingleDockableFactory(this.control.getOwner(), perspective));
        for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : this.control.getRegister().getFactories().entrySet()) {
            conversion.getSituation().add(new CommonMultipleDockableFactory(entry.getKey(), entry.getValue(), this.control, perspective));
        }
        String[] stringArray = perspective.getRootKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            CStationPerspective station = perspective.getRoot(key);
            if (station.asDockable() == null || station.asDockable().getParent() == null) {
                setting.putRoot(key, conversion.convert(station.intern()));
            }
            ++n2;
        }
        setting.setModes(perspective.getLocationManager().writeModes(this.control));
        return setting;
    }

    private CPerspective convert(CSetting setting, boolean includeWorkingAreas) {
        CPerspective cperspective = this.createEmptyPerspective();
        Perspective perspective = this.control.getOwner().intern().getPerspective(!includeWorkingAreas, new PerspectiveElementFactory(cperspective, setting));
        String[] stringArray = setting.getRootKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            perspective.convert(setting.getRoot(key));
            ++n2;
        }
        cperspective.getLocationManager().readModes(setting.getModes(), cperspective, this.control);
        return cperspective;
    }

    private class PerspectiveElementFactory
    implements FrontendPerspectiveCache {
        private CPerspective perspective;
        private CSetting setting;
        private Map<String, SingleCDockablePerspective> dockables = new HashMap<String, SingleCDockablePerspective>();

        public PerspectiveElementFactory(CPerspective perspective, CSetting setting) {
            this.perspective = perspective;
            this.setting = setting;
            Iterator<PerspectiveElement> elements = perspective.elements();
            while (elements.hasNext()) {
                PerspectiveElement element = elements.next();
                if (!(element instanceof SingleCDockablePerspective)) continue;
                SingleCDockablePerspective dockable = (SingleCDockablePerspective)((Object)element);
                this.dockables.put(dockable.getUniqueId(), dockable);
            }
        }

        @Override
        public PerspectiveElement get(String id, DockElement element, boolean isRootStation) {
            CDockable dockable;
            if (isRootStation) {
                return this.perspective.getRoot(id).intern();
            }
            if (element instanceof CommonDockable && (dockable = ((CommonDockable)element).getDockable()) instanceof SingleCDockable) {
                String key = ((SingleCDockable)dockable).getUniqueId();
                SingleCDockablePerspective result = this.dockables.get(key);
                if (result == null) {
                    result = new SingleCDockablePerspective(key);
                    this.dockables.put(key, result);
                }
                return result.intern();
            }
            throw new IllegalArgumentException("The intern DockFrontend of the CControl has elements registered that are not SingleCDockables: " + id + "=" + element);
        }

        @Override
        public PerspectiveElement get(String id, boolean rootStation) {
            if (rootStation) {
                CStationPerspective station;
                DockLayout<?> layout;
                DockLayoutComposition root = this.setting.getPredefinedStation(id);
                Path stationType = null;
                if (root != null && (layout = root.getAdjacent("dock.RootStationAdjacentFactory")) != null) {
                    stationType = (Path)layout.getData();
                }
                if ((station = this.perspective.getRoot(id)) == null && (station = CControlPerspective.this.control.getOwner().getMissingPerspectiveStrategy().createRoot(id, stationType)) != null) {
                    this.perspective.addRoot(station);
                }
                if (station == null) {
                    return null;
                }
                return station.intern();
            }
            if (CControlPerspective.this.control.getRegister().isSingleId(id)) {
                String key = CControlPerspective.this.control.getRegister().singleToNormalId(id);
                SingleCDockablePerspective result = this.dockables.get(key);
                if (result == null) {
                    result = new SingleCDockablePerspective(key);
                    this.dockables.put(key, result);
                }
                return result.intern();
            }
            return null;
        }

        @Override
        public String get(PerspectiveElement element) {
            CElementPerspective celement;
            String[] stringArray = this.perspective.getRootKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                CStationPerspective station = this.perspective.getRoot(key);
                if (station.intern() == element) {
                    return key;
                }
                ++n2;
            }
            if (element instanceof CommonElementPerspective && (celement = ((CommonElementPerspective)element).getElement()) instanceof SingleCDockablePerspective) {
                return CControlPerspective.this.control.getRegister().toSingleId(((SingleCDockablePerspective)celement).getUniqueId());
            }
            return null;
        }

        @Override
        public boolean isRootStation(PerspectiveStation element) {
            String[] stringArray = this.perspective.getRootKeys();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                CStationPerspective station = this.perspective.getRoot(key);
                if (station.intern() == element) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

