/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.control.ControllerSetupCollection;
import bibliothek.gui.dock.control.focus.AbstractMouseFocusObserver;
import bibliothek.gui.dock.event.ControllerSetupListener;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;

public class DefaultMouseFocusObserver
extends AbstractMouseFocusObserver {
    private AWTEventListener listener;
    private PropertyValue<Boolean> restricted = new PropertyValue<Boolean>(DockController.RESTRICTED_ENVIRONMENT){

        @Override
        protected void valueChanged(Boolean oldValue, Boolean newValue) {
            DefaultMouseFocusObserver.this.updateRestricted();
        }
    };

    public DefaultMouseFocusObserver(DockController controller, ControllerSetupCollection setup) {
        super(controller, setup);
        setup.add(new ControllerSetupListener(){

            @Override
            public void done(DockController controller) {
                DefaultMouseFocusObserver.this.restricted.setProperties(controller);
                DefaultMouseFocusObserver.this.updateRestricted();
            }
        });
    }

    private void updateRestricted() {
        if (this.restricted.getProperties() != null) {
            if (!this.restricted.getValue().booleanValue()) {
                if (this.listener == null) {
                    this.listener = this.createListener();
                    try {
                        Toolkit.getDefaultToolkit().addAWTEventListener(this.listener, 131088L);
                    }
                    catch (SecurityException ex) {
                        System.err.println("Can't register AWTEventListener, support for global MouseEvents disabled");
                        ex.printStackTrace();
                    }
                }
            } else if (this.listener != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
                this.listener = null;
            }
        }
    }

    @Override
    public void kill() {
        super.kill();
        if (this.listener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.listener);
            this.listener = null;
        }
        this.restricted.setProperties((DockController)null);
    }

    protected AWTEventListener createListener() {
        return new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (DefaultMouseFocusObserver.this.interact(event)) {
                    DefaultMouseFocusObserver.this.check(event);
                }
            }
        };
    }
}

