/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.accept.MultiDockAcceptance;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRelocatorAdapter;

public class SingleParentRemover {
    private DockRelocatorObserver dockRelocatorObserver = new DockRelocatorObserver();
    private DockRegisterObserver dockRegisterObserver = new DockRegisterObserver();
    private boolean onTest = false;

    public void install(DockController controller) {
        controller.getRelocator().addDockRelocatorListener(this.dockRelocatorObserver);
        controller.getRegister().addDockRegisterListener(this.dockRegisterObserver);
        this.testAll(controller);
    }

    public void uninstall(DockController controller) {
        controller.getRelocator().removeDockRelocatorListener(this.dockRelocatorObserver);
        controller.getRegister().removeDockRegisterListener(this.dockRegisterObserver);
    }

    public void testAll(DockController controller) {
        if (this.onTest) {
            return;
        }
        try {
            this.onTest = true;
            controller.getRegister().setStalled(true);
            int index = 0;
            while (index < controller.getRegister().getStationCount()) {
                if (this.test(controller.getRegister().getStation(index))) {
                    index = 0;
                    continue;
                }
                ++index;
            }
        }
        finally {
            controller.getRegister().setStalled(false);
            this.onTest = false;
        }
    }

    protected boolean shouldTest(DockStation station) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean test(DockStation station) {
        DockController controller = station.getController();
        if (controller != null) {
            controller.getRegister().setStalled(true);
            controller.getHierarchyLock().setConcurrent(true);
        }
        try {
            if (!this.shouldTest(station)) {
                return false;
            }
            if (station.getDockableCount() > 1) {
                return false;
            }
            Dockable transform = station.asDockable();
            if (transform == null) {
                return false;
            }
            DockStation parent = transform.getDockParent();
            if (parent == null) {
                return false;
            }
            if (parent.getController() == null) {
                return false;
            }
            if (station.getDockableCount() == 0) {
                if (!parent.canDrag(transform)) {
                    return false;
                }
                parent.drag(transform);
                return true;
            }
            Dockable dockable = station.getDockable(0);
            if (!station.canDrag(dockable)) {
                return false;
            }
            if (!parent.accept(dockable)) return false;
            if (!dockable.accept(parent)) {
                return false;
            }
            if (!parent.canReplace(transform, dockable)) {
                return false;
            }
            MultiDockAcceptance acceptance = station.getController().getAcceptance();
            if (acceptance != null && !acceptance.accept(parent, dockable)) {
                return false;
            }
            station.drag(dockable);
            parent.replace(transform.asDockStation(), dockable);
            return true;
        }
        finally {
            if (controller != null) {
                controller.getHierarchyLock().setConcurrent(false);
                controller.getRegister().setStalled(false);
            }
        }
    }

    private class DockRegisterObserver
    extends DockRegisterAdapter {
        private DockRegisterObserver() {
        }

        @Override
        public void dockableCycledRegister(DockController controller, Dockable dockable) {
            SingleParentRemover.this.testAll(controller);
        }

        @Override
        public void dockableRegistered(DockController controller, Dockable dockable) {
            if (!controller.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(controller);
            }
        }

        @Override
        public void dockableUnregistered(DockController controller, Dockable dockable) {
            if (!controller.getRelocator().isOnPut()) {
                SingleParentRemover.this.testAll(controller);
            }
        }
    }

    private class DockRelocatorObserver
    extends DockRelocatorAdapter {
        private DockRelocatorObserver() {
        }

        @Override
        public void drop(DockController controller, Dockable dockable, DockStation station) {
            SingleParentRemover.this.testAll(controller);
        }
    }
}

