/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.focus;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.FocusStrategy;
import bibliothek.gui.dock.control.focus.FocusTracker;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRegisterListener;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class DefaultFocusStrategy
implements FocusStrategy {
    private DockController controller;
    private Map<Component, Tracker> trackers = new HashMap<Component, Tracker>();
    private DockRegisterListener listener = new DockRegisterAdapter(){

        @Override
        public void dockableRegistered(DockController controller, Dockable dockable) {
            DefaultFocusStrategy.this.add(dockable);
        }

        @Override
        public void dockableUnregistered(DockController controller, Dockable dockable) {
            DefaultFocusStrategy.this.remove(dockable);
        }
    };

    public DefaultFocusStrategy(DockController controller) {
        this.controller = controller;
    }

    protected boolean focusable(Component component) {
        while (component != null) {
            if (component instanceof JComboBox) {
                return true;
            }
            component = component.getParent();
        }
        return false;
    }

    @Override
    public Component getFocusComponent(Dockable dockable, Component mouseClicked) {
        if (mouseClicked != null && (mouseClicked.isFocusable() || this.focusable(mouseClicked))) {
            return mouseClicked;
        }
        Tracker tracker = this.trackers.get(dockable.getComponent());
        if (tracker == null) {
            return null;
        }
        return tracker.getLastFocused();
    }

    @Override
    public void bind() {
        DockRegister register = this.controller.getRegister();
        register.addDockRegisterListener(this.listener);
        int i = 0;
        int n = register.getDockableCount();
        while (i < n) {
            this.add(register.getDockable(i));
            ++i;
        }
    }

    @Override
    public void unbind() {
        this.controller.getRegister().removeDockRegisterListener(this.listener);
        for (Tracker tracker : this.trackers.values()) {
            tracker.destroy();
        }
        this.trackers.clear();
    }

    private void add(Dockable dockable) {
        Tracker tracker = new Tracker(dockable);
        for (Tracker other : this.trackers.values()) {
            if (!SwingUtilities.isDescendingFrom(dockable.getComponent(), other.dockable.getComponent())) continue;
            other.remove(dockable.getComponent());
        }
        this.trackers.put(dockable.getComponent(), tracker);
    }

    private void remove(Dockable dockable) {
        Tracker tracker = this.trackers.remove(dockable.getComponent());
        if (tracker != null) {
            tracker.destroy();
        }
    }

    private class Tracker
    extends FocusTracker {
        private Dockable dockable;

        public Tracker(Dockable dockable) {
            super(dockable.getComponent());
            this.dockable = dockable;
        }

        @Override
        protected void add(Component component) {
            if (!DefaultFocusStrategy.this.trackers.containsKey(component)) {
                super.add(component);
            }
        }
    }
}

