/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.event.DockRelocatorListener;

public class MergeOperation
implements RelocateOperation {
    private DockController controller;
    private Merger merger;
    private DockStation station;

    public MergeOperation(DockController controller, Merger merger, DockStation station) {
        this.controller = controller;
        this.merger = merger;
        this.station = station;
    }

    @Override
    public DockStation getStation() {
        return this.station;
    }

    @Override
    public void execute(Dockable selection, DockRelocatorListener listener) {
        DockStation child = selection.asDockStation();
        Dockable[] children = new Dockable[child.getDockableCount()];
        int i = 0;
        while (i < children.length) {
            children[i] = child.getDockable(i);
            listener.drag(this.controller, children[i], child);
            ++i;
        }
        this.merger.merge(this.station, child);
        Dockable[] dockableArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Dockable dockable = dockableArray[n2];
            listener.drop(this.controller, dockable, this.station);
            ++n2;
        }
        DockStation parent = selection.getDockParent();
        if (parent != null && parent != this.station) {
            parent.drag(selection);
        }
    }
}

