/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.event;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;

public class DockHierarchyEvent {
    private Dockable dockable;
    private DockStation[] path;
    private DockController controller;

    public DockHierarchyEvent(Dockable dockable) {
        this(dockable, dockable.getController());
    }

    public DockHierarchyEvent(Dockable dockable, DockController controller) {
        this.dockable = dockable;
        this.controller = controller;
        int count = 0;
        DockStation station = dockable.getDockParent();
        while (station != null) {
            ++count;
            Dockable stationDockable = station.asDockable();
            station = stationDockable == null ? null : stationDockable.getDockParent();
        }
        this.path = new DockStation[count];
        station = dockable.getDockParent();
        int i = count - 1;
        while (i >= 0) {
            this.path[i] = station;
            if (i > 0) {
                station = station.asDockable().getDockParent();
            }
            --i;
        }
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockStation[] getPath() {
        return this.path;
    }

    public DockController getController() {
        return this.controller;
    }
}

