/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.action;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionIcon;
import bibliothek.gui.dock.action.DockActionText;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import javax.swing.Icon;

public class ReplaceAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    public static final String KEY_ICON = "replace";
    private DockStationListener dockStationListener = new DockStationAdapter(){

        @Override
        public void dockableAdded(DockStation station, Dockable dockable) {
            ReplaceAction.this.setGroup(ReplaceAction.this.createGroupKey(station.asDockable()), station.asDockable());
        }

        @Override
        public void dockableRemoved(DockStation station, Dockable dockable) {
            ReplaceAction.this.setGroup(ReplaceAction.this.createGroupKey(station.asDockable()), station.asDockable());
        }
    };
    private DockActionText text;
    private DockActionText tooltip;
    private DockActionIcon icon;

    public ReplaceAction(DockController controller) {
        super(null);
        this.setRemoveEmptyGroups(false);
        this.setEnabled(true, true);
        this.setEnabled(false, false);
        this.text = new DockActionText(KEY_ICON, this){

            @Override
            protected void changed(String oldValue, String newValue) {
                ReplaceAction.this.setText(true, newValue);
                ReplaceAction.this.setText(false, newValue);
            }
        };
        this.tooltip = new DockActionText("replace.tooltip", this){

            @Override
            protected void changed(String oldValue, String newValue) {
                ReplaceAction.this.setTooltip(true, newValue);
                ReplaceAction.this.setTooltip(false, newValue);
            }
        };
        this.icon = new DockActionIcon(KEY_ICON, this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                ReplaceAction.this.setIcon(true, newValue);
                ReplaceAction.this.setIcon(false, newValue);
            }
        };
        this.setController(controller);
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        DockStation station = dockable.asDockStation();
        if (station == null) {
            throw new IllegalArgumentException("Only dockables which are also a DockStation can be used for a ReplaceAction");
        }
        DockStation parent = dockable.getDockParent();
        if (parent == null) {
            return false;
        }
        int count = station.getDockableCount();
        if (count == 0) {
            return parent.canDrag(dockable);
        }
        if (count == 1) {
            if (parent.canReplace(dockable, station.getDockable(0)) && parent.accept(station.getDockable(0)) && station.getDockable(0).accept(parent) && station.canDrag(station.getDockable(0))) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void action(Dockable dockable) {
        DockStation station = dockable.asDockStation();
        if (station == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        DockStation parent = dockable.getDockParent();
        if (parent != null) {
            if (station.getDockableCount() == 0) {
                if (parent.canDrag(station.asDockable())) {
                    parent.drag(station.asDockable());
                }
            } else if (parent.canReplace(station.asDockable(), station.getDockable(0)) && parent.accept(station.getDockable(0)) && station.getDockable(0).accept(parent) && station.canDrag(station.getDockable(0))) {
                dockable = station.getDockable(0);
                station.drag(dockable);
                parent.replace(station.asDockable(), dockable);
            }
        }
    }

    @Override
    public void bound(Dockable dockable) {
        DockStation station = dockable.asDockStation();
        if (station == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        station.addDockStationListener(this.dockStationListener);
        super.bound(dockable);
    }

    @Override
    public void unbound(Dockable dockable) {
        DockStation station = dockable.asDockStation();
        if (station == null) {
            throw new IllegalArgumentException("dockable is not a station");
        }
        station.removeDockStationListener(this.dockStationListener);
        super.unbound(dockable);
    }

    @Override
    public void setController(DockController controller) {
        this.icon.setController(controller);
        this.text.setController(controller);
        this.tooltip.setController(controller);
    }
}

