/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.MultiDockActionSource;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.group.CGroupBehaviorCallback;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.group.StackGroupBehavior;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRelocatorAdapter;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.facile.mode.DoubleClickLocationStrategy;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.status.DefaultExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementListener;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocationModeManager<M extends LocationMode>
extends ModeManager<Location, M> {
    public static final PropertyKey<ExtendedModeEnablementFactory> MODE_ENABLEMENT = new PropertyKey<ExtendedModeEnablementFactory>("locationmodemanager.mode_enablement", new ConstantPropertyFactory<ExtendedModeEnablementFactory>(DefaultExtendedModeEnablement.FACTORY), true);
    public static final PropertyKey<DoubleClickLocationStrategy> DOUBLE_CLICK_STRATEGY = new PropertyKey<DoubleClickLocationStrategy>("locationmodemanager.double_click_strategy", new ConstantPropertyFactory<DoubleClickLocationStrategy>(DoubleClickLocationStrategy.DEFAULT), true);
    private Map<Path, List<LocationModeListener>> listeners = new HashMap<Path, List<LocationModeListener>>();
    private RegisterListener registerListener = new RegisterListener();
    private HierarchyListener hierarchyListener = new HierarchyListener();
    private RelocatorListener relocatorListener = new RelocatorListener();
    private CGroupBehavior behavior = new StackGroupBehavior();
    private List<CGroupMovement> currentAction = new ArrayList<CGroupMovement>();
    private PropertyValue<ExtendedModeEnablementFactory> extendedModeFactory = new PropertyValue<ExtendedModeEnablementFactory>(MODE_ENABLEMENT){

        @Override
        protected void valueChanged(ExtendedModeEnablementFactory oldValue, ExtendedModeEnablementFactory newValue) {
            LocationModeManager.this.updateEnablement();
        }
    };
    private PropertyValue<DoubleClickLocationStrategy> doubleClickStrategy = new PropertyValue<DoubleClickLocationStrategy>(DOUBLE_CLICK_STRATEGY){

        @Override
        protected void valueChanged(DoubleClickLocationStrategy oldValue, DoubleClickLocationStrategy newValue) {
        }
    };
    private ExtendedModeEnablementListener enablementListener = new ExtendedModeEnablementListener(){

        @Override
        public void availabilityChanged(Dockable dockable, ExtendedMode mode, boolean available) {
            LocationModeManager.this.refresh(dockable, true);
        }
    };
    private DoubleClickListener doubleClickListener = new DoubleClickListener(){

        @Override
        public DockElement getTreeLocation() {
            return null;
        }

        @Override
        public boolean process(Dockable dockable, MouseEvent event) {
            if (event.isConsumed()) {
                return false;
            }
            if ((dockable = LocationModeManager.this.getDoubleClickTarget(dockable)) != null) {
                Mode current = LocationModeManager.this.getCurrentMode(dockable);
                ExtendedMode next = LocationModeManager.this.getDoubleClickStrategy().handleDoubleClick(dockable, current == null ? null : current.getExtendedMode(), LocationModeManager.this.enablement);
                if (next != null && LocationModeManager.this.enablement.isAvailable(dockable, next)) {
                    LocationModeManager.this.setMode(dockable, next);
                    LocationModeManager.this.ensureValidLocation(dockable);
                    return true;
                }
            }
            return false;
        }
    };
    private ExtendedModeEnablement enablement;
    private int layoutMode = 0;

    public LocationModeManager(DockController controller) {
        super(controller);
        this.registerListener.connect(controller);
        controller.getRelocator().addDockRelocatorListener(this.relocatorListener);
        this.updateEnablement();
        this.extendedModeFactory.setProperties(controller);
        this.addModeManagerListener(new LocationModeListenerAdapter());
        controller.getDoubleClickController().addListener(this.doubleClickListener);
    }

    @Override
    public void destroy() {
        this.registerListener.connect(null);
        DockController controller = this.getController();
        controller.getRelocator().removeDockRelocatorListener(this.relocatorListener);
        controller.getDoubleClickController().removeListener(this.doubleClickListener);
        for (LocationMode mode : this.modes()) {
            mode.setController(null);
        }
        super.destroy();
        this.extendedModeFactory.setProperties((DockProperties)null);
    }

    protected void updateEnablement() {
        if (this.enablement != null) {
            this.enablement.removeListener(this.enablementListener);
            this.enablement.destroy();
            this.enablement = null;
        }
        if (this.getController() != null) {
            this.enablement = this.extendedModeFactory.getValue().create(this);
            this.enablement.addListener(this.enablementListener);
        }
        this.rebuildAll();
    }

    public void setGroupBehavior(CGroupBehavior behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException("the group behavior must not be null");
        }
        this.behavior = behavior;
    }

    public CGroupBehavior getGroupBehavior() {
        return this.behavior;
    }

    public void setMode(final Dockable dockable, final ExtendedMode extendedMode) {
        LocationMode mode = (LocationMode)this.getMode(extendedMode.getModeIdentifier());
        if (mode == null) {
            throw new IllegalArgumentException("No mode '" + extendedMode.getModeIdentifier() + "' available");
        }
        this.runTransaction(new Runnable(){

            @Override
            public void run() {
                CGroupMovement action = LocationModeManager.this.behavior.prepare(LocationModeManager.this, dockable, extendedMode);
                if (action == null) {
                    return;
                }
                LocationModeManager.this.apply(dockable, extendedMode, action);
            }
        });
    }

    public CGroupMovement getCurrentAction() {
        if (this.currentAction.isEmpty()) {
            return null;
        }
        return this.currentAction.get(this.currentAction.size() - 1);
    }

    public void apply(final Dockable dockable, final ExtendedMode extendedMode, final CGroupMovement action) {
        this.runTransaction(new AffectingRunnable(){

            @Override
            public void run(final AffectedSet set) {
                try {
                    LocationModeManager.this.getController().getFocusController().freezeFocus();
                    LocationModeManager.this.currentAction.add(action);
                    action.apply(new CGroupBehaviorCallback(){

                        @Override
                        public void setMode(Dockable element, ExtendedMode mode) {
                            LocationModeManager.this.apply(element, mode.getModeIdentifier(), false);
                        }

                        @Override
                        public void setLocation(Dockable element, Location location) {
                            LocationModeManager.this.apply(element, location.getMode(), location, set);
                        }

                        @Override
                        public LocationModeManager<? extends LocationMode> getManager() {
                            return LocationModeManager.this;
                        }

                        @Override
                        public Location getLocation(Dockable dockable) {
                            Mode mode = LocationModeManager.this.getCurrentMode(dockable);
                            if (mode == null) {
                                return null;
                            }
                            return (Location)mode.current(dockable);
                        }
                    });
                }
                finally {
                    LocationModeManager.this.currentAction.remove(action);
                    LocationModeManager.this.getController().getFocusController().meltFocus();
                }
                LocationMode mode = (LocationMode)LocationModeManager.this.getMode(extendedMode.getModeIdentifier());
                if (mode != null) {
                    if (mode.shouldAutoFocus()) {
                        LocationModeManager.this.getController().setFocusedDockable(dockable, null, true, true, false);
                    } else {
                        LocationModeManager.this.getController().setFocusedDockable(null, null, true);
                    }
                }
            }
        });
    }

    public ExtendedMode getMode(Dockable dockable) {
        Mode mode = this.getCurrentMode(dockable);
        if (mode == null) {
            return null;
        }
        return mode.getExtendedMode();
    }

    public Map<ExtendedMode, DockStation> getRepresentations(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        HashMap<ExtendedMode, DockStation> result = new HashMap<ExtendedMode, DockStation>();
        for (LocationMode mode : this.modes()) {
            DockStation station = mode.getRepresentation(id);
            if (station == null) continue;
            result.put(mode.getExtendedMode(), station);
        }
        return result;
    }

    @Override
    protected void applyDuringRead(String key, Path old, Path current, Dockable dockable) {
    }

    public boolean isModeAvailable(Dockable dockable, ExtendedMode mode) {
        if (this.enablement == null) {
            return false;
        }
        return this.enablement.isAvailable(dockable, mode);
    }

    public void addListener(Path identifier, LocationModeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        List<LocationModeListener> list = this.listeners.get(identifier);
        if (list == null) {
            list = new ArrayList<LocationModeListener>();
            this.listeners.put(identifier, list);
        }
        list.add(listener);
        LocationMode mode = (LocationMode)this.getMode(identifier);
        if (mode != null) {
            mode.addLocationModeListener(listener);
        }
    }

    public void removeListener(Path identifier, LocationModeListener listener) {
        LocationMode mode;
        List<LocationModeListener> list = this.listeners.get(identifier);
        if (list == null) {
            return;
        }
        list.remove(listener);
        if (list.isEmpty()) {
            this.listeners.remove(identifier);
        }
        if ((mode = (LocationMode)this.getMode(identifier)) != null) {
            mode.removeLocationModeListener(listener);
        }
    }

    @Override
    public M getCurrentMode(Dockable dockable) {
        while (dockable != null) {
            for (LocationMode mode : this.modes()) {
                if (!mode.isCurrentMode(dockable)) continue;
                return (M)mode;
            }
            DockStation station = dockable.getDockParent();
            Dockable dockable2 = dockable = station == null ? null : station.asDockable();
        }
        return null;
    }

    public DoubleClickLocationStrategy getDoubleClickStrategy() {
        return this.doubleClickStrategy.getValue();
    }

    public void setDoubleClickStrategy(DoubleClickLocationStrategy strategy) {
        this.doubleClickStrategy.setValue(strategy);
    }

    public boolean isLayouting() {
        return this.layoutMode > 0;
    }

    public void runLayoutTransaction(Runnable run) {
        try {
            ++this.layoutMode;
            this.runTransaction(run, true);
        }
        finally {
            --this.layoutMode;
        }
    }

    public void ensureNotHidden(final Dockable dockable) {
        if (this.isLayouting()) {
            return;
        }
        this.runTransaction(new Runnable(){

            @Override
            public void run() {
                for (LocationMode mode : LocationModeManager.this.modes()) {
                    mode.ensureNotHidden(dockable);
                }
            }
        });
    }

    public void ensureValidLocation(Dockable dockable) {
    }

    @Override
    public DockActionSource getSharedActions(DockStation station) {
        Dockable selected = station.getFrontDockable();
        if (selected == null) {
            return null;
        }
        Mode mode = this.getCurrentMode(selected);
        if (mode == null) {
            return null;
        }
        MultiDockActionSource result = new MultiDockActionSource(new DockActionSource[0]);
        for (LocationMode other : this.modes()) {
            DockActionSource source;
            if (!this.behavior.shouldForwardActions(this, station, selected, other.getExtendedMode()) || (source = other.getActionsFor(selected, mode)) == null) continue;
            result.add(source);
        }
        return result;
    }

    private class HierarchyListener
    implements DockHierarchyListener {
        private HierarchyListener() {
        }

        @Override
        public void controllerChanged(DockHierarchyEvent event) {
        }

        @Override
        public void hierarchyChanged(DockHierarchyEvent event) {
            if (!LocationModeManager.this.isOnTransaction()) {
                LocationModeManager.this.refresh(event.getDockable(), true);
            }
        }
    }

    private class LocationModeListenerAdapter
    implements ModeManagerListener<Location, LocationMode> {
        private LocationModeListenerAdapter() {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            mode.setManager(LocationModeManager.this);
            mode.setController(LocationModeManager.this.getController());
            List list = (List)LocationModeManager.this.listeners.get(mode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener listener : list) {
                    mode.addLocationModeListener(listener);
                }
            }
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, LocationMode mode) {
            mode.setManager(null);
            mode.setController(null);
            List list = (List)LocationModeManager.this.listeners.get(mode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener listener : list) {
                    mode.removeLocationModeListener(listener);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> manager, Dockable dockable, LocationMode oldMode, LocationMode newMode) {
        }
    }

    private class RegisterListener
    extends DockRegisterAdapter {
        private DockController controller;

        private RegisterListener() {
        }

        public void connect(DockController controller) {
            Dockable dockable;
            int n;
            int n2;
            Dockable[] dockableArray;
            DockRegister register;
            if (this.controller != null) {
                register = this.controller.getRegister();
                register.removeDockRegisterListener(this);
                dockableArray = register.listDockables();
                n2 = dockableArray.length;
                n = 0;
                while (n < n2) {
                    dockable = dockableArray[n];
                    dockable.removeDockHierarchyListener(LocationModeManager.this.hierarchyListener);
                    LocationModeManager.this.rebuild(dockable);
                    ++n;
                }
            }
            this.controller = controller;
            if (controller != null) {
                register = controller.getRegister();
                register.addDockRegisterListener(this);
                dockableArray = register.listDockables();
                n2 = dockableArray.length;
                n = 0;
                while (n < n2) {
                    dockable = dockableArray[n];
                    dockable.addDockHierarchyListener(LocationModeManager.this.hierarchyListener);
                    ++n;
                }
            }
        }

        @Override
        public void dockableRegistered(DockController controller, Dockable dockable) {
            dockable.addDockHierarchyListener(LocationModeManager.this.hierarchyListener);
            LocationModeManager.this.rebuild(dockable);
        }

        @Override
        public void dockableUnregistered(DockController controller, Dockable dockable) {
            dockable.removeDockHierarchyListener(LocationModeManager.this.hierarchyListener);
        }
    }

    private class RelocatorListener
    extends DockRelocatorAdapter {
        private RelocatorListener() {
        }

        @Override
        public void drag(DockController controller, Dockable dockable, DockStation station) {
            LocationModeManager.this.store(dockable);
        }
    }
}

