/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.security;

import bibliothek.gui.DockController;
import bibliothek.util.JavaVersionWorkaround;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GlassedPane
extends JPanel {
    private JComponent contentPane = new JPanel();
    private JComponent glassPane = new GlassPane();
    private DockController controller;

    public GlassedPane() {
        this.setLayout(null);
        this.contentPane.setOpaque(false);
        this.setOpaque(false);
        this.add(this.glassPane);
        this.add(this.contentPane);
        this.setFocusCycleRoot(true);
    }

    public void setController(DockController controller) {
        this.controller = controller;
    }

    @Override
    public void doLayout() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.contentPane != null) {
            this.contentPane.setBounds(0, 0, width, height);
        }
        this.glassPane.setBounds(0, 0, width, height);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.contentPane == null) {
            return super.getPreferredSize();
        }
        return this.contentPane.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.contentPane == null) {
            return super.getMaximumSize();
        }
        return this.contentPane.getMaximumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.contentPane == null) {
            return super.getMinimumSize();
        }
        return this.contentPane.getMinimumSize();
    }

    public void setContentPane(JComponent contentPane) {
        this.contentPane = contentPane;
        this.removeAll();
        this.add(this.glassPane);
        if (contentPane != null) {
            this.add(contentPane);
        }
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    private class GlassPane
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component dragged;
        private Component over;
        private int downCount = 0;

        public GlassPane() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.setOpaque(false);
            this.setFocusable(false);
            JavaVersionWorkaround.markAsGlassPane(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!e.isConsumed() && this.isVisible()) {
                this.send(e);
            }
            if (!this.isVisible()) {
                this.downCount = 0;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (!e.isConsumed()) {
                this.send(e);
            }
        }

        private void send(MouseEvent e) {
            this.send(e, e.getID());
        }

        private void send(MouseEvent e, int id) {
            boolean exited;
            if (GlassedPane.this.contentPane == null) {
                return;
            }
            Point mouse = e.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, mouse.x, mouse.y);
            boolean drag = id == 506;
            boolean press = id == 501;
            boolean release = id == 502;
            boolean moved = id == 503;
            boolean entered = id == 504;
            boolean bl = exited = id == 505;
            if (drag && this.dragged == null) {
                this.dragged = component;
            } else if (drag) {
                component = this.dragged;
            }
            if (press) {
                this.downCount |= 1 << e.getButton();
            }
            if (this.downCount > 0 && this.dragged != null) {
                component = this.dragged;
            } else if (this.downCount > 0 && this.dragged == null) {
                this.dragged = component;
            } else if (this.downCount == 0) {
                this.dragged = null;
            }
            if (release) {
                this.downCount &= ~(1 << e.getButton());
            }
            if ((e.getModifiersEx() & 0x1C00) == 0) {
                this.downCount = 0;
                this.dragged = null;
            }
            if ((moved || entered || exited) && this.over != component) {
                if (this.over != null) {
                    this.over.dispatchEvent(new MouseEvent(this.over, 505, e.getWhen(), e.getModifiers(), mouse.x, mouse.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
                this.over = component;
                if (this.over != null) {
                    this.over.dispatchEvent(new MouseEvent(this.over, 504, e.getWhen(), e.getModifiers(), mouse.x, mouse.y, e.getClickCount(), e.isPopupTrigger(), e.getButton()));
                }
            }
            if (component == null) {
                this.setCursor(null);
                this.setToolTipText(null);
            } else {
                mouse = SwingUtilities.convertPoint(this, mouse, component);
                MouseEvent forward = new MouseEvent(component, id, e.getWhen(), e.getModifiers(), mouse.x, mouse.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
                if (GlassedPane.this.controller != null) {
                    GlassedPane.this.controller.getMouseFocusObserver().check(forward);
                }
                component.dispatchEvent(forward);
                Cursor cursor = component.getCursor();
                if (this.getCursor() != cursor) {
                    this.setCursor(cursor);
                }
                if (component instanceof JComponent) {
                    String thistip;
                    JComponent jcomp = (JComponent)component;
                    String tooltip = jcomp.getToolTipText(forward);
                    if (!(tooltip == (thistip = this.getToolTipText()) || tooltip != null && thistip != null && tooltip.equals(thistip))) {
                        this.setToolTipText(tooltip);
                    }
                } else {
                    this.setToolTipText(null);
                }
            }
        }

        private void send(MouseWheelEvent e) {
            if (GlassedPane.this.contentPane == null) {
                return;
            }
            Point mouse = e.getPoint();
            Component component = SwingUtilities.getDeepestComponentAt(GlassedPane.this.contentPane, mouse.x, mouse.y);
            if (component != null) {
                mouse = SwingUtilities.convertPoint(this, mouse, component);
                MouseWheelEvent forward = new MouseWheelEvent(component, e.getID(), e.getWhen(), e.getModifiers(), mouse.x, mouse.y, e.getClickCount(), e.isPopupTrigger(), e.getScrollType(), e.getScrollAmount(), e.getWheelRotation());
                if (GlassedPane.this.controller != null) {
                    GlassedPane.this.controller.getMouseFocusObserver().check(forward);
                }
                component.dispatchEvent(forward);
            }
        }
    }
}

