/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.event.DockTitleEvent;
import bibliothek.gui.dock.station.DockStationIcon;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleRequest;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public abstract class AbstractDockableStation
extends AbstractDockable
implements DockStation {
    protected DockStationListenerManager listeners = new DockStationListenerManager(this);
    private DockTheme theme;

    public AbstractDockableStation() {
        super(PropertyKey.DOCK_STATION_TITLE, PropertyKey.DOCK_STATION_TOOLTIP);
    }

    @Override
    protected DockIcon createTitleIcon() {
        return new DockStationIcon("dockStation.default", this){

            @Override
            protected void changed(Icon oldValue, Icon newValue) {
                AbstractDockableStation.this.fireTitleIconChanged(oldValue, newValue);
            }
        };
    }

    public AbstractDockableStation(DockTheme theme) {
        this();
        this.theme = theme;
    }

    @Override
    public DockStation asDockStation() {
        return this;
    }

    @Override
    public DockTheme getTheme() {
        return this.theme;
    }

    @Override
    public void updateTheme() {
        DockTheme newTheme;
        DockController controller = this.getController();
        if (controller != null && (newTheme = controller.getTheme()) != this.theme) {
            this.theme = newTheme;
            try {
                this.callDockUiUpdateTheme();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected abstract void callDockUiUpdateTheme() throws IOException;

    @Override
    public void requestDockTitle(DockTitleRequest request) {
    }

    @Override
    public DockActionSource getDirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public DockActionSource getIndirectActionOffers(Dockable dockable) {
        return null;
    }

    @Override
    public void addDockStationListener(DockStationListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeDockStationListener(DockStationListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public boolean isVisible(Dockable dockable) {
        return this.isStationVisible();
    }

    @Override
    public boolean isStationVisible() {
        boolean visible = this.isDockableVisible();
        if (visible) {
            return true;
        }
        if (this.getController() != null) {
            return this.getComponent().isShowing();
        }
        return false;
    }

    @Override
    public boolean accept(Dockable child) {
        return true;
    }

    protected boolean acceptable(Dockable child) {
        if (!this.accept(child)) {
            return false;
        }
        if (!child.accept(this)) {
            return false;
        }
        DockController controller = this.getController();
        return controller == null || controller.getAcceptance().accept(this, child);
    }

    @Override
    public boolean canCompare(DockStation station) {
        return false;
    }

    @Override
    public int compare(DockStation station) {
        return 0;
    }

    @Override
    public void changed(Dockable dockable, DockTitle title, boolean active) {
        title.changed(new DockTitleEvent(this, dockable, active));
    }

    @Override
    public void requestChildDockTitle(DockTitleRequest request) {
    }

    @Override
    public Rectangle getStationBounds() {
        Component component = this.getComponent();
        Point location = new Point(0, 0);
        SwingUtilities.convertPointToScreen(location, component);
        return new Rectangle(location.x, location.y, component.getWidth(), component.getHeight());
    }

    protected void fireDockablesRepositioned(int fromIndex) {
        this.fireDockablesRepositioned(fromIndex, this.getDockableCount() - 1);
    }

    protected void fireDockablesRepositioned(int fromIndex, int toIndex) {
        int count = toIndex - fromIndex + 1;
        if (count > 0) {
            Dockable[] moved = new Dockable[count];
            int i = 0;
            while (i < count) {
                moved[i] = this.getDockable(i + fromIndex);
                ++i;
            }
            this.listeners.fireDockablesRepositioned(moved);
        }
    }
}

