/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.split.Leaf;
import bibliothek.gui.dock.station.split.Node;
import bibliothek.gui.dock.station.split.PutInfo;
import bibliothek.gui.dock.station.split.SplitDockAccess;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.station.split.SplitNode;
import bibliothek.gui.dock.station.split.SplitNodeVisitor;
import bibliothek.gui.dock.station.split.SplitTreeFactory;
import bibliothek.gui.dock.station.split.VisibleSplitNode;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;

public class Root
extends VisibleSplitNode {
    private SplitNode child;
    private boolean treeChanged = true;
    private Rectangle baseBounds = null;

    public Root(SplitDockAccess access) {
        super(access, -1L);
    }

    public Root(SplitDockAccess access, long id) {
        super(access, id);
    }

    @Override
    protected void treeChanged() {
        this.treeChanged = true;
    }

    public boolean hasTreeChanged() {
        return this.treeChanged;
    }

    public void setChild(SplitNode child) {
        if (this.child != child) {
            if (this.child != null) {
                this.child.setParent(null);
            }
            this.child = child;
            if (child != null) {
                child.delete(false);
                child.setParent(this);
            }
            this.treeChanged();
            if (child != null) {
                this.ensureIdUniqueAsync();
            }
            this.getAccess().getOwner().revalidate();
            this.getAccess().getOwner().repaint();
            this.getAccess().repositioned(this);
        }
    }

    public SplitNode getChild() {
        return this.child;
    }

    @Override
    public int getChildLocation(SplitNode child) {
        if (child == this.child) {
            return 0;
        }
        return -1;
    }

    @Override
    public void setChild(SplitNode child, int location) {
        if (location != 0) {
            throw new IllegalArgumentException("Location invalid: " + location);
        }
        this.setChild(child);
    }

    @Override
    public int getMaxChildrenCount() {
        return 1;
    }

    @Override
    public SplitNode getChild(int location) {
        if (location == 0) {
            return this.getChild();
        }
        return null;
    }

    @Override
    public Root getRoot() {
        return this;
    }

    @Override
    public boolean isOfUse() {
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension result;
        Dimension dimension = result = this.child == null ? null : this.child.getMinimumSize();
        if (result == null) {
            return new Dimension(0, 0);
        }
        return result;
    }

    public double getWidthFactor() {
        return this.getBaseBounds().getWidth();
    }

    public double getHeightFactor() {
        return this.getBaseBounds().getHeight();
    }

    public void setBaseBounds(Rectangle baseBounds) {
        this.baseBounds = baseBounds;
    }

    public Rectangle getBaseBounds() {
        if (this.baseBounds != null) {
            return this.baseBounds;
        }
        JComponent base = this.getAccess().getOwner().getBasePane();
        Insets insets = base.getInsets();
        int x = 0;
        int y = 0;
        int width = base.getWidth();
        int height = base.getHeight();
        if (insets != null) {
            x = insets.left;
            y = insets.top;
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        return new Rectangle(x, y, width, height);
    }

    public PutInfo getPut(int x, int y, Dockable drop) {
        double factorW = this.getWidthFactor();
        double factorH = this.getHeightFactor();
        return this.getPut(x, y, factorW, factorH, drop);
    }

    public boolean isInOverrideZone(int x, int y) {
        double factorW = this.getWidthFactor();
        double factorH = this.getHeightFactor();
        return this.isInOverrideZone(x, y, factorW, factorH);
    }

    @Override
    public void evolve(SplitDockTree.Key key, boolean checkValidity, Map<Leaf, Dockable> linksToSet) {
        this.setChild(this.create(key, checkValidity, linksToSet));
    }

    @Override
    public boolean insert(SplitDockPlaceholderProperty property, Dockable dockable) {
        boolean done;
        boolean bl = done = this.child != null && this.child.insert(property, dockable);
        if (!done) {
            return this.getAccess().drop(dockable, property.toSplitLocation(this), this);
        }
        return true;
    }

    @Override
    public boolean insert(SplitDockPathProperty property, int depth, Dockable dockable) {
        if (this.child == null) {
            long id = property.getLeafId();
            Leaf leaf = this.create(dockable, id);
            if (leaf == null) {
                return false;
            }
            this.setChild(leaf);
            leaf.setDockable(dockable, null);
            return true;
        }
        return this.child.insert(property, depth, dockable);
    }

    @Override
    public <N> N submit(SplitTreeFactory<N> factory) {
        if (this.child == null) {
            return factory.root(null, this.getId());
        }
        return factory.root(this.child.submit(factory), this.getId());
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public SplitNode getVisible() {
        return this;
    }

    @Override
    public void updateBounds(double x, double y, double width, double height, double factorW, double factorH, boolean components) {
        super.updateBounds(x, y, width, height, factorW, factorH, components);
        if (this.child != null) {
            this.child.updateBounds(x, y, width, height, factorW, factorH, components);
        }
        this.treeChanged = false;
    }

    @Override
    public PutInfo getPut(int x, int y, double factorW, double factorH, Dockable drop) {
        if (!this.getBounds().contains(x, y)) {
            return null;
        }
        if (this.child != null) {
            return this.child.getPut(x, y, factorW, factorH, drop);
        }
        return null;
    }

    @Override
    public boolean isInOverrideZone(int x, int y, double factorW, double factorH) {
        if (!this.getBounds().contains(x, y)) {
            return false;
        }
        if (this.child != null) {
            return this.child.isInOverrideZone(x, y, factorW, factorH);
        }
        return false;
    }

    @Override
    public Leaf getLeaf(Dockable dockable) {
        return this.child == null ? null : this.child.getLeaf(dockable);
    }

    @Override
    public Node getDividerNode(int x, int y) {
        if (this.child == null) {
            return null;
        }
        return this.child.getDividerNode(x, y);
    }

    @Override
    public void visit(SplitNodeVisitor visitor) {
        visitor.handleRoot(this);
        if (this.child != null) {
            this.child.visit(visitor);
        }
    }

    @Override
    public void toString(int tabs, StringBuilder out) {
        out.append("Root [id=");
        out.append(this.getId());
        out.append("]\n");
        int i = 0;
        while (i < tabs + 1) {
            out.append('\t');
            ++i;
        }
        if (this.child != null) {
            this.child.toString(tabs + 1, out);
        } else {
            out.append("<null>");
        }
    }
}

