/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.AxisConversion;
import bibliothek.gui.dock.station.stack.tab.DefaultAxisConversion;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.TabPaneComponent;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabsLayoutBlock;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class LineTabsLayoutBlock
extends TabsLayoutBlock {
    private boolean sameSize = true;

    public boolean isSameSize() {
        return this.sameSize;
    }

    public void setSameSize(boolean sameSize) {
        this.sameSize = sameSize;
    }

    protected void checkSelection() {
        if (this.getSelectedTab() != null) {
            return;
        }
        TabPane pane = this.getPane();
        if (pane == null) {
            return;
        }
        Dockable selection = pane.getSelectedDockable();
        if (selection == null) {
            return;
        }
        this.insertTab(pane.putOnTab(selection));
    }

    public LineSize[] getSizes() {
        Tab[] tabs = this.getTabsOrderedByImportance();
        SizeCollector collector = new SizeCollector(this.getPane().getDockables());
        LineSize[] result = new LineSize[tabs.length + 1];
        int i = 0;
        while (i < tabs.length) {
            collector.insert(tabs[i]);
            Dimension size = collector.getMinimumSize();
            Tab[] selection = new Tab[i + 1];
            System.arraycopy(tabs, 0, selection, 0, i + 1);
            result[i] = new LineSize(Size.Type.MINIMUM, size, selection, i + 1 == tabs.length);
            ++i;
        }
        result[tabs.length] = new LineSize(Size.Type.PREFERRED, collector.getPreferredSize(), tabs, true);
        return result;
    }

    @Override
    public void doLayout() {
        Tab[] zOrdered;
        Tab[] tabs = this.getTabs();
        Rectangle bounds = this.getBounds();
        DefaultAxisConversion conversion = new DefaultAxisConversion(bounds, this.getOrientation());
        bounds = conversion.viewToModel(bounds);
        Dimension[] preferreds = new Dimension[tabs.length];
        Dimension[] minimums = new Dimension[tabs.length];
        int sumPreferred = 0;
        int sumMinimum = 0;
        int[] overlapPrevious = this.getOverlapToPrevious(tabs);
        int[] overlapNext = this.getOverlapToNext(tabs);
        int i = 0;
        while (i < tabs.length) {
            preferreds[i] = conversion.viewToModel(tabs[i].getPreferredSize());
            minimums[i] = conversion.viewToModel(tabs[i].getMinimumSize());
            sumPreferred += preferreds[i].width;
            sumMinimum += minimums[i].width;
            if (i > 0) {
                int delta = Math.max(overlapPrevious[i], overlapNext[i - 1]);
                sumPreferred -= delta;
                sumMinimum -= delta;
            }
            ++i;
        }
        ZOrder zorder = new ZOrder(tabs);
        if (sumPreferred <= bounds.width) {
            this.doLayoutPreferred(conversion, bounds.width, bounds.height, preferreds, tabs, zorder, overlapPrevious, overlapNext);
        } else if (sumMinimum <= bounds.width) {
            this.doLayoutMinimum(conversion, bounds.width, bounds.height, minimums, preferreds, tabs, zorder, overlapPrevious, overlapNext);
        } else {
            this.doLayoutShrinked(conversion, bounds.width, bounds.height, minimums, tabs, zorder, overlapPrevious, overlapNext);
        }
        int z = 0;
        Tab[] tabArray = zOrdered = zorder.getOrderedByZ();
        int n = zOrdered.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            if (tab != null) {
                tab.setZOrder(z++);
            }
            ++n2;
        }
    }

    private int[] getOverlapToPrevious(Tab[] tabs) {
        boolean horizontal = this.getOrientation().isHorizontal();
        int[] result = new int[tabs.length];
        int i = 1;
        while (i < tabs.length) {
            Insets overlap = tabs[i].getOverlap(tabs[i - 1]);
            result[i] = horizontal ? overlap.left : overlap.top;
            ++i;
        }
        return result;
    }

    private int[] getOverlapToNext(Tab[] tabs) {
        boolean horizontal = this.getOrientation().isHorizontal();
        int[] result = new int[tabs.length];
        int i = tabs.length - 2;
        while (i >= 0) {
            Insets overlap = tabs[i].getOverlap(tabs[i + 1]);
            result[i] = horizontal ? overlap.right : overlap.bottom;
            --i;
        }
        return result;
    }

    private void doLayoutPreferred(AxisConversion conversion, int width, int height, Dimension[] preferreds, Tab[] tabs, ZOrder order, int[] overlapPrevious, int[] overlapNext) {
        int x = 0;
        int i = 0;
        while (i < tabs.length) {
            Dimension size = preferreds[i];
            tabs[i].setBounds(conversion.modelToView(new Rectangle(x, 0, size.width, this.sameSize ? height : Math.min(height, size.height))));
            x += size.width;
            if (i + 1 < tabs.length) {
                if (overlapNext[i] > overlapPrevious[i + 1]) {
                    x -= overlapNext[i];
                    order.putOrder(tabs[i + 1], tabs[i]);
                } else {
                    x -= overlapPrevious[i + 1];
                    order.putOrder(tabs[i], tabs[i + 1]);
                }
            }
            ++i;
        }
    }

    private void doLayoutMinimum(AxisConversion conversion, int width, int height, Dimension[] minimums, Dimension[] preferreds, Tab[] tabs, ZOrder order, int[] overlapPrevious, int[] overlapNext) {
        int x = 0;
        int sumMinimum = 0;
        int sumPreferred = 0;
        Dimension[] dimensionArray = minimums;
        int n = minimums.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension minimum = dimensionArray[n2];
            sumMinimum += minimum.width;
            ++n2;
        }
        dimensionArray = preferreds;
        n = preferreds.length;
        n2 = 0;
        while (n2 < n) {
            Dimension preferred = dimensionArray[n2];
            sumPreferred += preferred.width;
            ++n2;
        }
        double passage = (double)(width - sumMinimum) / (double)(sumPreferred - sumMinimum);
        int i = 0;
        while (i < tabs.length - 1) {
            int tabWidth = (int)((double)minimums[i].width + passage * (double)(preferreds[i].width - minimums[i].width));
            tabs[i].setBounds(conversion.modelToView(new Rectangle(x, 0, tabWidth, this.sameSize ? height : Math.min(height, preferreds[i].height))));
            x += tabWidth;
            if (overlapNext[i] > overlapPrevious[i + 1]) {
                x -= overlapNext[i];
                order.putOrder(tabs[i + 1], tabs[i]);
            } else {
                x -= overlapPrevious[i + 1];
                order.putOrder(tabs[i], tabs[i + 1]);
            }
            ++i;
        }
        if (tabs.length > 0) {
            int last = tabs.length - 1;
            int tabWidth = Math.min(width - x, preferreds[last].width);
            tabs[last].setBounds(conversion.modelToView(new Rectangle(x, 0, tabWidth, this.sameSize ? height : Math.min(height, preferreds[last].height))));
        }
    }

    private void doLayoutShrinked(AxisConversion conversion, int width, int height, Dimension[] minimums, Tab[] tabs, ZOrder order, int[] overlapPrevious, int[] overlapNext) {
        int x = 0;
        int sum = 0;
        Dimension[] dimensionArray = minimums;
        int n = minimums.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension minimum = dimensionArray[n2];
            sum += minimum.width;
            ++n2;
        }
        double factor = (double)sum / (double)width;
        int i = 0;
        while (i < tabs.length - 1) {
            int tabWidth = (int)(factor * (double)minimums[i].width);
            tabs[i].setBounds(conversion.modelToView(new Rectangle(x, 0, tabWidth, this.sameSize ? height : Math.min(height, minimums[i].height))));
            x += tabWidth;
            if (overlapNext[i] > overlapPrevious[i + 1]) {
                x -= overlapNext[i];
                order.putOrder(tabs[i + 1], tabs[i]);
            } else {
                x -= overlapPrevious[i + 1];
                order.putOrder(tabs[i], tabs[i + 1]);
            }
            ++i;
        }
        int last = tabs.length - 1;
        if (last >= 0) {
            tabs[last].setBounds(conversion.modelToView(new Rectangle(x, 0, width - x, this.sameSize ? height : Math.min(height, minimums[last].height))));
        }
    }

    public class LineSize
    extends TabsLayoutBlock.TabsSize {
        private boolean allTabs;

        public LineSize(Size.Type type, Dimension size, Tab[] tabs, boolean allTabs) {
            super(LineTabsLayoutBlock.this, type, size, tabs);
            this.allTabs = allTabs;
        }

        public boolean isAllTabs() {
            return this.allTabs;
        }
    }

    protected class SizeCollector {
        private Dockable[] dockables;
        private Tab[] tabs;
        private Dimension[] minimum;
        private Dimension[] preferred;
        private int[] overlapPrevious;
        private int[] overlapNext;

        public SizeCollector(Dockable[] dockables) {
            this.dockables = dockables;
            int size = dockables.length;
            this.tabs = new Tab[size];
            this.minimum = new Dimension[size];
            this.preferred = new Dimension[size];
            this.overlapPrevious = new int[size];
            this.overlapNext = new int[size];
        }

        public void insert(Tab tab) {
            Dockable dockable = tab.getDockable();
            int i = 0;
            while (i < this.dockables.length) {
                if (this.dockables[i] == dockable) {
                    this.insert(tab, i);
                    return;
                }
                ++i;
            }
        }

        private Tab[] getVisibleTabs() {
            int count = 0;
            Tab[] tabArray = this.tabs;
            int n = this.tabs.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab = tabArray[n2];
                if (tab != null) {
                    ++count;
                }
                ++n2;
            }
            Tab[] visible = new Tab[count];
            int index = 0;
            Tab[] tabArray2 = this.tabs;
            int n3 = this.tabs.length;
            int n4 = 0;
            while (n4 < n3) {
                Tab tab = tabArray2[n4];
                if (tab != null) {
                    visible[index++] = tab;
                }
                ++n4;
            }
            return visible;
        }

        private void insert(Tab tab, int index) {
            this.tabs[index] = tab;
            Tab[] visibleTabs = this.getVisibleTabs();
            int i = 0;
            while (i < this.tabs.length) {
                if (this.tabs[i] != null) {
                    this.minimum[i] = this.tabs[i].getMinimumSize(visibleTabs);
                    this.preferred[i] = this.tabs[i].getPreferredSize(visibleTabs);
                }
                ++i;
            }
            boolean horizontal = LineTabsLayoutBlock.this.getOrientation().isHorizontal();
            int i2 = index - 1;
            while (i2 >= 0) {
                if (this.tabs[i2] != null) {
                    if (horizontal) {
                        this.overlapNext[i2] = this.tabs[i2].getOverlap((TabPaneComponent)tab).right;
                        this.overlapPrevious[index] = tab.getOverlap((TabPaneComponent)this.tabs[i2]).left;
                        break;
                    }
                    this.overlapNext[i2] = this.tabs[i2].getOverlap((TabPaneComponent)tab).bottom;
                    this.overlapPrevious[index] = tab.getOverlap((TabPaneComponent)this.tabs[i2]).top;
                    break;
                }
                --i2;
            }
            i2 = index + 1;
            while (i2 < this.tabs.length) {
                if (this.tabs[i2] != null) {
                    if (horizontal) {
                        this.overlapNext[index] = tab.getOverlap((TabPaneComponent)this.tabs[i2]).right;
                        this.overlapPrevious[i2] = this.tabs[i2].getOverlap((TabPaneComponent)tab).left;
                        break;
                    }
                    this.overlapNext[index] = tab.getOverlap((TabPaneComponent)this.tabs[i2]).bottom;
                    this.overlapPrevious[i2] = this.tabs[i2].getOverlap((TabPaneComponent)tab).top;
                    break;
                }
                ++i2;
            }
        }

        public Dimension getMinimumSize() {
            return this.getSize(this.minimum);
        }

        public Dimension getPreferredSize() {
            return this.getSize(this.preferred);
        }

        private Dimension getSize(Dimension[] required) {
            int width = 0;
            int height = 0;
            int previous = -1;
            if (LineTabsLayoutBlock.this.getOrientation().isHorizontal()) {
                int i = 0;
                while (i < this.tabs.length) {
                    if (this.tabs[i] != null) {
                        Dimension size = required[i];
                        height = Math.max(height, size.height);
                        width += size.width;
                        if (previous != -1) {
                            width -= Math.max(this.overlapNext[previous], this.overlapPrevious[i]);
                        }
                        previous = i;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.tabs.length) {
                    if (this.tabs[i] != null) {
                        Dimension size = required[i];
                        width = Math.max(width, size.width);
                        height += size.height;
                        if (previous != -1) {
                            height -= Math.max(this.overlapNext[previous], this.overlapPrevious[i]);
                        }
                        previous = i;
                    }
                    ++i;
                }
            }
            return new Dimension(width, height);
        }
    }

    protected class ZOrder {
        private Tab[] tabs;
        private List<Integer>[] onTop;
        private List<Integer>[] onBottom;

        public ZOrder(Tab[] tabs) {
            this.tabs = tabs;
            this.onTop = new List[tabs.length];
            this.onBottom = new List[tabs.length];
            int i = 0;
            while (i < tabs.length) {
                this.onTop[i] = new ArrayList<Integer>(5);
                this.onBottom[i] = new ArrayList<Integer>(5);
                ++i;
            }
        }

        public void putOrder(Tab front, Tab back) {
            int f = 0;
            while (f < this.tabs.length) {
                if (this.tabs[f] == front) {
                    int b = 0;
                    while (b < this.tabs.length) {
                        if (this.tabs[b] == back) {
                            this.onTop[b].add(f);
                            this.onBottom[f].add(b);
                            return;
                        }
                        ++b;
                    }
                }
                ++f;
            }
        }

        public int[] getZOrders() {
            int[] results = new int[this.tabs.length];
            boolean[] handled = new boolean[results.length];
            int i = 0;
            while (i < results.length) {
                int j = 0;
                while (j < results.length) {
                    if (!handled[j] && this.onTop[j].isEmpty()) {
                        results[j] = results.length - i;
                        handled[j] = true;
                        Integer index = i;
                        for (int bottom : this.onBottom[j]) {
                            this.onTop[bottom].remove(index);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return results;
        }

        public Tab[] getOrderedByZ() {
            Tab[] results = new Tab[this.tabs.length];
            boolean[] handled = new boolean[results.length];
            int i = 0;
            while (i < results.length) {
                int j = 0;
                while (j < results.length) {
                    if (!handled[j] && this.onTop[j].isEmpty()) {
                        results[i] = this.tabs[j];
                        handled[j] = true;
                        Integer index = i;
                        for (int bottom : this.onBottom[j]) {
                            this.onTop[bottom].remove(index);
                        }
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            return results;
        }
    }
}

