/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab.layouting;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.Tab;
import bibliothek.gui.dock.station.stack.tab.TabPane;
import bibliothek.gui.dock.station.stack.tab.layouting.LayoutBlock;
import bibliothek.gui.dock.station.stack.tab.layouting.Size;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public abstract class TabsLayoutBlock
implements LayoutBlock {
    private List<Tab> tabs = new ArrayList<Tab>();
    private Rectangle bounds = new Rectangle();
    private TabPane pane;
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;

    public void setPane(TabPane pane) {
        this.pane = pane;
    }

    public TabPane getPane() {
        return this.pane;
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    @Override
    public void setOrientation(TabPlacement side) {
        if (side == null) {
            throw new IllegalArgumentException("side must not be null");
        }
        if (this.orientation != side) {
            this.orientation = side;
            for (Tab tab : this.tabs) {
                tab.setOrientation(side);
            }
        }
    }

    public Tab getSelectedTab() {
        if (this.pane == null) {
            return null;
        }
        Dockable dockable = this.pane.getSelectedDockable();
        for (Tab tab : this.tabs) {
            if (tab.getDockable() != dockable) continue;
            return tab;
        }
        return null;
    }

    public void checkExistence() {
        ListIterator<Tab> iterator = this.tabs.listIterator();
        Tab[] existing = this.pane.getTabs();
        while (iterator.hasNext()) {
            Tab next = iterator.next();
            boolean found = false;
            Tab[] tabArray = existing;
            int n = existing.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab = tabArray[n2];
                if (next == tab) {
                    found = true;
                    break;
                }
                ++n2;
            }
            if (found) continue;
            iterator.remove();
        }
    }

    public Tab[] getTabs() {
        return this.tabs.toArray(new Tab[this.tabs.size()]);
    }

    public int getTabsCount() {
        return this.tabs.size();
    }

    public void addTab(Tab tab) {
        this.insertTab(tab, this.tabs.size());
    }

    public void insertTab(Tab tab) {
        int[] locations = this.getOriginalTabLocations();
        TabPane pane = this.getPane();
        Dockable[] dockables = pane.getDockables();
        int index = -1;
        int i = 0;
        while (i < dockables.length) {
            if (dockables[i] == tab.getDockable()) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            throw new IllegalArgumentException(tab.getDockable() + " is not a child of the TabPane");
        }
        int wrongSmaller = 0;
        int wrongBigger = 0;
        int i2 = 0;
        while (i2 < locations.length) {
            if (locations[i2] < index) {
                ++wrongSmaller;
            }
            ++i2;
        }
        int bestLocation = 0;
        int bestCount = wrongBigger + wrongSmaller;
        int i3 = 0;
        while (i3 < locations.length) {
            if (locations[i3] < index) {
                --wrongSmaller;
            } else if (locations[i3] > index) {
                ++wrongBigger;
            }
            int count = wrongSmaller + wrongBigger;
            if (count < bestCount) {
                bestCount = count;
                bestLocation = i3 + 1;
            }
            ++i3;
        }
        this.insertTab(tab, bestLocation);
    }

    public int indexOfTab(Tab tab) {
        return this.tabs.indexOf(tab);
    }

    public Tab[] getTabsOrderedByImportance() {
        int i;
        int selectedIndex;
        if (this.pane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Dockable[] dockables = this.pane.getDockables();
        Tab[] allTabs = new Tab[dockables.length];
        int[] visibleToInvisible = this.getOriginalTabLocations();
        int i2 = 0;
        while (i2 < allTabs.length) {
            allTabs[i2] = this.pane.getOnTab(dockables[i2]);
            ++i2;
        }
        Tab[] result = new Tab[allTabs.length];
        int resultIndex = 0;
        Dockable selectedDockable = this.pane.getSelectedDockable();
        Tab selected = null;
        Tab[] tabArray = allTabs;
        int n = allTabs.length;
        int n2 = 0;
        while (n2 < n) {
            Tab tab = tabArray[n2];
            if (tab.getDockable() == selectedDockable) {
                selected = tab;
                break;
            }
            ++n2;
        }
        int i3 = 0;
        while (i3 < allTabs.length) {
            if (selected == allTabs[i3]) {
                allTabs[i3] = null;
                result[resultIndex++] = selected;
                break;
            }
            ++i3;
        }
        int n3 = selectedIndex = selected == null ? -1 : this.indexOfTab(selected);
        if (selectedIndex == -1) {
            i = 0;
            while (i < visibleToInvisible.length) {
                Tab tab;
                if (visibleToInvisible[i] != -1 && (tab = allTabs[visibleToInvisible[i]]) != null) {
                    result[resultIndex++] = tab;
                    allTabs[visibleToInvisible[i]] = null;
                }
                ++i;
            }
        } else {
            i = selectedIndex - 1;
            while (i >= 0) {
                Tab tab;
                if (visibleToInvisible[i] != -1 && (tab = allTabs[visibleToInvisible[i]]) != null) {
                    result[resultIndex++] = tab;
                    allTabs[visibleToInvisible[i]] = null;
                }
                --i;
            }
            i = selectedIndex + 1;
            while (i < visibleToInvisible.length) {
                Tab tab;
                if (visibleToInvisible[i] != -1 && (tab = allTabs[visibleToInvisible[i]]) != null) {
                    result[resultIndex++] = tab;
                    allTabs[visibleToInvisible[i]] = null;
                }
                ++i;
            }
        }
        int leftMostVisible = -1;
        int rightMostVisible = -1;
        int i4 = 0;
        while (i4 < allTabs.length) {
            if (allTabs[i4] == null) {
                leftMostVisible = i4;
                break;
            }
            ++i4;
        }
        i4 = allTabs.length - 1;
        while (i4 >= 0) {
            if (allTabs[i4] == null) {
                rightMostVisible = i4;
                break;
            }
            --i4;
        }
        i4 = leftMostVisible + 1;
        while (i4 < rightMostVisible) {
            if (allTabs[i4] != null) {
                result[resultIndex++] = allTabs[i4];
                allTabs[i4] = null;
            }
            ++i4;
        }
        i4 = leftMostVisible - 1;
        while (i4 >= 0) {
            if (allTabs[i4] != null) {
                result[resultIndex++] = allTabs[i4];
                allTabs[i4] = null;
            }
            --i4;
        }
        i4 = Math.max(0, rightMostVisible);
        while (i4 < allTabs.length) {
            if (allTabs[i4] != null) {
                result[resultIndex++] = allTabs[i4];
                allTabs[i4] = null;
            }
            ++i4;
        }
        return result;
    }

    public int[] getOriginalTabLocations() {
        TabPane pane = this.getPane();
        if (pane == null) {
            throw new IllegalStateException("no TabPane available");
        }
        Tab[] tabs = this.getTabs();
        Dockable[] dockables = pane.getDockables();
        int[] locations = new int[tabs.length];
        int index = 0;
        int i = 0;
        while (i < tabs.length) {
            Dockable check = tabs[i].getDockable();
            locations[i] = -1;
            int j = 0;
            while (j < dockables.length) {
                if (dockables[index] == check) {
                    locations[i] = index;
                    break;
                }
                index = (index + 1) % dockables.length;
                ++j;
            }
            ++i;
        }
        return locations;
    }

    public Tab[] getDockableTabMap() {
        TabPane pane = this.getPane();
        if (pane == null) {
            throw new IllegalStateException("missing the TabPane");
        }
        Tab[] tabs = this.getTabs();
        Dockable[] dockables = pane.getDockables();
        Tab[] result = new Tab[dockables.length];
        int index = 0;
        int i = 0;
        while (i < tabs.length) {
            Dockable check = tabs[i].getDockable();
            int j = 0;
            while (j < dockables.length) {
                if (dockables[index] == check) {
                    result[index] = tabs[i];
                    break;
                }
                index = (index + 1) % dockables.length;
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void insertTab(Tab tab, int index) {
        if (tab == null) {
            throw new IllegalArgumentException("tab must not be null");
        }
        this.tabs.add(index, tab);
        tab.setOrientation(this.getOrientation());
    }

    public boolean removeTab(Tab tab) {
        return this.tabs.remove(tab);
    }

    public Tab removeTab(int index) {
        return this.tabs.remove(index);
    }

    public void removeAllTabs() {
        this.tabs.clear();
    }

    public abstract void doLayout();

    @Override
    public void setLayout(Size size) {
        if (size instanceof TabsSize) {
            Tab[] current;
            Tab[] tabs = ((TabsSize)size).getTabs();
            if (tabs.length == (current = this.getTabs()).length) {
                boolean same = true;
                int i = 0;
                while (i < tabs.length && same) {
                    same = tabs[i] == current[i];
                    ++i;
                }
                if (same) {
                    return;
                }
            }
            this.removeAllTabs();
            Tab[] tabArray = tabs;
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                Tab tab = tabArray[n2];
                tab = this.pane.putOnTab(tab.getDockable());
                this.insertTab(tab);
                ++n2;
            }
        } else {
            throw new IllegalArgumentException("not a size created by this block");
        }
    }

    public boolean isVisible() {
        return true;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
        this.doLayout();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    protected class TabsSize
    extends Size {
        private Tab[] tabs;

        public TabsSize(Size.Type type, int width, int height, Tab[] tabs) {
            super(type, width, height);
            this.tabs = tabs;
        }

        public TabsSize(Size.Type type, Dimension size, Tab[] tabs) {
            super(type, size);
            this.tabs = tabs;
        }

        public Tab[] getTabs() {
            return this.tabs;
        }

        public int getTabCount() {
            return this.tabs.length;
        }

        @Override
        public String toString() {
            return "[width=" + this.getWidth() + ", height=" + this.getHeight() + ", tabs=" + Arrays.toString(this.tabs) + "]";
        }
    }
}

