/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.station.support.DockStationListenerManager;
import java.util.HashMap;
import java.util.Map;

public class DockableVisibilityManager
extends DockStationAdapter {
    private DockStationListenerManager listeners;
    private Map<Dockable, Boolean> visibility = new HashMap<Dockable, Boolean>();

    public DockableVisibilityManager(DockStationListenerManager listeners) {
        if (listeners == null) {
            throw new IllegalArgumentException("Listeners must not be null");
        }
        this.listeners = listeners;
        listeners.addListener(this);
    }

    public void fire() {
        DockStation station = this.listeners.getStation();
        int i = 0;
        int n = station.getDockableCount();
        while (i < n) {
            Dockable dockable = station.getDockable(i);
            boolean visible = station.isVisible(dockable);
            if (!this.visibility.containsKey(dockable) || this.visibility.get(dockable) != visible) {
                this.listeners.fireDockableVisibilitySet(dockable, visible);
                this.visibility.put(dockable, visible);
            }
            ++i;
        }
    }

    @Override
    public void dockableAdded(DockStation station, Dockable dockable) {
        boolean visible = station.isVisible(dockable);
        this.listeners.fireDockableVisibilitySet(dockable, visible);
        this.visibility.put(dockable, visible);
    }

    @Override
    public void dockableRemoved(DockStation station, Dockable dockable) {
        Boolean old = this.visibility.remove(dockable);
        if (old != null && old.booleanValue()) {
            this.listeners.fireDockableVisibilitySet(dockable, false);
        }
    }
}

