/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;

public abstract class MenuPiece {
    private MenuPiece parent;
    private List<MenuPieceListener> listeners = new ArrayList<MenuPieceListener>();
    private boolean bound = false;

    public void addListener(MenuPieceListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MenuPieceListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireInsert(int index, Component ... items) {
        MenuPieceListener[] menuPieceListenerArray = this.listeners.toArray(new MenuPieceListener[this.listeners.size()]);
        int n = menuPieceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuPieceListener listener = menuPieceListenerArray[n2];
            listener.insert(this, index, items);
            ++n2;
        }
    }

    protected void fireRemove(int index, int length) {
        MenuPieceListener[] menuPieceListenerArray = this.listeners.toArray(new MenuPieceListener[this.listeners.size()]);
        int n = menuPieceListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuPieceListener listener = menuPieceListenerArray[n2];
            listener.remove(this, index, length);
            ++n2;
        }
    }

    public JMenu getMenu() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getMenu();
    }

    public MenuPiece getParent() {
        return this.parent;
    }

    public void setParent(MenuPiece parent) {
        this.parent = parent;
    }

    public void bind() {
        this.bound = true;
    }

    public void unbind() {
        this.bound = false;
    }

    public boolean isBound() {
        return this.bound;
    }

    public abstract int getItemCount();

    public abstract void fill(List<Component> var1);

    public Component[] items() {
        LinkedList<Component> items = new LinkedList<Component>();
        this.fill(items);
        return items.toArray(new Component[items.size()]);
    }
}

