/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.StandardDockAction;
import bibliothek.gui.dock.action.StandardDropDownItemAction;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.event.StandardDockActionListener;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;
import bibliothek.gui.dock.themes.basic.action.menu.AbstractMenuHandler;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JMenuItem;

public abstract class AbstractDropDownHandler<S extends StandardDropDownItemAction>
extends AbstractMenuHandler<JMenuItem, S>
implements DropDownViewItem {
    private DropDownView view;
    private Listener listener = new Listener();

    public AbstractDropDownHandler(S action, Dockable dockable, JMenuItem item) {
        super(action, dockable, item);
    }

    public DropDownView getView() {
        return this.view;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.item.addActionListener(listener);
    }

    @Override
    public boolean isSelectable() {
        return ((StandardDropDownItemAction)this.action).isDropDownSelectable(this.dockable);
    }

    @Override
    public boolean isTriggerable(boolean selected) {
        return ((StandardDropDownItemAction)this.action).isDropDownTriggerable(this.dockable, selected);
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.item.removeActionListener(listener);
    }

    @Override
    public void setView(DropDownView view) {
        this.view = view;
        if (view != null) {
            view.setText(((StandardDropDownItemAction)this.action).getText(this.dockable));
            view.setTooltip(((StandardDropDownItemAction)this.action).getTooltipText(this.dockable));
            view.setIcon(((StandardDropDownItemAction)this.action).getIcon(this.dockable));
            view.setDisabledIcon(((StandardDropDownItemAction)this.action).getDisabledIcon(this.dockable));
            view.setEnabled(((StandardDropDownItemAction)this.action).isEnabled(this.dockable));
        }
    }

    @Override
    public void bind() {
        super.bind();
        ((StandardDropDownItemAction)this.action).addDockActionListener(this.listener);
        if (this.view != null) {
            this.view.setText(((StandardDropDownItemAction)this.action).getText(this.dockable));
            this.view.setTooltip(((StandardDropDownItemAction)this.action).getTooltipText(this.dockable));
            this.view.setIcon(((StandardDropDownItemAction)this.action).getIcon(this.dockable));
            this.view.setDisabledIcon(((StandardDropDownItemAction)this.action).getDisabledIcon(this.dockable));
            this.view.setEnabled(((StandardDropDownItemAction)this.action).isEnabled(this.dockable));
        }
    }

    @Override
    public void unbind() {
        ((StandardDropDownItemAction)this.action).removeDockActionListener(this.listener);
        super.unbind();
    }

    private class Listener
    implements StandardDockActionListener {
        private Listener() {
        }

        @Override
        public void actionEnabledChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractDropDownHandler.this.view != null && dockables.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setEnabled(action.isEnabled(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionRepresentativeChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractDropDownHandler.this.view != null && dockables.contains(dockables)) {
                AbstractDropDownHandler.this.view.setDockableRepresentation(action.getDockableRepresentation(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractDropDownHandler.this.view != null && dockables.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setIcon(action.getIcon(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionDisabledIconChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractDropDownHandler.this.view != null && dockables.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setDisabledIcon(action.getDisabledIcon(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractDropDownHandler.this.view != null && dockables.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setText(action.getText(AbstractDropDownHandler.this.dockable));
            }
        }

        @Override
        public void actionTooltipTextChanged(StandardDockAction action, Set<Dockable> dockables) {
            if (AbstractDropDownHandler.this.view != null && dockables.contains(AbstractDropDownHandler.this.dockable)) {
                AbstractDropDownHandler.this.view.setTooltip(action.getTooltipText(AbstractDropDownHandler.this.dockable));
            }
        }
    }
}

