/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XException;

public class XContainer {
    private String value = "";

    public XContainer copy() {
        XContainer copy = new XContainer();
        copy.copy(this);
        return copy;
    }

    protected void copy(XContainer original) {
        this.value = original.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setByte(byte b) {
        this.value = String.valueOf(b);
    }

    public void setShort(short s) {
        this.value = String.valueOf(s);
    }

    public void setInt(int i) {
        this.value = String.valueOf(i);
    }

    public void setLong(long l) {
        this.value = String.valueOf(l);
    }

    public void setBoolean(boolean b) {
        this.value = String.valueOf(b);
    }

    public void setChar(char c) {
        this.value = String.valueOf(c);
    }

    public void setString(String s) {
        if (s == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.value = s;
    }

    public void setFloat(float f) {
        this.value = String.valueOf(f);
    }

    public void setDouble(double d) {
        this.value = String.valueOf(d);
    }

    public void setByteArray(byte[] bs) {
        StringBuilder builder = new StringBuilder(bs.length * 2);
        byte[] byArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(Integer.toHexString(b >> 4 & 0xF));
            builder.append(Integer.toHexString(b & 0xF));
            ++n2;
        }
        this.value = builder.toString();
    }

    public byte getByte() {
        try {
            return Byte.parseByte(this.value);
        }
        catch (NumberFormatException ex) {
            throw new XException(ex);
        }
    }

    public short getShort() {
        try {
            return Short.parseShort(this.value);
        }
        catch (NumberFormatException ex) {
            throw new XException(ex);
        }
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException ex) {
            throw new XException(ex);
        }
    }

    public long getLong() {
        try {
            return Long.parseLong(this.value);
        }
        catch (NumberFormatException ex) {
            throw new XException(ex);
        }
    }

    public float getFloat() {
        try {
            return Float.parseFloat(this.value);
        }
        catch (NumberFormatException ex) {
            throw new XException(ex);
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException ex) {
            throw new XException(ex);
        }
    }

    public char getChar() {
        if (this.value.length() != 1) {
            throw new XException("not a character: " + this.value);
        }
        return this.value.charAt(0);
    }

    public String getString() {
        return this.value;
    }

    public boolean getBoolean() {
        String value = this.value.trim().toLowerCase();
        if ("true".equals(value)) {
            return true;
        }
        if ("on".equals(value)) {
            return true;
        }
        if ("1".equals(value)) {
            return true;
        }
        if ("yes".equals(value)) {
            return true;
        }
        if ("false".equals(value)) {
            return false;
        }
        if ("off".equals(value)) {
            return false;
        }
        if ("0".equals(value)) {
            return false;
        }
        if ("no".equals(value)) {
            return false;
        }
        throw new XException("not a boolean: " + value);
    }

    public byte[] getByteArray() {
        if (this.value.length() % 2 != 0) {
            throw new XException("value is not a byte-array: " + this.value);
        }
        byte[] result = new byte[this.value.length() / 2];
        int i = 0;
        int n = this.value.length();
        while (i < n) {
            char c = this.value.charAt(i);
            int value = 0;
            switch (c) {
                case '0': {
                    value = 0;
                    break;
                }
                case '1': {
                    value = 1;
                    break;
                }
                case '2': {
                    value = 2;
                    break;
                }
                case '3': {
                    value = 3;
                    break;
                }
                case '4': {
                    value = 4;
                    break;
                }
                case '5': {
                    value = 5;
                    break;
                }
                case '6': {
                    value = 6;
                    break;
                }
                case '7': {
                    value = 7;
                    break;
                }
                case '8': {
                    value = 8;
                    break;
                }
                case '9': {
                    value = 9;
                    break;
                }
                case 'a': {
                    value = 10;
                    break;
                }
                case 'b': {
                    value = 11;
                    break;
                }
                case 'c': {
                    value = 12;
                    break;
                }
                case 'd': {
                    value = 13;
                    break;
                }
                case 'e': {
                    value = 14;
                    break;
                }
                case 'f': {
                    value = 15;
                    break;
                }
                default: {
                    throw new XException("value is not a byte-array: " + value);
                }
            }
            if (i % 2 == 0) {
                result[i / 2] = (byte)(value << 4);
            } else {
                int n2 = i / 2;
                result[n2] = (byte)(result[n2] | value);
            }
            ++i;
        }
        return result;
    }
}

