/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.util.xml;

import bibliothek.util.xml.XAttribute;
import bibliothek.util.xml.XElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XIO {
    public static void write(XElement element, Appendable out) throws IOException {
        out.append("<?xml version='1.0'?>\n");
        XIO.write(element, 0, out);
    }

    public static void writeUTF(XElement element, OutputStream out) throws IOException {
        XIO.write(element, out, "UTF-8");
    }

    public static void write(XElement element, OutputStream out, String encoding) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, encoding){

            @Override
            public void close() throws IOException {
            }
        };
        XIO.write(element, writer);
        writer.flush();
    }

    public static XElement readUTF(InputStream in) throws IOException {
        return XIO.read(in, "UTF-8");
    }

    public static XElement read(InputStream in, String encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, encoding){

            @Override
            public void close() throws IOException {
            }
        };
        return XIO.read(new InputSource(reader));
    }

    private static void write(XElement element, int tabs, Appendable out) throws IOException {
        int i = 0;
        while (i < tabs) {
            out.append("\t");
            ++i;
        }
        out.append("<");
        out.append(element.getName());
        XAttribute[] xAttributeArray = element.attributes();
        int n = xAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            XAttribute attribute = xAttributeArray[n2];
            out.append(" ");
            out.append(attribute.getName());
            out.append("=\"");
            XIO.encode(attribute.getString(), out);
            out.append("\"");
            ++n2;
        }
        String value = element.getValue();
        XElement[] children = element.children();
        if (value.length() == 0 && children.length == 0) {
            out.append("/>");
        } else {
            out.append(">");
            if (value.length() > 0) {
                if (children.length > 0) {
                    out.append("\n\t");
                    int i2 = 0;
                    while (i2 < tabs) {
                        out.append("\t");
                        ++i2;
                    }
                }
                XIO.encode(value, out);
            }
            if (children.length > 0) {
                out.append("\n");
                XElement[] xElementArray = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    XElement child = xElementArray[n4];
                    XIO.write(child, tabs + 1, out);
                    out.append("\n");
                    ++n4;
                }
                int i3 = 0;
                while (i3 < tabs) {
                    out.append("\t");
                    ++i3;
                }
            }
            out.append("</");
            out.append(element.getName());
            out.append(">");
        }
    }

    private static void encode(String value, Appendable out) throws IOException {
        int i = 0;
        int n = value.length();
        while (i < n) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    out.append("&lt;");
                    break;
                }
                case '>': {
                    out.append("&gt;");
                    break;
                }
                case '\'': {
                    out.append("&apos;");
                    break;
                }
                case '\"': {
                    out.append("&quot;");
                    break;
                }
                case '&': {
                    out.append("&amp;");
                    break;
                }
                default: {
                    out.append(c);
                }
            }
            ++i;
        }
    }

    public static XElement read(CharSequence text) throws IOException {
        InputSource in = new InputSource();
        in.setCharacterStream(new StringReader(text.toString()));
        return XIO.read(in);
    }

    public static XElement read(InputSource source) throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            Handler handler = new Handler();
            parser.parse(source, (DefaultHandler)handler);
            return handler.getElement();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static XElement read(Reader reader) throws IOException {
        return XIO.read(new InputSource(reader));
    }

    private static class Handler
    extends DefaultHandler {
        private XElement element;
        private LinkedList<XElement> stack = new LinkedList();

        private Handler() {
        }

        public XElement getElement() {
            return this.element;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            XElement element = new XElement(name);
            if (this.element == null) {
                this.element = element;
            } else {
                this.stack.getFirst().addElement(element);
            }
            this.stack.addFirst(element);
            int i = 0;
            int n = attributes.getLength();
            while (i < n) {
                XAttribute attr = new XAttribute(attributes.getQName(i));
                attr.setString(attributes.getValue(i));
                element.addAttribute(attr);
                ++i;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (length > 0) {
                String value = new String(ch, start, length);
                String old = this.stack.getFirst().getValue();
                if (old != null && old.length() > 0) {
                    value = String.valueOf(old) + value;
                }
                this.stack.getFirst().setValue(value);
            }
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            XElement element = this.stack.removeFirst();
            element.setValue(element.getString().trim());
        }
    }
}

