/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import rs.pezar.db.PZDBF;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.proizvodnja.PzExtensionLoader;
import rs.pezar.proizvodnja.gui.prijemnice.PzDialogIzradaPrijemnice;
import rs.pezar.proizvodnja.util.ProizvodnjaGradientUtil;
import rs.pezar.swing.PzComponentGroup;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;

public class PzDialogPrijemnica
extends PzDialog {
    private static final long serialVersionUID = 1L;
    private static final String RESTORAN = "restoran";
    protected static Kalkulacija selected;
    private JToolBar toolbar;
    private PzToolBarIcon icnBrisanje;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnDodavanje;
    private JScrollPane scrollPane;
    private PzTable table;
    private PzPanel tablePanel;
    private PzComponentGroup kIcnGroup;
    private PzPanel mainPanel;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private String parameter;

    public PzDialogPrijemnica(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        this.initGUI();
        this.initTable();
    }

    public PzDialogPrijemnica(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.initTable();
    }

    private void initTable() {
        this.table = new PzTable((List)PZDBF.getDokumenti((Pzuser)PzExtensionLoader.getLoggedUser(), (String)"Kalkulacija", (int)0, (int)0, (String)TipDokumentConfig.get().PRIJEMNICA_REPRO), Kalkulacija.class);
        this.table.setEnterAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PzDialogPrijemnica.this.table.getSelectedRow() == -1) {
                    return;
                }
                PzDialogPrijemnica.this.getSession().putParameter("update", (Object)true);
                PzDialogPrijemnica.this.getSession().putParameter("table", (Object)PzDialogPrijemnica.this.table);
                PzDialogPrijemnica.this.getSession().putParameter("parameter", (Object)PzDialogPrijemnica.this.parameter);
                PzDialogPrijemnica.this.showDialog(PzDialogIzradaPrijemnice.class);
                PzDialogPrijemnica.this.refresh();
            }
        });
        this.setTitle("Prijemnice repromaterijala u pripremi za korisnika " + PzExtensionLoader.getLoggedUser().getFullName());
        this.scrollPane.setViewportView((Component)this.table);
        if (this.table.getRowCount() >= 1) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.refresh();
    }

    private void initGUI() {
        try {
            this.mainPanel = new PzPanel();
            this.mainPanel.setLayout((LayoutManager)new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel);
            this.toolbar = new JToolBar();
            this.toolbar.setOpaque(false);
            this.toolbar.setFloatable(false);
            FlowLayout toolbarLayout = new FlowLayout();
            this.toolbar.setLayout(toolbarLayout);
            toolbarLayout.setAlignment(0);
            this.mainPanel.add((Component)this.toolbar, (Object)"North");
            this.kIcnGroup = new PzComponentGroup();
            this.icnIzmena = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnIzmena);
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Ulaz u|prijemnicu|(Enter)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_into.png")));
            this.icnIzmena.setActionCommand("update");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnDodavanje);
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Nova|prijemnica|(Insert)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_add.png")));
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setActionCommand("insert");
            this.icnDodavanje.setShortcut("insert");
            this.icnBrisanje = new PzToolBarIcon();
            this.kIcnGroup.add((Component)this.icnBrisanje);
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|prijemnice|(Delete)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/document_delete.png")));
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setActionCommand("delete");
            this.icnBrisanje.setShortcut("delete");
            this.tablePanel = new PzPanel();
            this.tablePanel.setOpaque(false);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.mainPanel.add((Component)this.tablePanel, (Object)"Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.tablePanel.setLayout((LayoutManager)mainPanelLayout);
            this.scrollPane = new JScrollPane();
            this.tablePanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.statusBar = new PzStatusBar();
            this.mainPanel.add((Component)this.statusBar, (Object)"South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setMinimumSize(new Dimension(800, 600));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogPrijemnica.this.brDok.setText(String.valueOf(PzDialogPrijemnica.this.table.getRowCount()));
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        try {
            String actionCommand = ((PzToolBarIcon)e.getSource()).getActionCommand();
            if (actionCommand.equals("delete")) {
                Kalkulacija k = (Kalkulacija)this.table.getSelectedEntity();
                if (k != null && k.getDokument().getNalogprijems() != null && k.getDokument().getNalogprijems().size() > 0 && ((Nalogprijem)k.getDokument().getNalogprijems().get(0)).getStatus() != 0) {
                    JOptionPane.showMessageDialog((Component)((Object)this), "Ne mo\u017eete obrisati prijemnicu jer je pakovanje robe otpo\u010delo!", "Obave\u0161tenje", 1);
                    return;
                }
                this.table.removeSelectedEntity(true, true);
                this.refresh();
                return;
            }
            boolean izmena = false;
            if (actionCommand.equals("update")) {
                if (this.table.getSelectedEntity() == null) {
                    return;
                }
                izmena = true;
            }
            this.getSession().putParameter("update", (Object)izmena);
            this.getSession().putParameter("table", (Object)this.table);
            this.getSession().putParameter("parameter", (Object)this.parameter);
            this.showDialog(PzDialogIzradaPrijemnice.class);
        }
        catch (Exception e1) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
        }
    }

    public static Kalkulacija getPrijemnicaUPripermi(PzDialog parent) {
        PzDialogPrijemnica dlg = new PzDialogPrijemnica(parent);
        if (!dlg.shouldBeShown()) {
            return null;
        }
        dlg.table.setEnterAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                selected = (Kalkulacija)PzDialogPrijemnica.this.table.getSelectedEntity();
                PzDialogPrijemnica.this.dispose();
            }
        });
        dlg.restoreSize();
        dlg.setModal(true);
        dlg.setVisible(true);
        Kalkulacija res = selected;
        selected = null;
        return res;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogPrijemnica(Boolean.FALSE);
    }

    public PzDialogPrijemnica(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.mainPanel.setPaintGradient(true);
        this.mainPanel.setGradient(ProizvodnjaGradientUtil.PROIZVODNJA_GRADIENT);
        this.getSession().putParameter("gradient", (Object)ProizvodnjaGradientUtil.PROIZVODNJA_GRADIENT);
        return true;
    }
}

