/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzDokumentManager;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityFilter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.proizvodnja.PzExtensionLoader;
import rs.pezar.proizvodnja.gui.sastavnice.OtvaranjeSklopa;
import rs.pezar.proizvodnja.gui.sastavnice.SastavSklopa;
import rs.pezar.proizvodnja.util.ProizvodnjaGradientUtil;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogSastavnicaDostavnica
extends PzDialog {
    private static final long serialVersionUID = 1974975635245933005L;
    private static final String SASTAVNICA = "sastavnica";
    private static final String DOSTAVNICA = "dostavnica";
    private PzPanel mainPanel;
    private JToolBar toolbar;
    private PzToolBarIcon icnDodavanje;
    private PzTable tabela;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisi;
    private JScrollPane scrollPane;
    private final String parameter;
    private Radnajedinica rjIzdavanja = null;
    private Radnajedinica rjPrijema = null;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private Interniracun dostavnica;
    private String tableID;
    private static Artikal sastavnica;

    public PzDialogSastavnicaDostavnica(JFrame frame, String parameter) {
        super(frame);
        this.parameter = parameter;
        if (parameter.equals(SASTAVNICA)) {
            this.tableID = "TABLE_SASTAVNICa";
            this.setId("SASTAVNICA");
        } else if (parameter.equals(DOSTAVNICA)) {
            this.tableID = "TABLE_DOSTAVNICA";
            this.setId("DOSTAVNICA");
        }
        this.initGUI();
    }

    public PzDialogSastavnicaDostavnica(PzDialog dialog, String parameter) {
        super(dialog);
        this.parameter = parameter;
        if (parameter.equals(SASTAVNICA)) {
            this.tableID = "TABLE_SASTAVNICa";
            this.setId("SASTAVNICA");
        } else if (parameter.equals(DOSTAVNICA)) {
            this.tableID = "TABLE_DOSTAVNICA";
            this.setId("DOSTAVNICA");
        }
        this.initGUI();
    }

    public PzDialogSastavnicaDostavnica(PzDialog dialog) {
        super(dialog);
        this.parameter = SASTAVNICA;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.mainPanel = new PzPanel();
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setPreferredSize(new Dimension(626, 378));
            mainPanelLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.rowHeights = new int[]{98, 49, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            this.mainPanel.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodavanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodavanje);
            this.icnDodavanje.setText("Dodavanje|(INSERT)");
            this.icnDodavanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_add.png")));
            this.icnDodavanje.setActionCommand("dodavanje");
            this.icnDodavanje.addActionListener((ActionListener)((Object)this));
            this.icnDodavanje.setShortcut("Insert");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            if (this.parameter.equals(SASTAVNICA)) {
                this.icnIzmena.setText("Ulaz u sklop|(F3)");
                this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_view.png")));
                this.icnIzmena.setActionCommand("ulaz");
            } else {
                this.icnIzmena.setText("Izmena|(F3)");
                this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_edit.png")));
                this.icnIzmena.setActionCommand("izmena");
            }
            this.icnIzmena.setShortcut("F3");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnBrisi = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisi);
            this.icnBrisi.setText("Brisanje|(DELETE)");
            this.icnBrisi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/product_delete.png")));
            this.icnBrisi.setActionCommand("brisanje");
            this.icnBrisi.setShortcut("Delete");
            this.icnBrisi.addActionListener((ActionListener)((Object)this));
            this.scrollPane = new JScrollPane();
            this.mainPanel.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 1, 4, 3, 0.0, 0.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            this.tabela = new PzTable();
            this.scrollPane.setViewportView((Component)this.tabela);
            this.tabela.setFilter(new PzEntityFilter(){

                public Object[] getValues(PzEntity entity) {
                    if (PzDialogSastavnicaDostavnica.this.parameter.equals(PzDialogSastavnicaDostavnica.SASTAVNICA)) {
                        Artikal dok = (Artikal)entity;
                        return new Object[]{dok.getSfrProizvod(), dok.getNaziv()};
                    }
                    Interniracun dok = (Interniracun)entity;
                    return new Object[]{dok.getrBroj(), dok.getDatum(), dok.getVredNaIzlazu(), dok.getVredNaUlazu(), dok.getIzlaznaRJ().getPunNaziv(), dok.getUlaznaRJ().getPunNaziv(), dok.getIdDok()};
                }

                public String[] getColumnNames() {
                    if (PzDialogSastavnicaDostavnica.this.parameter.equals(PzDialogSastavnicaDostavnica.SASTAVNICA)) {
                        return new String[]{"\u0160ifra", "Naziv"};
                    }
                    return new String[]{"Dokument", "Datum", "Magacin izlaza", "Magacin ulaza", "Izlazna RJ", "Ulazna RJ", "iddok"};
                }
            });
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("  Broj dokumenata");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(930, 755);
            this.setMinimumSize(new Dimension(930, 755));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            if (actionCommand.equals("dodavanje")) {
                this.getSession().putParameter("tabela", (Object)this.tabela);
                if (this.parameter.equals(SASTAVNICA)) {
                    this.showDialog(OtvaranjeSklopa.class);
                    this.refresh();
                    return;
                }
                this.rjIzdavanja = PzDialogRJ.getRJ((PzDialog)this, (String)"Magacin IZDAVANJA", (Character[])new Character[]{Character.valueOf('V'), Character.valueOf('S'), Character.valueOf('G')});
                if (this.rjIzdavanja == null) {
                    return;
                }
                if (this.rjIzdavanja.getgTip().equals("V")) {
                    this.rjPrijema = PzDialogRJ.getRJ((PzDialog)this, (String)"Magacin PRIJEMA", (Character[])new Character[]{Character.valueOf('S')});
                } else if (this.rjIzdavanja.getgTip().equals("S")) {
                    this.rjPrijema = PzDialogRJ.getRJ((PzDialog)this, (String)"Magacin PRIJEMA", (Character[])new Character[]{Character.valueOf('V'), Character.valueOf('S')});
                } else if (this.rjIzdavanja.getgTip().equals("G")) {
                    this.rjPrijema = PzDialogRJ.getRJ((PzDialog)this, (String)"Magacin PRIJEMA", (Character[])new Character[]{Character.valueOf('G')});
                }
                if (this.rjPrijema == null) {
                    return;
                }
                if (this.rjIzdavanja.getId().getOznRj().equals(this.rjPrijema.getId().getOznRj())) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Isti magacin ne moze da bude i ulaz i izlaz!");
                    return;
                }
                em.getTransaction().begin();
                this.dostavnica = new Interniracun();
                this.dostavnica.setStorno(0);
                this.dostavnica.setArhiviran((short)0);
                this.dostavnica.setTip("DOSTAVNICA");
                this.dostavnica.setIzlaznaRJ(this.rjIzdavanja);
                this.dostavnica.setUlaznaRJ(this.rjPrijema);
                this.dostavnica.setDatum(new Date(new java.util.Date().getTime()));
                this.dostavnica.setProknjizen((short)0);
                this.dostavnica.setProcRabata(0.0);
                this.dostavnica.setRjIzlaz(this.rjIzdavanja.getPunNaziv());
                this.dostavnica.setRjUlaz(this.rjPrijema.getPunNaziv());
                this.dostavnica.setUserPoc(PzExtensionLoader.getLoggedUser());
                this.dostavnica.setUserKraj(PzExtensionLoader.getLoggedUser());
                PzDokumentManager.getInstance().snimiDokument((PzDokument)this.dostavnica, true, null, em);
                em.getTransaction().commit();
                this.getSession().putParameter("parameter", (Object)DOSTAVNICA);
                this.getSession().putParameter(DOSTAVNICA, (Object)this.dostavnica);
                this.showDialog(SastavSklopa.class);
                this.initializeTable();
                return;
            }
            if (actionCommand.equals("ulaz")) {
                this.ulaz();
                return;
            }
            if (actionCommand.equals("izmena")) {
                if (this.tabela.getRowCount() == 0) return;
                this.getSession().putParameter("parameter", (Object)DOSTAVNICA);
                this.getSession().putParameter(DOSTAVNICA, (Object)this.tabela.getSelectedEntity());
                this.showDialog(SastavSklopa.class);
                this.initializeTable();
                return;
            }
            if (!actionCommand.equals("brisanje")) return;
            if (this.tabela.getRowCount() == 0) return;
            if (this.parameter.equals(SASTAVNICA)) {
                Artikal gar = (Artikal)this.tabela.getSelectedEntity();
                if (gar.getDeloviGarniture().size() != 0) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Sklop ima definisanu strukturu. BRISANJE NEMOGU\u010aE");
                    return;
                }
                int rez = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)false);
                if (rez != 0) return;
                em.getTransaction().begin();
                gar.setGarnitura((short)0);
                em.merge((Object)gar);
                em.getTransaction().commit();
                this.tabela.removeGUI(this.tabela.getSelectedRow());
                return;
            }
            Interniracun dostavnicaBrisanje = (Interniracun)this.tabela.getSelectedEntity();
            if (dostavnicaBrisanje == null) {
                return;
            }
            int rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot(null), (Object)"Da li ste sigurni?", (String)"Brisanje", null, (boolean)false);
            if (rez != 0) {
                return;
            }
            em.getTransaction().begin();
            Iterator iterator = dostavnicaBrisanje.getArtikalinterniracuns().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    em.remove(em.find(Interniracun.class, (Object)dostavnicaBrisanje.getIdDok()));
                    em.getTransaction().commit();
                    this.tabela.removeSelectedEntity(false, false);
                    this.refresh();
                    return;
                }
                Artikalinterniracun aintrac = (Artikalinterniracun)iterator.next();
                Stanje stanje = (Stanje)em.find(Stanje.class, (Object)new StanjePK(aintrac.getId().getSfrProizvod(), dostavnicaBrisanje.getIzlaznaRJ()));
                if (PzParameter.getParameterValue((String)"INT_NAL_FORM_ALOC").equals("true")) {
                    stanje.setAlocKolicina(stanje.getAlocKolicina() - aintrac.getKolicina());
                }
                em.merge((Object)stanje);
            }
        }
        catch (Exception e1) {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            return;
        }
        finally {
            em.close();
        }
    }

    public void ulaz() {
        if (this.tabela.getRowCount() != 0) {
            this.getSession().putParameter("parameter", (Object)SASTAVNICA);
            this.getSession().putParameter("artikal", (Object)this.tabela.getSelectedEntity());
            this.showDialog(SastavSklopa.class);
        }
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogSastavnicaDostavnica.this.brDok.setText(String.valueOf(PzDialogSastavnicaDostavnica.this.tabela.getRowCount()));
            }
        });
    }

    public boolean shouldBeShown() {
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                this.mainPanel.setPaintGradient(true);
                this.mainPanel.setGradient(ProizvodnjaGradientUtil.PROIZVODNJA_GRADIENT);
                this.getSession().putParameter("gradient", (Object)ProizvodnjaGradientUtil.PROIZVODNJA_GRADIENT);
                if (this.parameter.equals(SASTAVNICA)) {
                    this.setTitle("SASTAVNICE");
                } else {
                    this.setTitle("Dostavnice u pripremi");
                }
                this.initializeTable();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
                return false;
            }
        }
        finally {
            em.close();
        }
        return true;
    }

    public static Artikal getSastavnica(PzDialog parent, String parameter) {
        PzDialogSastavnicaDostavnica dlg = new PzDialogSastavnicaDostavnica(parent, parameter);
        dlg.setParentDialog(parent);
        parent.setChildDialog((PzDialog)dlg);
        dlg.setModal(true);
        dlg.setLocationRelativeTo((Component)parent);
        dlg.restoreSize();
        dlg.setVisible(true);
        Artikal tmp = sastavnica;
        sastavnica = null;
        parent.setChildDialog(null);
        return tmp;
    }

    public void initializeTable() {
        try {
            if (this.parameter.equals(SASTAVNICA)) {
                List data = PzEntityManager.getList((String)"SELECT a FROM Artikal a where a.garnitura=2 Order by a.sfrSort");
                this.tabela.setData(data, Artikal.class);
            } else {
                String upit = "Select d From Interniracun d where d.arhiviran = 0 and d.userPoc.pzusername='" + PzExtensionLoader.getLoggedUser().getPzusername() + "' and d.tip='" + "DOSTAVNICA" + "'";
                List data = PzEntityManager.getList((String)upit);
                this.tabela.setData(data, Interniracun.class);
                this.tabela.requestFocusInWindow();
            }
            this.refresh();
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }
}

