/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.korekcije;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzTaksaDokument;
import rs.pezar.db.entity.Artikalkalkulacija;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Komitent;
import rs.pezar.db.entity.Pzuser;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.db.entity.Taksakalkulacija;
import rs.pezar.db.entity.Trosak;
import rs.pezar.exceptions.PzInfoException;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.proizvodnja.gui.UzmiDokument;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogVratiUPripremu
extends PzDialog {
    private PzPanel mainPanel;
    private PzTextField tfNaziv;
    private JLabel lblPrijemnica;
    private PzButton btnPotvrdi;
    private PzTextField tfPrijemnica;
    private PzTextField tfKomitent;
    private JLabel lblKomitent;
    private Komitent entKomitent;
    private Kalkulacija prijemnica;

    public PzDialogVratiUPripremu(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout bLayout = new BorderLayout();
            this.setLayout(bLayout);
            this.setTitle("Vra\u0107anje prijemnica u pripremu");
            this.mainPanel = new PzPanel();
            this.mainPanel.setPaintGradient(true);
            GridBagLayout mainPanelLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.mainPanel, "Center");
            mainPanelLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.0};
            mainPanelLayout.rowHeights = new int[]{7, 7, 7, 7};
            mainPanelLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            mainPanelLayout.columnWidths = new int[]{92, 122, 7, 7};
            this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
            this.lblKomitent = new JLabel();
            this.mainPanel.add((Component)this.lblKomitent, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKomitent.setName("lblKomitent");
            this.tfKomitent = new PzTextField();
            this.mainPanel.add((Component)this.tfKomitent, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 3, 0), 0, 0));
            this.tfKomitent.setVerifyInput(true);
            this.tfKomitent.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
            this.tfNaziv = new PzTextField();
            this.mainPanel.add((Component)this.tfNaziv, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 3, 20), 0, 0));
            this.tfNaziv.setEnabled(false);
            this.tfNaziv.setFocusable(false);
            this.lblPrijemnica = new JLabel();
            this.mainPanel.add((Component)this.lblPrijemnica, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPrijemnica.setName("lblPrijemnica");
            this.tfPrijemnica = new PzTextField();
            this.mainPanel.add((Component)this.tfPrijemnica, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfPrijemnica.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent arg0) {
                    if (PzDialogVratiUPripremu.this.tfPrijemnica.getVal().equals("")) {
                        PzDialogVratiUPripremu.this.getSession().putParameter("komitent", (Object)PzDialogVratiUPripremu.this.entKomitent);
                        PzDialogVratiUPripremu.this.showDialog(UzmiDokument.class);
                        if (PzDialogVratiUPripremu.this.prijemnica == null) {
                            JOptionPane.showMessageDialog(PzDialogVratiUPripremu.this.getParent(), "Nije odabrana nijedna prijemnica izabranog komitenta!", "Informacija ", 1);
                            PzDialogVratiUPripremu.this.tfPrijemnica.requestFocusInWindow();
                            return false;
                        }
                    } else {
                        EntityManager em = PzEntityManager.getEm();
                        Query q = null;
                        q = em.createQuery("SELECT k FROM Kalkulacija k where k.arhiviran=1 and k.dokument.proknjizen=0 and k.komitent.sfrKomitent=:sifra and k.storno=0 AND k.tip='" + TipDokumentConfig.get().PRIJEMNICA_REPRO + "' and k.oznDokumenta=:ozn");
                        q.setParameter("sifra", (Object)PzDialogVratiUPripremu.this.entKomitent.getSfrKomitent());
                        q.setParameter("ozn", (Object)PzDialogVratiUPripremu.this.tfPrijemnica.getVal());
                        Vector data = (Vector)q.getResultList();
                        if (data.size() == 1) {
                            PzDialogVratiUPripremu.this.prijemnica = (Kalkulacija)q.getSingleResult();
                        } else {
                            JOptionPane.showMessageDialog(PzDialogVratiUPripremu.this.getParent(), "Nijedna prijemnica izabranog komitenta sa unetom oznakom ne zadovaljava neophodne uslove pretrage!", "Informacija ", 1);
                            PzDialogVratiUPripremu.this.tfPrijemnica.setText("");
                            PzDialogVratiUPripremu.this.prijemnica = null;
                            return false;
                        }
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.mainPanel.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 0, 10, 0), 0, 0));
            this.btnPotvrdi.setName("btnPotvrdi");
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.pack();
            this.setResizable(false);
            this.setRestorable(false);
            this.setSize(550, 161);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    if (this.prijemnica.getDokument().getProknjizen() == 1) {
                        throw new PzInfoException("Ne mo\u017eete vratiti dokument u pripremu jer je proknji\u017een u finansijskom knjigovodstvu.");
                    }
                    em.getTransaction().begin();
                    Vector<String> nemaDovoljno = new Vector<String>();
                    for (Artikalkalkulacija artikal : this.prijemnica.getArtikalkalkulacijas()) {
                        StanjePK spk = new StanjePK(artikal.getId().getSfrProizvod(), this.prijemnica.getRadnajedinica().getId().getOznOgranak(), this.prijemnica.getRadnajedinica().getId().getOznRj());
                        Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
                        if (!(s.getRaspolozivaKolicina() < artikal.getKolicina()) || !this.prijemnica.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN")) continue;
                        nemaDovoljno.add(" [ " + artikal.getId().getSfrProizvod() + " ] " + artikal.getNaziv());
                    }
                    if (nemaDovoljno.size() > 0) {
                        String poruka = "Slede\u0107i artikli nemaju dovoljno raspolo\u017eive koli\u010dine:\n";
                        for (String str : nemaDovoljno) {
                            poruka = String.valueOf(poruka) + str + "\n";
                        }
                        int izbor = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)(poruka = String.valueOf(poruka) + "Ukoliko vratite prijemnicu u pripremu, navedeni artikli \u0107e oti\u0107i u minus sa koli\u010dinom.\nDa li ste sigurni da to \u017eelite?"), (String)"Nedovoljna koli\u010dina", null, (boolean)true);
                        if (izbor != 0) {
                            throw new PzInfoException("Operacija vra\u0107anja dokumenta u pripremu je obustavljena.");
                        }
                    }
                    this.prijemnica.setArhiviran((short)0);
                    this.prijemnica.getDokument().setArhiviran((short)0);
                    if (this.prijemnica.getTrosaks() != null && this.prijemnica.getTrosaks().size() > 0) {
                        for (Trosak tr : this.prijemnica.getTrosaks()) {
                            tr.setArhiviran((short)0);
                            tr.getDokument().setArhiviran((short)0);
                        }
                    }
                    Pzuser user = (Pzuser)em.find(Pzuser.class, (Object)PzApplication.getApplication().getSession().getLoggedUser().getPzusername());
                    this.prijemnica.createLog(5, null, user, em);
                    this.prijemnica.setUserKraj(user);
                    for (Artikalkalkulacija artikal : this.prijemnica.getArtikalkalkulacijas()) {
                        StanjePK spk = new StanjePK(artikal.getId().getSfrProizvod(), this.prijemnica.getRadnajedinica().getId().getOznOgranak(), this.prijemnica.getRadnajedinica().getId().getOznRj());
                        Stanje s = (Stanje)em.find(Stanje.class, (Object)spk);
                        if (s.getRaspolozivaKolicina() >= artikal.getKolicina() || this.prijemnica.getRadnajedinica().getMinusKolicine().equals("DOZVOLJEN")) {
                            s.setKolicina(s.getKolicina() - artikal.getKolicina());
                            s.setKumUlaza(s.getKumUlaza() - artikal.getKolicina());
                            continue;
                        }
                        throw new PzInfoException("Artikal [ " + artikal.getId().getSfrProizvod() + " ] " + artikal.getNaziv() + " nema dovoljno raspolo\u017eive koli\u010dine, a odlazak u minus nije dozoljen. Operacija obustavljena!!!");
                    }
                    if (this.prijemnica.getTaksakalkulacijas() != null) {
                        Iterator iterator = this.prijemnica.getTaksakalkulacijas().iterator();
                        while (iterator.hasNext()) {
                            Taksakalkulacija tk = (Taksakalkulacija)iterator.next();
                            if (!tk.getTip().equals(PzTaksaDokument.TIP_UKALKULISANI) && !tk.getTip().equals(PzTaksaDokument.TIP_IZRACUNATI)) continue;
                            iterator.remove();
                        }
                    }
                    em.merge((Object)this.prijemnica);
                    em.getTransaction().commit();
                    JOptionPane.showMessageDialog(SwingUtilities.getRoot((Component)((Object)this)), "Prijemnica broj " + this.prijemnica.getrBroj() + " je vra\u0107ena u pripremu.", "Informacija", 1);
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.entKomitent = (Komitent)entity;
            this.tfKomitent.setVal((Object)this.entKomitent.getSfrKomitent());
            this.tfNaziv.setVal((Object)this.entKomitent.getNaziv());
            this.tfPrijemnica.requestFocus();
        }
    }

    public void refreshField(Kalkulacija k) {
        this.prijemnica = k;
        if (this.prijemnica == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna prijemnica izabranog komitenta!", "Informacija ", 1);
            this.tfPrijemnica.requestFocusInWindow();
            return;
        }
        this.tfPrijemnica.setVal((Object)k.getOznDokumenta());
    }
}

