/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.prijemnice;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.jms.Destination;
import javax.persistence.EntityManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.entity.Kalkulacija;
import rs.pezar.db.entity.Nalogprijem;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;
import rs.pezar.util.PzMagacinUtil;

public class PosaljiNalogZaPrijem
extends PzDialog {
    private static final long serialVersionUID = -9018300363136515711L;
    private JScrollPane scp;
    private JLabel lblNapomena;
    private JTextArea txtArea;
    private JButton btnOK;
    private PzPanelHeader header;
    private PzPanel pnlContent;

    public PosaljiNalogZaPrijem(PzDialog parent) {
        super(parent);
        this.initGUI();
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlContent.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlContent.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlContent.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    private void initGUI() {
        try {
            this.setTitle("Slanje naloga za prijem robe");
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlContent, "Center");
            pnlContentLayout.rowWeights = new double[]{0.0, 0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 20, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/briefcase2_document.png")));
            this.header.setTitle("Nalog za prijem");
            this.header.setOpaque(false);
            this.header.setText("Slanje naloga magacinu da primi i spakuje robu");
            this.pnlContent.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.scp = new JScrollPane();
            this.pnlContent.add((Component)this.scp, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.txtArea = new JTextArea();
            this.scp.setViewportView(this.txtArea);
            this.btnOK = new JButton();
            this.btnOK.addActionListener((ActionListener)((Object)this));
            this.btnOK.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnOK.setText("Po\u0161alji nalog");
            this.pnlContent.add((Component)this.btnOK, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.lblNapomena = new JLabel("Napomena:");
            this.pnlContent.add((Component)this.lblNapomena, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(500, 350);
            this.setResizable(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        Kalkulacija k = (Kalkulacija)this.getSession().getParameter("kalkulacija_nalog");
        this.getSession().putParameter("kalkulacija_nalog", null);
        EntityManager em = PzEntityManagerFactory.getInstance().createEm();
        try {
            try {
                em.getTransaction().begin();
                Nalogprijem n = PzMagacinUtil.createNalogPrijem((PzDokument)k, (String)this.txtArea.getText(), (EntityManager)em);
                em.getTransaction().commit();
                MsgProtocol msgProtocol = MsgProtocol.getInstance();
                if (msgProtocol == null) {
                    PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Do\u0161lo je do gre\u0161ke pri poku\u0161aju signaliziranja magacinu o poslatom nalogu, ali je nalog uspe\u0161no dostavljen!\\nMagacioner \u0107e morati ru\u010dno da osve\u017ei listu da bi ga video");
                } else if (n != null) {
                    msgProtocol.sendActionMessageToDestination((Destination)msgProtocol.createDestinationFromTopicName("topic.users"), "ID:printmag-2;NALOG:" + n.getOznNalogPrijem());
                }
                this.dispose();
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }
}

