/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.proizvodnja.gui.trebovanje;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import rs.pezar.core.format.BDConverter;
import rs.pezar.core.format.PzFormatFactory;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalgarnitura;
import rs.pezar.db.entity.Artikalopstidokument;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.RadnajedinicaPK;
import rs.pezar.db.entity.Stanje;
import rs.pezar.db.entity.StanjePK;
import rs.pezar.proizvodnja.gui.PzDialogSastavnicaDostavnica;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogInsert;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzGradient;
import rs.pezar.swing.util.PzSwingUtility;

public class DodavanjeStavkeSastavnica
extends PzDialogInsert {
    private static final long serialVersionUID = -3740379595715085827L;
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzDoubleField tfKolicina;
    private PzFieldIndikator indKoeficijent;
    private JLabel lblNaziv;
    private PzFieldIndikator indSifra;
    private JLabel lblKolicina;
    private PzTextField tfNaziv;
    private PzTextField tfSifra;
    private JLabel lblSifra;
    private PzButton btnPotvrdi;
    private Artikal artikal;
    private Artikal art;
    private Artikalopstidokument arttreb;
    private Artikalopstidokument arttrebStari;
    private BigDecimal prethodniIznosBezPDV;
    private double prethodniIznosKolicine;

    public DodavanjeStavkeSastavnica(PzDialog dialog) {
        super(dialog);
        boolean izmena = (Boolean)this.getSession().getParameter("update");
        if (izmena) {
            this.arttreb = (Artikalopstidokument)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            this.arttrebStari = (Artikalopstidokument)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
            this.tfKolicina.requestFocus();
        }
        this.paintPanel();
    }

    private void paintPanel() {
        this.pnlGlavni.setPaintGradient(true);
        if (this.getSession().getParameter("gradient") != null) {
            this.pnlGlavni.setGradient((PzGradient)this.getSession().getParameter("gradient"));
        } else {
            this.pnlGlavni.setGradient(PzGradient.DEFAULT_GRADIENT);
        }
    }

    protected void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Izbor gotovog proizvoda");
            this.pnlGlavni = new PzPanel();
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{44, 67, 38, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 5, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{29, 25, 27, 25, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{17, 126, 134, 170, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.pnlFields.setOpaque(false);
            this.lblSifra = new JLabel();
            this.pnlFields.add((Component)this.lblSifra, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblSifra.setText("\u0160ifra gotovog proizvoda");
            this.tfSifra = new PzTextField();
            this.pnlFields.add((Component)this.tfSifra, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfSifra.setFKField(Artikal.class, PzDialogSastavnicaDostavnica.class, true, null);
            this.tfSifra.setCustomInputVerifier(new InputVerifier(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public boolean verify(JComponent input) {
                    if (DodavanjeStavkeSastavnica.this.artikal.getGarnitura() != 2) {
                        PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal nije sastavnica!");
                        return false;
                    }
                    if (DodavanjeStavkeSastavnica.this.artikal.getDeloviGarniture() == null || DodavanjeStavkeSastavnica.this.artikal.getDeloviGarniture().size() == 0) {
                        PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)"Artikal nema komponente!");
                        return false;
                    }
                    try {
                        for (Artikalgarnitura artgar : DodavanjeStavkeSastavnica.this.artikal.getDeloviGarniture()) {
                            String sfrrj = artgar.getOznakaRj().substring(0, artgar.getOznakaRj().indexOf("("));
                            Radnajedinica radjed = (Radnajedinica)PzEntityManager.find(Radnajedinica.class, (Object)new RadnajedinicaPK("1", sfrrj));
                            boolean prnc = radjed.getNacinVodjenja().equals("PRNC");
                            Stanje s = (Stanje)PzEntityManager.find(Stanje.class, (Object)new StanjePK(artgar.getId().getDeo(), radjed));
                            if (s == null) {
                                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)("Komponenta " + artgar.getId().getDeo() + " nema promet u " + radjed.getPunNaziv()));
                                return false;
                            }
                            if (prnc) {
                                if (s.getProsNabCena().doubleValue() != 0.0) continue;
                                PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)("Nedefinisana prose\u010dna nabavna cena na komponenti " + artgar.getId().getDeo()));
                                return false;
                            }
                            if (s.getArtikal().getCenaPlanska() != 0.0) continue;
                            PzSwingUtility.showErrorMessage((Component)SwingUtilities.getRoot(input), (String)("Nedefinisana planska cena na komponenti " + artgar.getId().getDeo()));
                            return false;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                    DodavanjeStavkeSastavnica.this.tfKolicina.requestFocus();
                    return true;
                }
            });
            this.tfNaziv = new PzTextField();
            this.pnlFields.add((Component)this.tfNaziv, (Object)new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(1, 0, 2, 0), 0, 0));
            this.tfNaziv.setEditable(false);
            this.tfNaziv.setFocusable(false);
            this.lblKolicina = new JLabel();
            this.pnlFields.add((Component)this.lblKolicina, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblKolicina.setText("Koli\u010dina");
            this.tfKolicina = new PzDoubleField();
            this.pnlFields.add((Component)this.tfKolicina, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 0), 0, 0));
            this.tfKolicina.setDecimalFormat(PzFormatFactory.getKolicinaFormat());
            this.tfKolicina.setCustomInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (DodavanjeStavkeSastavnica.this.tfKolicina.getVal() <= 0.0) {
                        JOptionPane.showMessageDialog(null, "Koli\u010dina ne mo\u017ee biti 0!", "Informacija", 1);
                        return false;
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/proizvodnja/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.lblNaziv = new JLabel();
            this.pnlFields.add((Component)this.lblNaziv, (Object)new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.lblNaziv.setText("Naziv gotovog proizvoda");
            this.indSifra = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifra, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 2, 0), 0, 0));
            this.indKoeficijent = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indKoeficijent, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.tfSifra.setStateIndikator(this.indSifra);
            this.tfKolicina.setStateIndikator(this.indKoeficijent);
            this.pack();
            this.setSize(536, 242);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public void actionPerformed(ActionEvent e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setEntity(PzEntity entity, Component component) {
        try {
            if (entity == null) {
                return;
            }
            this.artikal = (Artikal)entity;
            this.tfSifra.setVal((Object)this.artikal.getSfrProizvod());
            this.tfNaziv.setVal((Object)this.artikal.getNaziv());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public static Object getGUIBuilderInstance() {
        return new DodavanjeStavkeSastavnica(Boolean.FALSE);
    }

    public DodavanjeStavkeSastavnica(Boolean initGUI) {
    }

    protected void setHeaderOnUpdate() {
    }

    protected void setHeaderOnInsert() {
    }

    protected void onUpdate() {
        this.btnPotvrdi.setActionCommand("update");
        Artikalopstidokument arttr = (Artikalopstidokument)((PzTable)this.getSession().getParameter("tabela")).getSelectedEntity();
        this.tfSifra.setVal((Object)arttr.getId().getSfrProizvod());
        this.tfSifra.setEnabled(false);
        this.tfKolicina.setVal((Object)arttr.getKolicina());
        this.tfKolicina.setEnabled(true);
        this.tfNaziv.setVal((Object)arttr.getNaziv());
        this.prethodniIznosBezPDV = BDConverter.getIznos((double)(arttr.getKolicina() * arttr.getCenaBezPoreza()));
        this.prethodniIznosKolicine = arttr.getKolicina();
        this.pnlFields.updateAllFieldsState();
    }

    protected void onInsert() {
        this.btnPotvrdi.setActionCommand("insert");
    }
}

