/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.persistence.EntityManager;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Lokacija;
import rs.pezar.db.entity.LokacijaPK;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanjeartikal;
import rs.pezar.sifarnici.gui.PzArtikliBrowser;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.event.PzEntityChecker;
import rs.pezar.swing.event.PzStanjeartikalChecker;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzField;
import rs.pezar.swing.fields.PzFieldIndikator;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogAzuriranjeLokacija
extends PzDialog {
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private JLabel lblSifraArtikla;
    private JLabel lblRed;
    private PzFieldIndikator indSifraArtikla;
    private PzTextField tfPaleta;
    private JLabel lblPaleta;
    private PzTextField tfNivo;
    private JLabel lblNivo;
    private PzTextField tfRed;
    private PzTextField tfNazivAtrikla;
    private PzTextField tfSifraArtikla;
    private PzButton btnPotvrdi;
    private Radnajedinica rj;

    public PzDialogAzuriranjeLokacija(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{37, 39, 70, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.1, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{7, 25, 10, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{30, 62, 60, 69, 60, 60, 60, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.lblSifraArtikla = new JLabel();
            this.pnlFields.add((Component)this.lblSifraArtikla, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.lblSifraArtikla.setName("lblSifraArtikla");
            this.tfSifraArtikla = new PzTextField();
            this.pnlFields.add((Component)this.tfSifraArtikla, (Object)new GridBagConstraints(2, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 25), 0, 0));
            this.tfSifraArtikla.setFKField(Stanjeartikal.class, PzArtikliBrowser.class, true, null);
            this.tfSifraArtikla.setSize(60, 24);
            this.tfNazivAtrikla = new PzTextField();
            this.pnlFields.add((Component)this.tfNazivAtrikla, (Object)new GridBagConstraints(4, 1, 4, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 2, 10), 0, 0));
            this.tfNazivAtrikla.setFocusable(false);
            this.tfNazivAtrikla.setEditable(false);
            this.tfNazivAtrikla.setBackground(new Color(255, 255, 255));
            this.lblRed = new JLabel();
            this.pnlFields.add((Component)this.lblRed, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 5, 0, 0), 0, 0));
            this.lblRed.setName("lblRed");
            this.tfRed = new PzTextField();
            this.tfRed.setToUpperCase(true);
            this.pnlFields.add((Component)this.tfRed, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfRed.setMaxLength(2);
            this.lblNivo = new JLabel();
            this.pnlFields.add((Component)this.lblNivo, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblNivo.setName("lblNivo");
            this.tfNivo = new PzTextField();
            this.tfNivo.setToUpperCase(true);
            this.pnlFields.add((Component)this.tfNivo, (Object)new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNivo.setMaxLength(2);
            this.lblPaleta = new JLabel();
            this.pnlFields.add((Component)this.lblPaleta, (Object)new GridBagConstraints(5, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 10, 0, 0), 0, 0));
            this.lblPaleta.setName("lblPaleta");
            this.tfPaleta = new PzTextField();
            this.tfPaleta.setToUpperCase(true);
            this.pnlFields.add((Component)this.tfPaleta, (Object)new GridBagConstraints(6, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfPaleta.setMaxLength(2);
            this.indSifraArtikla = new PzFieldIndikator();
            this.pnlFields.add((Component)this.indSifraArtikla, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(115, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.tfSifraArtikla.setStateIndikator(this.indSifraArtikla);
            this.pack();
            this.setSize(573, 245);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        EntityManager em = PzEntityManager.getEm();
        try {
            try {
                if (actionCommand.equals("potvrdi")) {
                    em.getTransaction().begin();
                    String red = this.tfRed.getVal();
                    String nivo = this.tfNivo.getVal();
                    String paleta = this.tfPaleta.getVal();
                    Lokacija l = (Lokacija)em.find(Lokacija.class, (Object)new LokacijaPK(this.tfSifraArtikla.getVal(), this.rj));
                    if (red.length() == 1) {
                        red = "0" + red;
                    }
                    if (nivo.length() == 1) {
                        nivo = "0" + nivo;
                    }
                    if (paleta.length() == 1) {
                        paleta = "0" + paleta;
                    }
                    if (l == null) {
                        l = new Lokacija((Artikal)em.find(Artikal.class, (Object)this.tfSifraArtikla.getVal()), this.rj);
                        l.setStalaza(red);
                        l.setNivo(nivo);
                        l.setPaleta(paleta);
                        em.persist((Object)l);
                    } else {
                        l.setStalaza(red);
                        l.setNivo(nivo);
                        l.setPaleta(paleta);
                        em.merge((Object)l);
                    }
                    em.getTransaction().commit();
                    this.cleanFields();
                }
            }
            catch (Exception e1) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                em.close();
            }
        }
        finally {
            em.close();
        }
    }

    private void cleanFields() {
        this.tfSifraArtikla.setText("");
        this.tfNazivAtrikla.setText("");
        this.tfNivo.setText("");
        this.tfPaleta.setText("");
        this.tfRed.setText("");
        this.tfSifraArtikla.requestFocus();
        this.indSifraArtikla.setState(0);
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity == null) {
            return;
        }
        Stanjeartikal stanje = (Stanjeartikal)entity;
        this.tfSifraArtikla.setVal((Object)stanje.getId().getSfrProizvod());
        this.tfNazivAtrikla.setVal((Object)stanje.getNaziv());
        this.tfRed.setVal((Object)stanje.getStalaza());
        this.tfNivo.setVal((Object)stanje.getNivo());
        this.tfPaleta.setVal((Object)stanje.getPaleta());
    }

    public boolean shouldBeShown() {
        boolean res = false;
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        if (this.rj != null) {
            this.tfSifraArtikla.setParamToPass((Object)this.rj);
            this.tfSifraArtikla.setEntityChecker((PzEntityChecker)new PzStanjeartikalChecker((PzField)this.tfSifraArtikla, this.rj));
            this.setTitle("Izmena lokacija artikala u radnoj jedinici: " + this.rj.getId().getOznRj() + "-" + this.rj.getNaziv());
            res = true;
        }
        return res;
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogAzuriranjeLokacija(Boolean.FALSE);
    }

    public PzDialogAzuriranjeLokacija(Boolean initGUI) {
    }
}

