/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.queries.FetchGroup;
import org.jdesktop.application.Application;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Firma;
import rs.pezar.db.entity.Nalepnica;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.db.entity.Stanje;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.magacin.gui.stampanjeNalepnica.DodavanjeSifre;
import rs.pezar.magacin.gui.stampanjeNalepnica.DopunaPremaKalkulaciji;
import rs.pezar.magacin.gui.stampanjeNalepnica.DopunaPremaLokaciji;
import rs.pezar.magacin.gui.stampanjeNalepnica.DopunaPremaNivelaciji;
import rs.pezar.magacin.gui.stampanjeNalepnica.Izmena;
import rs.pezar.magacin.gui.stampanjeNalepnica.Selektiranje;
import rs.pezar.magacin.gui.util.PzMagacinUtil;
import rs.pezar.reports.PzReportManager;
import rs.pezar.reports.engine.standard.PzBeanDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceAdapter;
import rs.pezar.reports.engine.standard.PzDataSourceExtended;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzDialogChoice;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzStatusBar;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzToolBarIcon;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzCalculatedField;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogStampanjeNalepnica
extends PzDialog {
    private JToolBar toolbar;
    private JLabel lblBrojNalepnica;
    private PzPanel pnlPolja;
    private PzCalculatedField tfBrojNalepnica;
    private PzTable tblTabela;
    private JScrollPane scrollPane;
    private PzPanel pnlGlavni;
    private PzToolBarIcon icnDodajSifru;
    private PzToolBarIcon icnIzmena;
    private PzToolBarIcon icnBrisanje;
    private JSeparator jSeparator1;
    private PzToolBarIcon icnSelektiranje;
    private JSeparator jSeparator2;
    private PzToolBarIcon icnPremaKalkulaciji;
    private PzToolBarIcon icnSifarniku;
    private PzToolBarIcon icnPremaNivelaciji;
    private PzToolBarIcon icnPremaLokaciji;
    private JSeparator jSeparator3;
    private PzToolBarIcon icnBrisiSve;
    private PzToolBarIcon icnVeridix;
    private PzToolBarIcon icnStampa;
    private Radnajedinica rj2 = null;
    private Radnajedinica rj1 = null;
    private int sifra;
    private PzToolBarIcon icnPremaInternom;
    private PzStatusBar statusBar;
    private final JLabel jlStatusBar = new JLabel();
    private final JLabel brDok = new JLabel();
    private Radnajedinica rj;

    public PzDialogStampanjeNalepnica(JFrame frame) {
        super(frame);
        this.initGUI();
        this.tblTabela.calculateFields();
        this.refresh();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("Priprema podataka za nalepnice");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{113, 53, -6, 7, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{142, 120, 206, 152, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBackground(new Color(255, 255, 255));
            this.pnlGlavni.add((Component)this.scrollPane, (Object)new GridBagConstraints(0, 3, 5, 2, 0.0, 0.0, 10, 1, new Insets(0, 7, 7, 7), 0, 0));
            this.tblTabela = new PzTable(PzEntityManager.select((String)("select n from Nalepnica n where n.pzuser.pzusername='" + PzApplication.getApplication().getSession().getLoggedUser().getPzusername() + "'")));
            this.scrollPane.setViewportView((Component)this.tblTabela);
            this.toolbar = new JToolBar();
            this.pnlGlavni.add((Component)this.toolbar, (Object)new GridBagConstraints(0, 0, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            FlowLayout toolbarLayout = new FlowLayout();
            toolbarLayout.setAlignment(0);
            toolbarLayout.setHgap(10);
            this.toolbar.setLayout(toolbarLayout);
            this.toolbar.setOpaque(false);
            this.icnDodajSifru = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnDodajSifru);
            this.icnDodajSifru.setText("Dodaj \u0161ifru|(INS)");
            this.icnDodajSifru.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_add.png")));
            this.icnDodajSifru.setActionCommand("dodaj");
            this.icnDodajSifru.addActionListener((ActionListener)((Object)this));
            this.icnDodajSifru.setShortcut("INSERT");
            this.icnIzmena = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnIzmena);
            this.icnIzmena.setText("Izmena|(F3)");
            this.icnIzmena.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_edit.png")));
            this.icnIzmena.setActionCommand("izmena");
            this.icnIzmena.addActionListener((ActionListener)((Object)this));
            this.icnIzmena.setShortcut("F3");
            this.icnBrisanje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisanje);
            this.icnBrisanje.setText("Brisanje|(DEL)");
            this.icnBrisanje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_delete.png")));
            this.icnBrisanje.setActionCommand("brisanje");
            this.icnBrisanje.addActionListener((ActionListener)((Object)this));
            this.icnBrisanje.setShortcut("Delete");
            this.jSeparator1 = new JSeparator();
            this.toolbar.add(this.jSeparator1);
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setPreferredSize(new Dimension(8, 75));
            this.icnSelektiranje = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSelektiranje);
            this.icnSelektiranje.setText("Selektiranje|(F2)");
            this.icnSelektiranje.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_new.png")));
            this.icnSelektiranje.setActionCommand("selektiranje");
            this.icnSelektiranje.addActionListener((ActionListener)((Object)this));
            this.icnSelektiranje.setShortcut("F2");
            this.jSeparator2 = new JSeparator();
            this.toolbar.add(this.jSeparator2);
            this.jSeparator2.setOrientation(1);
            this.jSeparator2.setPreferredSize(new Dimension(8, 75));
            this.icnSifarniku = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnSifarniku);
            this.icnSifarniku.setText("Prema sifarniku|(F4)");
            this.icnSifarniku.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_signpost.png")));
            this.icnSifarniku.setActionCommand("sifarnik");
            this.icnSifarniku.addActionListener((ActionListener)((Object)this));
            this.icnSifarniku.setShortcut("F4");
            this.icnPremaKalkulaciji = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPremaKalkulaciji);
            this.icnPremaKalkulaciji.setText("Prema kalkulaciji|(F5)");
            this.icnPremaKalkulaciji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_signpost.png")));
            this.icnPremaKalkulaciji.setActionCommand("kalkulacija");
            this.icnPremaKalkulaciji.addActionListener((ActionListener)((Object)this));
            this.icnPremaKalkulaciji.setShortcut("F5");
            this.icnPremaNivelaciji = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPremaNivelaciji);
            this.icnPremaNivelaciji.setText("Prema nivelaciji|(F6)");
            this.icnPremaNivelaciji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_signpost.png")));
            this.icnPremaNivelaciji.setActionCommand("nivelacija");
            this.icnPremaNivelaciji.addActionListener((ActionListener)((Object)this));
            this.icnPremaNivelaciji.setShortcut("F6");
            this.icnPremaInternom = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPremaInternom);
            this.icnPremaInternom.setText("Prema internom nalogu|(F7)");
            this.icnPremaInternom.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_signpost.png")));
            this.icnPremaInternom.setActionCommand("interni");
            this.icnPremaInternom.addActionListener((ActionListener)((Object)this));
            this.icnPremaInternom.setShortcut("F7");
            this.icnPremaLokaciji = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnPremaLokaciji);
            this.icnPremaLokaciji.setText("Prema lokaciji|(F8)");
            this.icnPremaLokaciji.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_signpost.png")));
            this.icnPremaLokaciji.setActionCommand("lokacija");
            this.icnPremaLokaciji.addActionListener((ActionListener)((Object)this));
            this.icnPremaLokaciji.setShortcut("F8");
            this.jSeparator3 = new JSeparator();
            this.toolbar.add(this.jSeparator3);
            this.jSeparator3.setOrientation(1);
            this.jSeparator3.setPreferredSize(new Dimension(8, 75));
            this.icnBrisiSve = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnBrisiSve);
            this.icnBrisiSve.setText("Bri\u0161i sve|(CTRL+Q)");
            this.icnBrisiSve.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/product_delete.png")));
            this.icnBrisiSve.setActionCommand("brisisve");
            this.icnBrisiSve.addActionListener((ActionListener)((Object)this));
            this.icnBrisiSve.setShortcut("Ctrl+Q");
            this.icnStampa = new PzToolBarIcon();
            this.toolbar.add((Component)this.icnStampa);
            this.icnStampa.setText("Stampaj nalepnice|(Alt+S)");
            this.icnStampa.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/printer_preferences.png")));
            this.icnStampa.setActionCommand("stampa");
            this.icnStampa.addActionListener((ActionListener)((Object)this));
            this.icnStampa.setShortcut("Alt+S");
            this.pnlPolja = new PzPanel();
            GridBagLayout pnlPoljaLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlPolja, (Object)new GridBagConstraints(0, 1, 5, 2, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlPoljaLayout.rowWeights = new double[]{0.0, 0.0, 0.1};
            pnlPoljaLayout.rowHeights = new int[]{10, 25, 7};
            pnlPoljaLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlPoljaLayout.columnWidths = new int[]{23, 139, 118, 224, 7};
            this.pnlPolja.setLayout((LayoutManager)pnlPoljaLayout);
            this.pnlPolja.setOpaque(false);
            this.lblBrojNalepnica = new JLabel();
            this.pnlPolja.add((Component)this.lblBrojNalepnica, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblBrojNalepnica.setText("Broj nalepnica");
            this.tfBrojNalepnica = this.tblTabela.createExpresionField("$7$");
            this.pnlPolja.add((Component)this.tfBrojNalepnica, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfBrojNalepnica.setFocusable(false);
            this.statusBar = new PzStatusBar();
            this.getContentPane().add((Component)this.statusBar, "South");
            this.statusBar.add((Component)this.jlStatusBar);
            this.jlStatusBar.setText("Broj stavki");
            this.statusBar.add((Component)this.brDok);
            this.brDok.setFocusable(false);
            this.brDok.setOpaque(false);
            this.pack();
            this.setSize(990, 600);
            this.setMinimumSize(new Dimension(990, 600));
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PzDialogStampanjeNalepnica.this.brDok.setText(Integer.toString(PzDialogStampanjeNalepnica.this.tblTabela.getRowCount()));
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        this.getSession().putParameter("izbor", (Object)this.sifra);
        this.getSession().putParameter("radnajedinica1", (Object)this.rj1);
        this.getSession().putParameter("radnajedinica2", (Object)this.rj2);
        this.getSession().putParameter("tabela", (Object)this.tblTabela);
        if (actionCommand.equals("dodaj")) {
            this.getSession().putParameter("update", (Object)false);
            this.showDialog(DodavanjeSifre.class);
            this.tblTabela.calculateFields();
            this.refresh();
            return;
        } else if (actionCommand.equals("izmena")) {
            if (this.tblTabela.getRowCount() == 0) return;
            this.showDialog(Izmena.class);
            this.tblTabela.calculateFields();
            return;
        } else if (actionCommand.equals("selektiranje")) {
            if (this.tblTabela.getRowCount() == 0) return;
            this.showDialog(Selektiranje.class);
            this.tblTabela.calculateFields();
            return;
        } else if (actionCommand.equals("brisanje")) {
            if (this.tblTabela.getRowCount() == 0) return;
            this.tblTabela.removeSelectedEntity(true, true);
            this.tblTabela.commitRemove();
            this.tblTabela.calculateFields();
            this.refresh();
            return;
        } else if (actionCommand.equals("brisisve")) {
            try {
                try {
                    int rez;
                    if (this.tblTabela.getRowCount() == 0 || (rez = PzSwingUtility.daNeDijalog((Component)SwingUtilities.getRoot((Component)((Object)this)), (Object)"Da li ste sigurni?!", (String)"Brisanje", null, (boolean)true)) != 0) return;
                    em.getTransaction().begin();
                    em.createQuery("Delete From Nalepnica").executeUpdate();
                    em.getTransaction().commit();
                    IndirectList lista = new IndirectList();
                    this.tblTabela.setData((List)lista, Nalepnica.class);
                    this.tblTabela.refreshData();
                    this.tfBrojNalepnica.setVal((Object)0.0);
                    this.refresh();
                    return;
                }
                catch (Exception e1) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
                    em.close();
                }
                return;
            }
            finally {
                em.close();
            }
        } else if (actionCommand.equals("kalkulacija")) {
            this.showDialog(DopunaPremaKalkulaciji.class);
            return;
        } else if (actionCommand.equals("nivelacija")) {
            this.getSession().putParameter("izbor", (Object)TipDokumentConfig.get().NIVELACIJA);
            this.showDialog(DopunaPremaNivelaciji.class);
            this.tblTabela.calculateFields();
            return;
        } else if (actionCommand.equals("interni")) {
            this.getSession().putParameter("izbor", (Object)TipDokumentConfig.get().INTERNI_NALOG);
            this.showDialog(DopunaPremaNivelaciji.class);
            this.tblTabela.calculateFields();
            return;
        } else if (actionCommand.equals("lokacija")) {
            this.showDialog(DopunaPremaLokaciji.class);
            this.tblTabela.calculateFields();
            this.refresh();
            return;
        } else if (actionCommand.equals("sifarnik")) {
            this.dopunePremaSifarniku();
            this.refresh();
            return;
        } else {
            if (!actionCommand.equals("stampa") || this.tblTabela.getRowCount() == 0) return;
            Vector<String> skupZaIzbor = new Vector<String>();
            String jedna = new String("Jedna cena");
            String dve = new String("Dve cene");
            skupZaIzbor.add(jedna);
            skupZaIzbor.add(dve);
            String izborKartice = PzDialogChoice.showPzDialogChoice((PzDialog)this, skupZaIzbor);
            if (izborKartice == null) {
                return;
            }
            if (izborKartice.equals(jedna)) {
                this.sifra = 1;
                this.rj1 = PzDialogRJ.getRJ((PzDialog)this);
                if (this.rj1 == null) {
                    return;
                }
            } else if (izborKartice.equals(dve)) {
                this.sifra = 2;
                this.rj1 = PzDialogRJ.getRJ((PzDialog)this, (String)"Izaberite velikoprodajnu RJ", (Character[])new Character[]{Character.valueOf('V')});
                if (this.rj1 == null) {
                    return;
                }
                this.rj2 = PzDialogRJ.getRJ((PzDialog)this, (String)"Izaberite maloprodajnu RJ", (Character[])new Character[]{Character.valueOf('E')});
                if (this.rj2 == null) {
                    return;
                }
            }
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    PzMagacinUtil.azurirajCene(PzDialogStampanjeNalepnica.this.tblTabela, PzDialogStampanjeNalepnica.this.rj1, PzDialogStampanjeNalepnica.this.rj2, em);
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            PzDialogStampanjeNalepnica.this.showReport();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)PzDialogStampanjeNalepnica.this), (Throwable)e);
                            em.close();
                            PzWorkerDialog.hideStatus();
                        }
                    }
                    finally {
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
            };
            worker.execute();
        }
    }

    private void showReport() throws Exception {
        String customFilePath;
        Vector<Firma> data = new Vector<Firma>();
        data.add(PzFirma.getFirma());
        IndirectList nalepnice = new IndirectList();
        for (PzEntity entity : this.tblTabela.getAllEntities()) {
            Nalepnica nal = (Nalepnica)entity;
            int i = 0;
            while (i < nal.getBrNalepnica()) {
                if (nal.getArtikal() == null) {
                    nal.setArtikal((Artikal)PzEntityManager.find(Artikal.class, (Object)nal.getSfrProizvod()));
                }
                nalepnice.add(nal);
                ++i;
            }
        }
        PzDataSourceExtended ds = new PzDataSourceExtended(data, (List)nalepnice);
        ds.setAdapter((PzDataSourceAdapter)new PzBeanDataSourceAdapter());
        HashMap params = new HashMap();
        URL url = null;
        url = this.sifra == 1 ? ((customFilePath = this.getCustomReport("nalepnice" + File.separator + "jedna_cena")) != null ? new File(customFilePath).toURI().toURL() : ((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/reports/compiled/nalepnice.jedna.cena.jasper")) : ((customFilePath = this.getCustomReport("dve_cene")) != null ? new File(customFilePath).toURI().toURL() : ((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/reports/compiled/nalepnice.dve.cene.jasper"));
        if (url == null) {
            return;
        }
        PzReportManager.createAndShowReport((PzDialog)this, (JRDataSource)ds, (URL)url, params, (String)"", (int)PzReportManager.REPORT_TYPE_JASPER);
    }

    private String getCustomReport(String dir) {
        File reportsDir;
        File file = reportsDir = PzParameter.getParameterValue((String)"REPORTS_DIR") == null || "".equals(PzParameter.getParameterValue((String)"REPORTS_DIR")) ? null : new File(PzParameter.getParameterValue((String)"REPORTS_DIR"));
        if (reportsDir == null) {
            return null;
        }
        File customDir = new File(String.valueOf(reportsDir.getAbsolutePath()) + File.separator + dir);
        if (!customDir.exists() || !customDir.isDirectory()) {
            return null;
        }
        Vector<String> files = new Vector<String>();
        if (customDir.exists() && customDir.listFiles().length > 0) {
            File[] fileArray = customDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                if (file2.getAbsolutePath().endsWith(".jasper")) {
                    files.add(file2.getName().replace(".jasper", ""));
                }
                ++n2;
            }
        }
        if (files.size() == 0) {
            return null;
        }
        String choice = files.size() == 1 ? (String)files.get(0) : PzDialogChoice.showPzDialogChoice((PzDialog)this, files);
        if (choice == null) {
            return null;
        }
        return String.valueOf(reportsDir.getAbsolutePath()) + File.separator + dir + File.separator + choice + ".jasper";
    }

    private void dopunePremaSifarniku() {
        final EntityManager em = PzEntityManager.getEm();
        final Radnajedinica rj = PzDialogRJ.getRJ((PzDialog)this);
        if (rj == null) {
            return;
        }
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                FetchGroup grpStanjeArtikal = new FetchGroup();
                grpStanjeArtikal.addAttribute("artikal.sfrProizvod");
                grpStanjeArtikal.addAttribute("artikal.naziv");
                grpStanjeArtikal.addAttribute("artikal.bliziOpis");
                grpStanjeArtikal.addAttribute("artikal.barKod");
                grpStanjeArtikal.addAttribute("artikal.jedMere");
                grpStanjeArtikal.addAttribute("kolicina");
                grpStanjeArtikal.addAttribute("prodCena");
                grpStanjeArtikal.addAttribute("artikal.proizvodjac.sfrKomitent");
                grpStanjeArtikal.addAttribute("artikal.standPak");
                grpStanjeArtikal.addAttribute("artikal.proizvodjac.naziv");
                grpStanjeArtikal.addAttribute("artikal.proizvodjac.zemljaKomitenta");
                Query q = em.createQuery("Select s from Stanje s join fetch s.artikal where s.radnajedinica=:rj ");
                q.setParameter("rj", (Object)rj);
                q.setHint("eclipselink.fetch-group", (Object)grpStanjeArtikal);
                Iterator i = q.getResultList().iterator();
                String firma = PzFirma.getFirma().getNaziv();
                while (i.hasNext()) {
                    Stanje s = (Stanje)i.next();
                    if (PzMagacinUtil.postojiArtikal(PzDialogStampanjeNalepnica.this.tblTabela, s.getArtikal().getSfrProizvod(), (int)s.getKolicina(), em).booleanValue()) continue;
                    PzMagacinUtil.createNalepnice(PzDialogStampanjeNalepnica.this.tblTabela, s.getArtikal(), new BigDecimal(s.getProdCena()), (int)s.getKolicina(), firma, em);
                }
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        PzDialogStampanjeNalepnica.this.tblTabela.commitInsert();
                        PzDialogStampanjeNalepnica.this.refresh();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogStampanjeNalepnica.this), (Throwable)e);
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStampanjeNalepnica(Boolean.FALSE);
    }

    public PzDialogStampanjeNalepnica(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        this.rj = PzDialogRJ.getRJ((PzDialog)this);
        this.getSession().putParameter("rj-nalepnice", (Object)this.rj);
        return this.rj != null;
    }
}

