/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.brzaposta;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.io.FileUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import rs.pezar.core.PzApplication;
import rs.pezar.db.PzEntity;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Faktura;
import rs.pezar.db.entity.Komitent;
import rs.pezar.magacin.gui.brzaposta.UzmiDokument;
import rs.pezar.magacin.gui.util.ESCPrinter;
import rs.pezar.sifarnici.gui.PzDialogKomintenti;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzDoubleField;
import rs.pezar.swing.fields.PzNumericOnlyTextField;
import rs.pezar.swing.fields.PzTextField;

public class PzDialogStampaNalogaZaBrzuPostu
extends PzDialog {
    private static final long serialVersionUID = -1487091348925367428L;
    private PzTextField nazKomitenta;
    private PzNumericOnlyTextField sfrKomitenta;
    private PzDoubleField dblVrednost;
    private PzTextField txtPrinter;
    private JLabel lblPrinter;
    private JTextArea txtStampa;
    private JScrollPane scPane;
    private PzTextField txtOpis;
    private JLabel lblOpis;
    private JLabel lblVrednost;
    private PzButton btnOk;
    private PzTextField oznDokument;
    private JLabel jLabel2;
    private JLabel jLabel1;
    private Komitent k;
    private Faktura faktura;
    private boolean otpremnica = false;
    private PzPanel mainPanel;
    private PzButton btnStampa;
    private ESCPrinter printer;
    private PzButton btnFormatStampa;

    public PzDialogStampaNalogaZaBrzuPostu(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        GridBagLayout layout = new GridBagLayout();
        this.setTitle("Izbor dokumenta za izradu naloga");
        layout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1, 0.0};
        layout.rowHeights = new int[]{25, 25, 20, 20, 20, 20};
        layout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
        layout.columnWidths = new int[]{103, 142, 76, 124, 20};
        this.mainPanel = new PzPanel();
        this.mainPanel.setLayout((LayoutManager)layout);
        this.getContentPane().add((Component)this.mainPanel);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.nazKomitenta = new PzTextField();
        this.mainPanel.add((Component)this.nazKomitenta, (Object)new GridBagConstraints(2, 0, 3, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 1, 5), 0, 0));
        this.nazKomitenta.setName("nazKomitenta");
        this.nazKomitenta.setEditable(false);
        this.nazKomitenta.setFocusable(false);
        this.sfrKomitenta = new PzNumericOnlyTextField();
        this.mainPanel.add((Component)this.sfrKomitenta, (Object)new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.sfrKomitenta.setName("sfrKomitenta");
        this.sfrKomitenta.setFKField(Komitent.class, PzDialogKomintenti.class, true, null);
        this.jLabel1 = new JLabel("Komitent:");
        this.mainPanel.add((Component)this.jLabel1, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jLabel1.setName("jLabel1");
        this.jLabel2 = new JLabel();
        this.mainPanel.add((Component)this.jLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jLabel2.setText("Dokument:");
        this.oznDokument = new PzTextField();
        this.mainPanel.add((Component)this.oznDokument, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.oznDokument.setName("oznDokument");
        this.oznDokument.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PzDialogStampaNalogaZaBrzuPostu.this.keyRel(evt);
            }
        });
        this.lblVrednost = new JLabel("Vrednost:");
        this.mainPanel.add((Component)this.lblVrednost, (Object)new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.lblVrednost.setName("lblVrednost");
        this.dblVrednost = new PzDoubleField();
        this.mainPanel.add((Component)this.dblVrednost, (Object)new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.dblVrednost.setName("dblVrednost");
        this.lblOpis = new JLabel("Opis sadrzaja:");
        this.mainPanel.add((Component)this.lblOpis, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.lblOpis.setName("lblOpis");
        this.txtOpis = new PzTextField();
        this.mainPanel.add((Component)this.txtOpis, (Object)new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.txtOpis.setVal((Object)PzParameter.getParameterValue((String)"NALOG_BRZA_POSTA_OPIS", (String)""));
        this.btnOk = new PzButton("Formatiraj");
        this.mainPanel.add((Component)this.btnOk, (Object)new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.btnOk.setPreferredSize(new Dimension(100, 30));
        this.btnOk.setName("btnOk");
        this.btnOk.addActionListener((ActionListener)((Object)this));
        this.btnStampa = new PzButton("Stampaj");
        this.mainPanel.add((Component)this.btnStampa, (Object)new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.btnStampa.setPreferredSize(new Dimension(100, 30));
        this.btnStampa.setName("btnStampaj");
        this.btnStampa.addActionListener((ActionListener)((Object)this));
        this.btnFormatStampa = new PzButton("Formatiraj i stampaj");
        this.mainPanel.add((Component)this.btnFormatStampa, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.btnStampa.setPreferredSize(new Dimension(150, 30));
        this.btnStampa.setName("btnFormatStampa");
        this.btnFormatStampa.addActionListener((ActionListener)((Object)this));
        this.scPane = new JScrollPane();
        this.mainPanel.add((Component)this.scPane, (Object)new GridBagConstraints(0, 4, 5, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.txtStampa = new JTextArea();
        this.txtStampa.setLineWrap(false);
        this.scPane.setViewportView(this.txtStampa);
        this.lblPrinter = new JLabel("Printer:");
        this.mainPanel.add((Component)this.lblPrinter, (Object)new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.txtPrinter = new PzTextField();
        this.mainPanel.add((Component)this.txtPrinter, (Object)new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.txtPrinter.setText(PzParameter.getParameterValue((String)"PRINTER_PORT", (String)"LPT1"));
        this.pack();
        this.setSize(716, 538);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            EntityManager em = PzEntityManager.getEm();
            this.faktura = (Faktura)em.find(Faktura.class, (Object)this.faktura.getIdDok());
            Velocity.setProperty((String)"file.resource.loader.path", (Object)(PzApplication.getApplication().getDataFolder() + File.separator + "reports"));
            Velocity.init();
            VelocityContext context = new VelocityContext();
            context.put("firma", (Object)PzFirma.getFirma((EntityManager)em));
            context.put("komitent", (Object)this.k);
            context.put("vrednost", (Object)this.dblVrednost.getVal());
            context.put("opis", (Object)this.txtOpis.getVal());
            Template template = null;
            try {
                File file = new File(PzApplication.getApplication().getDataFolder() + File.separator + "reports" + File.separator + "template.vm");
                if (!file.exists()) {
                    FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/gui/brzaposta/resources/template.vm"), (File)file);
                }
                template = Velocity.getTemplate((String)"template.vm");
                StringWriter sw = new StringWriter();
                template.merge((Context)context, (Writer)sw);
                this.txtStampa.setText(sw.toString());
            }
            catch (Exception ex) {
                PzMysqlExceptionHandler.handle((Throwable)ex);
            }
        } else if (e.getSource() == this.btnStampa) {
            try {
                try {
                    if (this.printer == null) {
                        this.printer = new ESCPrinter(this.txtPrinter.getVal(), false);
                    }
                    this.printer.initialize();
                    this.printer.printWithTags(this.txtStampa.getText());
                    PzParameter.setParameter((String)"LPT_PRINTER", (String)this.txtPrinter.getVal());
                    PzParameter.setParameter((String)"NALOG_BRZA_POSTA_OPIS", (String)this.txtOpis.getVal());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.printer.close();
                }
            }
            finally {
                this.printer.close();
            }
        } else if (e.getSource() == this.btnFormatStampa) {
            this.btnOk.doClick();
            this.btnStampa.doClick();
        }
    }

    public void setEntity(PzEntity entity, Component component) {
        if (entity instanceof Komitent) {
            this.k = (Komitent)entity;
            this.sfrKomitenta.setVal((Object)this.k.getSfrKomitent());
            this.nazKomitenta.setVal((Object)this.k.getNaziv());
        }
        if (entity == null) {
            this.nazKomitenta.setVal((Object)"");
        }
    }

    private void keyRel(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.faktura = null;
            if (this.oznDokument.getVal().equals("")) {
                if (this.otpremnica) {
                    this.getSession().putParameter("vracanjeOtpremniceUPripremu", (Object)true);
                } else {
                    this.getSession().putParameter("vracanjeFaktureUPripremu", (Object)true);
                }
                this.getSession().putParameter("komitent", (Object)this.k);
                this.showDialog(UzmiDokument.class);
                if (this.faktura == null) {
                    JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna " + (this.otpremnica ? "otpremnica" : "faktura") + " izabranog komitenta!", "Informacija ", 1);
                    this.sfrKomitenta.requestFocusInWindow();
                    return;
                }
                this.dblVrednost.setVal((Object)this.faktura.getIznos());
            } else {
                EntityManager em = PzEntityManager.getEm();
                Query q = null;
                q = this.otpremnica ? em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=0 and f.arhiviran = 1 and f.storno=0 and f.original is null and f.tip ='OTPREMNICA' and f.komitent=:komitent and f.oznDokumenta=:ozn") : em.createQuery("SELECT f FROM Faktura f where f.dokument.proknjizen=0 and f.arhiviran = 1 and f.storno=0 and f.original is null and ((f.tip ='FAKTURA' and f.podTip != 'POCETNO') or f.tip ='FAKTURA_USLUGA') and f.komitent=:komitent and f.oznDokumenta=:ozn");
                q.setParameter("komitent", (Object)this.k);
                q.setParameter("ozn", (Object)this.oznDokument.getVal());
                Vector data = (Vector)q.getResultList();
                if (data.size() == 1) {
                    this.faktura = (Faktura)q.getSingleResult();
                } else {
                    JOptionPane.showMessageDialog(this.getParent(), "Nijedna " + (this.otpremnica ? "otpremnica" : "faktura") + " izabranog komitenta sa unetom oznakom ne zadovaljava neophodne uslove pretrage!", "Informacija ", 1);
                    this.faktura = null;
                    return;
                }
            }
        }
    }

    public void refreshField(Faktura f) {
        this.faktura = f;
        if (f == null) {
            JOptionPane.showMessageDialog(this.getParent(), "Nije odabrana nijedna " + (this.otpremnica ? "otpremnica" : "faktura") + " izabranog komitenta!", "Informacija ", 1);
            this.sfrKomitenta.requestFocusInWindow();
            return;
        }
        this.oznDokument.setVal((Object)f.getOznDokumenta());
    }

    public static Object getGUIBuilderInstance() {
        return new PzDialogStampaNalogaZaBrzuPostu(Boolean.FALSE);
    }

    public PzDialogStampaNalogaZaBrzuPostu(Boolean initGUI) {
    }

    public boolean shouldBeShown() {
        return true;
    }
}

