/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.stampanjeNalepnica;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingWorker;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Nalepnica;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.magacin.gui.util.PzMagacinUtil;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.data.models.PzTableModel;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzTextField;
import rs.pezar.swing.util.PzSwingUtility;

public class DopunaPremaLokaciji
extends PzDialog {
    private static final long serialVersionUID = -5988185049385484511L;
    private PzPanel pnlGlavni;
    private PzPanel pnlFields;
    private PzTextField tfKrajnjaLokacija;
    private JLabel lblKrajnjaLokacija;
    private PzTextField tfPocetnaLokacija;
    private JLabel lblPocetnaLokacija;
    private PzButton btnPotvrdi;
    private PzTable tabela;
    private Radnajedinica rj;
    private ScrollableCursor cursor;

    public DopunaPremaLokaciji(PzDialog dialog) {
        super(dialog);
        this.initGUI();
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.rj = (Radnajedinica)this.getSession().getParameter("radnajedinica");
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setTitle("IZBOR PO LOKACIJI");
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{33, 31, 27, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.1, 0.1, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{7, 7, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlFields = new PzPanel();
            GridBagLayout pnlFieldsLayout = new GridBagLayout();
            this.pnlGlavni.add((Component)this.pnlFields, (Object)new GridBagConstraints(0, 0, 4, 4, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlFieldsLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.rowHeights = new int[]{31, 25, 25, 7};
            pnlFieldsLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.1};
            pnlFieldsLayout.columnWidths = new int[]{115, 55, 55, 7};
            this.pnlFields.setLayout((LayoutManager)pnlFieldsLayout);
            this.lblPocetnaLokacija = new JLabel();
            this.pnlFields.add((Component)this.lblPocetnaLokacija, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblPocetnaLokacija.setName("lblPocetnaLokacija");
            this.tfPocetnaLokacija = new PzTextField();
            this.pnlFields.add((Component)this.tfPocetnaLokacija, (Object)new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblKrajnjaLokacija = new JLabel();
            this.pnlFields.add((Component)this.lblKrajnjaLokacija, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 20, 0, 0), 0, 0));
            this.lblKrajnjaLokacija.setName("lblKrajnjaLokacija");
            this.tfKrajnjaLokacija = new PzTextField();
            this.pnlFields.add((Component)this.tfKrajnjaLokacija, (Object)new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi = new PzButton();
            this.pnlFields.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(110, 33));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.pack();
            this.setSize(349, 200);
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        final EntityManager em = PzEntityManager.getEm();
        if (actionCommand.equals("potvrdi")) {
            if (this.tfPocetnaLokacija.getVal().length() != 6 || this.tfKrajnjaLokacija.getVal().length() != 6) {
                PzSwingUtility.showErrorMessage((Component)((Object)this), (String)"Lokacije nisu validne!");
                return;
            }
            PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
            SwingWorker<Nalepnica, Object> worker = new SwingWorker<Nalepnica, Object>(){

                @Override
                protected Nalepnica doInBackground() throws Exception {
                    String firma = PzFirma.getFirma().getNaziv();
                    em.getTransaction().begin();
                    if (DopunaPremaLokaciji.this.cursor != null) {
                        DopunaPremaLokaciji.this.cursor.close();
                    }
                    Query q = em.createQuery("Select s.id.sfrProizvod, s.naziv, s.bliziOpis, s.barKod, s.standPak, s.prodCena, s.jedMere, s.sfrProizvodjac, s.nazivProizvodjac, s.stalaza, s.nivo, s.paleta, k.zemljaKomitenta From Stanjeartikal s, Komitent k where k.sfrKomitent=s.sfrProizvodjac and s.radnajedinica=:rj and concat(concat(s.stalaza, s.nivo), s.paleta)>=:adresaP and concat(concat(s.stalaza, s.nivo), s.paleta)<=:adresaK");
                    q.setParameter("rj", (Object)DopunaPremaLokaciji.this.rj);
                    q.setParameter("adresaP", (Object)DopunaPremaLokaciji.this.tfPocetnaLokacija.getVal());
                    q.setParameter("adresaK", (Object)DopunaPremaLokaciji.this.tfKrajnjaLokacija.getVal());
                    q.setHint("eclipselink.cursor.scrollable", (Object)"True");
                    q.setHint("eclipselink.read-only", (Object)"True");
                    DopunaPremaLokaciji.this.cursor = (ScrollableCursor)q.getSingleResult();
                    if (DopunaPremaLokaciji.this.cursor.size() == 0) {
                        PzSwingUtility.showErrorMessage((Component)((Object)DopunaPremaLokaciji.this), (String)"Ne postoje artikli u datom intervalu lokacija!");
                    } else {
                        Object[] stanje = null;
                        while (DopunaPremaLokaciji.this.cursor.hasNext()) {
                            stanje = (Object[])DopunaPremaLokaciji.this.cursor.next();
                            System.out.println("sifra je " + stanje[0]);
                            if (!PzMagacinUtil.postojiArtikal(DopunaPremaLokaciji.this.tabela, (String)stanje[0], 1, em).booleanValue()) {
                                Nalepnica n = new Nalepnica();
                                n.setSfrProizvod((String)stanje[0]);
                                n.setNaziv((String)stanje[1]);
                                n.setBliziOpis((String)stanje[2]);
                                n.setBarKod((String)stanje[3]);
                                n.setStandPak(new BigDecimal((Double)stanje[4]));
                                n.setAdresa(DopunaPremaLokaciji.getAdresa(stanje));
                                n.setBrNalepnica(1);
                                n.setCena(new BigDecimal((Double)stanje[5]));
                                n.setDistributer(firma);
                                n.setJedMere((String)stanje[6]);
                                n.setUvoznik(firma);
                                if ((String)stanje[7] == null) {
                                    n.setProizvodjac("");
                                    n.setZemlja("");
                                } else {
                                    n.setProizvodjac((String)stanje[8]);
                                    n.setZemlja((String)stanje[12]);
                                }
                                em.persist((Object)n);
                                ((PzTableModel)DopunaPremaLokaciji.this.tabela.getModel()).getEntities().add(n);
                                continue;
                            }
                            DopunaPremaLokaciji.this.tabela.commitUpdate();
                        }
                        em.getTransaction().commit();
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        try {
                            this.get();
                            DopunaPremaLokaciji.this.tabela.refreshData();
                        }
                        catch (Exception e) {
                            PzMysqlExceptionHandler.handle((Component)((Object)DopunaPremaLokaciji.this), (Throwable)e);
                            DopunaPremaLokaciji.this.cursor.close();
                            em.close();
                            PzWorkerDialog.hideStatus();
                            DopunaPremaLokaciji.this.dispose();
                        }
                    }
                    finally {
                        DopunaPremaLokaciji.this.cursor.close();
                        em.close();
                        PzWorkerDialog.hideStatus();
                        DopunaPremaLokaciji.this.dispose();
                    }
                }
            };
            worker.execute();
        }
    }

    public static String getAdresa(Object[] artikal) {
        String adresa = "";
        try {
            if (artikal[9] != null && artikal[10] != null && artikal[11] != null) {
                adresa = String.valueOf(artikal[9].toString()) + artikal[10].toString() + artikal[11].toString();
            }
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Throwable)e);
        }
        return adresa;
    }

    public static Object getGUIBuilderInstance() {
        return new DopunaPremaLokaciji(Boolean.FALSE);
    }

    public DopunaPremaLokaciji(Boolean initGUI) {
    }
}

