/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.magacin.gui.stampanjeNalepnica;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.jdesktop.application.Application;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.commons.PzFirma;
import rs.pezar.db.entity.Artikal;
import rs.pezar.db.entity.Artikalinterniracun;
import rs.pezar.db.entity.Artikalnivelacija;
import rs.pezar.db.entity.Interniracun;
import rs.pezar.db.entity.Nivelacija;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.globals.TipDokumentConfig;
import rs.pezar.magacin.gui.PzDialogStampanjeNalepnica;
import rs.pezar.magacin.gui.stampanjeNalepnica.UzmiDokument;
import rs.pezar.magacin.gui.util.PzMagacinUtil;
import rs.pezar.sifarnici.gui.PzDialogRJ;
import rs.pezar.swing.PzButton;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzTable;
import rs.pezar.swing.PzWorkerDialog;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.fields.PzNumericOnlyTextField;

public class DopunaPremaNivelaciji
extends PzDialog {
    private PzPanel pnlGlavni;
    private JLabel lblBrojNivelacije;
    private Nivelacija nivelacija;
    private Interniracun racun;
    private Radnajedinica rj;
    private PzButton btnPotvrdi;
    private PzNumericOnlyTextField tfNivelacija;
    private PzTable tabela;
    private Artikal artikal;
    private String izbor;

    public DopunaPremaNivelaciji(PzDialog dialog) {
        super(dialog);
        this.izbor = (String)this.getSession().getParameter("izbor");
        this.rj = (Radnajedinica)this.getSession().getParameter("radnajedinica");
        this.tabela = (PzTable)this.getSession().getParameter("tabela");
        this.initGUI();
        if (this.izbor.equals(TipDokumentConfig.get().NIVELACIJA)) {
            this.lblBrojNivelacije.setText("Broj nivelacije");
            this.setTitle("DOPUNA PREMA NIVELACIJI");
        } else {
            this.lblBrojNivelacije.setText("Broj internog naloga");
            this.setTitle("DOPUNA PREMA INTERNOM NALOGU");
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.pnlGlavni = new PzPanel();
            this.pnlGlavni.setPaintGradient(true);
            GridBagLayout pnlGlavniLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.pnlGlavni, "Center");
            pnlGlavniLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.1};
            pnlGlavniLayout.rowHeights = new int[]{31, 25, 8, 29, 7};
            pnlGlavniLayout.columnWeights = new double[]{0.0, 0.0, 0.1, 0.1};
            pnlGlavniLayout.columnWidths = new int[]{128, 116, 7, 7};
            this.pnlGlavni.setLayout((LayoutManager)pnlGlavniLayout);
            this.pnlGlavni.setPreferredSize(new Dimension(361, 134));
            this.lblBrojNivelacije = new JLabel();
            this.pnlGlavni.add((Component)this.lblBrojNivelacije, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 0, 0), 0, 0));
            this.tfNivelacija = new PzNumericOnlyTextField();
            this.pnlGlavni.add((Component)this.tfNivelacija, (Object)new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.tfNivelacija.setMaxLength(5);
            this.tfNivelacija.setInputVerifier(new InputVerifier(){

                @Override
                public boolean verify(JComponent input) {
                    if (DopunaPremaNivelaciji.this.izbor.equals(TipDokumentConfig.get().NIVELACIJA)) {
                        if (DopunaPremaNivelaciji.this.tfNivelacija.getVal().equals("0")) {
                            DopunaPremaNivelaciji.this.getSession().putParameter("tip", (Object)TipDokumentConfig.get().NIVELACIJA);
                            DopunaPremaNivelaciji.this.getSession().putParameter("radnajedinica", (Object)DopunaPremaNivelaciji.this.rj);
                            DopunaPremaNivelaciji.this.getSession().putParameter("dokument", null);
                            DopunaPremaNivelaciji.this.showDialog(UzmiDokument.class);
                            DopunaPremaNivelaciji.this.nivelacija = (Nivelacija)DopunaPremaNivelaciji.this.getSession().getParameter("dokument");
                            if (DopunaPremaNivelaciji.this.nivelacija == null) {
                                return false;
                            }
                            DopunaPremaNivelaciji.this.tfNivelacija.setVal((Object)DopunaPremaNivelaciji.this.nivelacija.getrBroj());
                        } else {
                            DopunaPremaNivelaciji.this.nivelacija = DopunaPremaNivelaciji.this.getNivelacija();
                            if (DopunaPremaNivelaciji.this.nivelacija == null) {
                                JOptionPane.showMessageDialog((Component)((Object)DopunaPremaNivelaciji.this), "Tra\u017eeni broj nivelacije nije prona\u0111en!", "Informacija", 1);
                                return false;
                            }
                        }
                    } else if (DopunaPremaNivelaciji.this.tfNivelacija.getVal().equals("0")) {
                        DopunaPremaNivelaciji.this.getSession().putParameter("tip", (Object)TipDokumentConfig.get().INTERNI_NALOG);
                        DopunaPremaNivelaciji.this.getSession().putParameter("radnajedinica", (Object)DopunaPremaNivelaciji.this.rj);
                        DopunaPremaNivelaciji.this.getSession().putParameter("dokument", null);
                        DopunaPremaNivelaciji.this.showDialog(UzmiDokument.class);
                        DopunaPremaNivelaciji.this.racun = (Interniracun)DopunaPremaNivelaciji.this.getSession().getParameter("dokument");
                        if (DopunaPremaNivelaciji.this.racun == null) {
                            return false;
                        }
                        DopunaPremaNivelaciji.this.tfNivelacija.setVal((Object)DopunaPremaNivelaciji.this.racun.getrBroj());
                    } else {
                        DopunaPremaNivelaciji.this.racun = DopunaPremaNivelaciji.this.getRacun();
                        if (DopunaPremaNivelaciji.this.racun == null) {
                            JOptionPane.showMessageDialog((Component)((Object)DopunaPremaNivelaciji.this), "Tra\u017eeni broj internog naloga nije prona\u0111en!", "Informacija", 1);
                            return false;
                        }
                    }
                    return true;
                }
            });
            this.btnPotvrdi = new PzButton();
            this.pnlGlavni.add((Component)this.btnPotvrdi, (Object)new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPotvrdi.setText("Potvrdi");
            this.btnPotvrdi.setBounds(195, 12, 133, 30);
            this.btnPotvrdi.setFont(new Font("Tahoma", 1, 12));
            this.btnPotvrdi.setIcon((Icon)new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/magacin/resource/img/check.png")));
            this.btnPotvrdi.setPreferredSize(new Dimension(120, 35));
            this.btnPotvrdi.addActionListener((ActionListener)((Object)this));
            this.btnPotvrdi.setActionCommand("potvrdi");
            this.pack();
            this.setPreferredSize(new Dimension(393, 179));
            this.setResizable(false);
            Application.getInstance().getContext().getResourceMap(((Object)((Object)this)).getClass()).injectComponents((Component)this.getContentPane());
        }
        catch (Exception e) {
            PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    public void napraviNalepnice(final Nivelacija niv) {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                String firma = PzFirma.getFirma().getNaziv();
                for (Artikalnivelacija art : niv.getArtikalnivelacijas()) {
                    if (!PzMagacinUtil.postojiArtikal(DopunaPremaNivelaciji.this.tabela, art.getId().getSfrProizvod(), (int)art.getKolicina(), em).booleanValue()) {
                        DopunaPremaNivelaciji.this.artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)art.getSifra());
                        PzMagacinUtil.createNalepnice(DopunaPremaNivelaciji.this.tabela, DopunaPremaNivelaciji.this.artikal, new BigDecimal(art.getCenaNova()), (int)art.getKolicina(), firma, em);
                        continue;
                    }
                    DopunaPremaNivelaciji.this.tabela.commitUpdate();
                }
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        DopunaPremaNivelaciji.this.tabela.commitInsert();
                        ((PzDialogStampanjeNalepnica)((Object)DopunaPremaNivelaciji.this.getParent())).refresh();
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)DopunaPremaNivelaciji.this), (Throwable)e1);
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    public void napraviNalepnice(final Interniracun racun) {
        final EntityManager em = PzEntityManager.getEm();
        PzWorkerDialog.showStatus((String)"Molim, sa\u010dekajte...", (PzDialog)this);
        SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                em.getTransaction().begin();
                String firma = PzFirma.getFirma().getNaziv();
                for (Artikalinterniracun art : racun.getArtikalinterniracuns()) {
                    if (!PzMagacinUtil.postojiArtikal(DopunaPremaNivelaciji.this.tabela, art.getId().getSfrProizvod(), (int)art.getKolicina(), em).booleanValue()) {
                        DopunaPremaNivelaciji.this.artikal = (Artikal)PzEntityManager.find(Artikal.class, (Object)art.getSifra());
                        PzMagacinUtil.createNalepnice(DopunaPremaNivelaciji.this.tabela, DopunaPremaNivelaciji.this.artikal, null, (int)art.getKolicina(), firma, em);
                        continue;
                    }
                    DopunaPremaNivelaciji.this.tabela.commitUpdate();
                }
                em.getTransaction().commit();
                return null;
            }

            @Override
            protected void done() {
                try {
                    try {
                        this.get();
                        DopunaPremaNivelaciji.this.tabela.commitInsert();
                        ((PzDialogStampanjeNalepnica)((Object)DopunaPremaNivelaciji.this.getParent())).refresh();
                    }
                    catch (Exception e1) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        PzMysqlExceptionHandler.handle((Component)((Object)DopunaPremaNivelaciji.this), (Throwable)e1);
                        em.close();
                        PzWorkerDialog.hideStatus();
                    }
                }
                finally {
                    em.close();
                    PzWorkerDialog.hideStatus();
                }
            }
        };
        worker.execute();
    }

    private Nivelacija getNivelacija() {
        EntityManager em = PzEntityManager.getEm();
        Nivelacija niv = null;
        Query q = em.createQuery("Select n from Nivelacija n Where n.radnajedinica=:rj and n.arhiviran=1 and n.rBroj=:broj and n.tip='NIVELACIJA'");
        q.setParameter("rj", (Object)this.rj);
        q.setParameter("broj", (Object)this.tfNivelacija.getIntVal());
        if (q.getResultList().size() != 0) {
            niv = (Nivelacija)q.getSingleResult();
        }
        return niv;
    }

    private Interniracun getRacun() {
        EntityManager em = PzEntityManager.getEm();
        Interniracun rac = null;
        String upit = "Select r from Interniracun r Where r.izlaznaRJ=:rj and r.arhiviran=1 and r.rBroj=:broj and r.tip='" + TipDokumentConfig.get().INTERNI_NALOG + "'";
        Query q = em.createQuery(upit);
        q.setParameter("rj", (Object)this.rj);
        q.setParameter("broj", (Object)this.tfNivelacija.getIntVal());
        if (q.getResultList().size() != 0) {
            rac = (Interniracun)q.getSingleResult();
        }
        return rac;
    }

    public boolean shouldBeShown() {
        boolean res = false;
        this.rj = this.izbor.equals(TipDokumentConfig.get().NIVELACIJA) ? PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0))}) : PzDialogRJ.getRJ((PzDialog)this, (Character[])new Character[]{Character.valueOf("V".charAt(0)), Character.valueOf("E".charAt(0)), Character.valueOf("T".charAt(0))});
        if (this.rj != null) {
            res = true;
        }
        return res;
    }

    public void actionPerformed(ActionEvent e) {
        PzButton button = (PzButton)e.getSource();
        String actionCommand = button.getActionCommand();
        if (actionCommand.equals("potvrdi")) {
            try {
                if (this.izbor.equals(TipDokumentConfig.get().NIVELACIJA)) {
                    this.napraviNalepnice(this.nivelacija);
                } else {
                    this.napraviNalepnice(this.racun);
                }
                this.dispose();
            }
            catch (Exception e1) {
                PzMysqlExceptionHandler.handle((Component)((Object)this), (Throwable)e1);
            }
        }
    }

    public static Object getGUIBuilderInstance() {
        return new DopunaPremaNivelaciji(Boolean.FALSE);
    }

    public DopunaPremaNivelaciji(Boolean initGUI) {
    }
}

