/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.msg.control;

import org.apache.commons.lang.StringUtils;
import rs.pezar.msg.msg.control.OnlineUserData;
import rs.pezar.msg.tools.scrambler.DataScrambler;

public class ControlMessageDecoder {
    public static final String QUEUE_DELIMITER_START = "<q>";
    public static final String QUEUE_DELIMITER_END = "</q>";
    public static final String DEVICE_DELIMITER_START = "<d>";
    public static final String DEVICE_DELIMITER_END = "</d>";
    public static final String ACTION_DELIMITER_START = "<a>";
    public static final String ACTION_DELIMITER_END = "</a>";
    public static final String STATE_DELIMITER_START = "<s>";
    public static final String STATE_DELIMITER_END = "</s>";
    public static final String RANK_DELIMITER_START = "<r>";
    public static final String RANK_DELIMITER_END = "</r>";
    public static final String POSITION_DELIMITER_START = "<p>";
    public static final String POSITION_DELIMITER_END = "</p>";
    public static final String COMPANY_DELIMITER_START = "<c>";
    public static final String COMPANY_DELIMITER_END = "</c>";
    private static final String REMOTE_ID_DELIMITER_START = "<i>";
    private static final String REMOTE_ID_DELIMITER_END = "</i>";

    public static final OnlineUserData decodeData(String message) {
        int i;
        OnlineUserData userData = new OnlineUserData();
        String descrambledMessage = DataScrambler.descrambleData(message);
        String queue = StringUtils.substringBetween((String)descrambledMessage, (String)QUEUE_DELIMITER_START, (String)QUEUE_DELIMITER_END);
        String device = StringUtils.substringBetween((String)descrambledMessage, (String)DEVICE_DELIMITER_START, (String)DEVICE_DELIMITER_END);
        String action = StringUtils.substringBetween((String)descrambledMessage, (String)ACTION_DELIMITER_START, (String)ACTION_DELIMITER_END);
        String state = StringUtils.substringBetween((String)descrambledMessage, (String)STATE_DELIMITER_START, (String)STATE_DELIMITER_END);
        String rank = StringUtils.substringBetween((String)descrambledMessage, (String)RANK_DELIMITER_START, (String)RANK_DELIMITER_END);
        String position = StringUtils.substringBetween((String)descrambledMessage, (String)POSITION_DELIMITER_START, (String)POSITION_DELIMITER_END);
        String company = StringUtils.substringBetween((String)descrambledMessage, (String)COMPANY_DELIMITER_START, (String)COMPANY_DELIMITER_END);
        String remoteID = StringUtils.substringBetween((String)descrambledMessage, (String)REMOTE_ID_DELIMITER_START, (String)REMOTE_ID_DELIMITER_END);
        if (device != null && device.length() != 0) {
            String[] devices = device.split(";");
            i = 0;
            while (i < devices.length) {
                userData.addDevice(devices[i]);
                ++i;
            }
        }
        if (action != null && action.length() != 0) {
            String[] actions = action.split(";");
            i = 0;
            while (i < actions.length) {
                userData.addAction(actions[i]);
                ++i;
            }
        }
        userData.setTimeStamp(System.currentTimeMillis());
        userData.setQueue(queue == null ? "" : queue);
        userData.setPosition(position == null ? "" : position);
        userData.setRank(rank == null ? "" : rank);
        userData.setState(state == null ? "" : state);
        userData.setCompany(company == null ? "" : company);
        userData.setRemoteId(remoteID);
        return userData;
    }

    public static final String codeData(OnlineUserData userData) {
        int i;
        String queue = QUEUE_DELIMITER_START + userData.getQueue() + QUEUE_DELIMITER_END;
        String device = "";
        String action = "";
        String state = STATE_DELIMITER_START + userData.getState() + STATE_DELIMITER_END;
        String rank = RANK_DELIMITER_START + userData.getRank() + RANK_DELIMITER_END;
        String position = POSITION_DELIMITER_START + userData.getPosition() + POSITION_DELIMITER_END;
        String company = COMPANY_DELIMITER_START + userData.getCompany() + COMPANY_DELIMITER_END;
        String remoteId = REMOTE_ID_DELIMITER_START + userData.getRemoteID() + REMOTE_ID_DELIMITER_END;
        if (userData.getDevices() != null) {
            i = 0;
            while (i < userData.getDevices().size()) {
                device = String.valueOf(device) + userData.getDevices().get(i) + ";";
                ++i;
            }
        }
        device = DEVICE_DELIMITER_START + device + DEVICE_DELIMITER_END;
        if (userData.getActions() != null) {
            i = 0;
            while (i < userData.getActions().size()) {
                action = String.valueOf(action) + userData.getActions().get(i) + ";";
                ++i;
            }
        }
        action = ACTION_DELIMITER_START + action + ACTION_DELIMITER_END;
        return String.valueOf(queue) + device + action + state + rank + position + company + remoteId;
    }

    public static void main(String[] args) {
        String temp = "<queue>queue</queue><device>DEVICE:queue:id:type:name;queue:id:type:name;queue:id:type:name;</device><action>id;id;id;id;id;</action><state>state</state><rank>rank</rank><position>position</position><co>company</co>";
        temp = StringUtils.substringBetween((String)temp, (String)"<queue>", (String)"</queue>");
        System.out.println(temp);
    }
}

