/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.tools.downloadUnpack;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class FileDownloader
extends JDialog {
    private JProgressBar current;
    private JLabel info;

    public FileDownloader(JFrame parent) {
        super(parent);
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(20, 10, 20, 10));
        this.getContentPane().add(panel);
        GridBagLayout gbl_panel = new GridBagLayout();
        int[] nArray = new int[2];
        nArray[0] = 300;
        gbl_panel.columnWidths = nArray;
        int[] nArray2 = new int[5];
        nArray2[1] = 30;
        gbl_panel.rowHeights = nArray2;
        gbl_panel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_panel.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        panel.setLayout(gbl_panel);
        this.current = new JProgressBar(0, 100);
        GridBagConstraints gbc_current = new GridBagConstraints();
        gbc_current.fill = 1;
        gbc_current.insets = new Insets(0, 0, 5, 0);
        gbc_current.gridx = 0;
        gbc_current.gridy = 1;
        panel.add((Component)this.current, gbc_current);
        this.current.setSize(50, 50);
        this.current.setStringPainted(true);
        this.info = new JLabel("");
        this.info.setHorizontalAlignment(0);
        GridBagConstraints gbc_info = new GridBagConstraints();
        gbc_info.fill = 1;
        gbc_info.gridx = 0;
        gbc_info.gridy = 2;
        panel.add((Component)this.info, gbc_info);
        this.setSize(351, 195);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    public String start(String urlString, String saveTo, String filename) {
        String name = "temp_" + System.currentTimeMillis() + ".zip";
        if (filename != null && !filename.equals("")) {
            name = filename;
        }
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int filesize = connection.getContentLength();
            float totalDataRead = 0.0f;
            BufferedInputStream in = new BufferedInputStream(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(String.valueOf(saveTo) + "\\" + name);
            BufferedOutputStream bout = new BufferedOutputStream(fos, 2048);
            byte[] data = new byte[2048];
            int i = 0;
            while ((i = in.read(data, 0, 2037)) != -1) {
                bout.write(data, 0, i);
                float Percent = (totalDataRead += (float)i) * 100.0f / (float)filesize;
                this.info.setText(String.valueOf(String.format("%.2g%n", Float.valueOf(totalDataRead / 1048576.0f))) + " MB /" + String.format("%.2g%n", Float.valueOf((float)filesize / 1048576.0f)) + " MB");
                this.current.setValue((int)Percent);
            }
            bout.close();
            in.close();
            this.dispose();
        }
        catch (Exception e) {
            JOptionPane.showConfirmDialog(this, e.getMessage(), "Error", -1);
        }
        return String.valueOf(saveTo) + "\\" + name;
    }

    public static JDialog getFileDownloader(JFrame parent) {
        return new FileDownloader(parent);
    }

    public static final void main(String[] args) throws Exception {
        FileDownloader fd = new FileDownloader(null);
        fd.setVisible(true);
        fd.setTitle("Preuzimanje fajla");
        fd.start("http://www.uvnc.eu/download/10961/UltraVNC_1.0.9.6.1.bins.zip", "c:\\vnc", null);
    }
}

