/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.tools.downloadUnpack;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Utils {
    public static File unpackArchive(URL url, File targetDir) throws IOException {
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        BufferedInputStream in = new BufferedInputStream(url.openStream(), 1024);
        File zip = File.createTempFile("arc", ".zip", targetDir);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(zip));
        Utils.copyInputStream(in, out);
        ((OutputStream)out).close();
        return Utils.unpackArchive(zip, targetDir);
    }

    public static File unpackArchive(File theFile, File targetDir) throws IOException {
        if (!theFile.exists()) {
            throw new IOException(String.valueOf(theFile.getAbsolutePath()) + " does not exist");
        }
        if (!Utils.buildDirectory(targetDir)) {
            throw new IOException("Could not create directory: " + targetDir);
        }
        ZipFile zipFile = new ZipFile(theFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File file = new File(targetDir, String.valueOf(File.separator) + entry.getName());
            if (!Utils.buildDirectory(file.getParentFile())) {
                throw new IOException("Could not create directory: " + file.getParentFile());
            }
            if (!entry.isDirectory()) {
                Utils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(file)));
                continue;
            }
            if (Utils.buildDirectory(file)) continue;
            throw new IOException("Could not create directory: " + file);
        }
        zipFile.close();
        return theFile;
    }

    public static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = in.read(buffer);
        while (len >= 0) {
            out.write(buffer, 0, len);
            len = in.read(buffer);
        }
        in.close();
        out.close();
    }

    public static boolean buildDirectory(File file) {
        return file.exists() || file.mkdirs();
    }
}

