/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.msg.widget.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.apache.commons.lang.StringUtils;
import rs.pezar.msg.PzExtensionLoader;
import rs.pezar.msg.chat.interfaces.TextMessageReceiverInterface;
import rs.pezar.msg.msg.MsgProtocol;
import rs.pezar.msg.widget.panel.PnlSettings;
import rs.pezar.msg.widget.panel.pnlKorisnik.PnlIcons;
import rs.pezar.msg.widget.panel.pnlKorisnik.PnlKorisnikSmaller;
import rs.pezar.msg.widget.panel.pnlKorisnik.RightClickMenu;
import rs.pezar.swing.PzPanel;

public class PnlKorisnik
extends PzPanel {
    private JLabel lblIconStatus;
    private JLabel lblUserName;
    private JLabel lblPosition;
    private boolean selected = false;
    private String state = "A";
    boolean header = false;
    String queue = "";
    String userName = "";
    String company = "";
    String imePrezime = "";
    String pzUser = "";
    String remoteId = "";
    PnlKorisnik instance;
    PnlKorisnikSmaller smaller;
    Vector<PnlKorisnik> pnlPool = null;
    private JLabel label;
    private PnlIcons pnlIcons;
    Vector<String> actions;
    Vector<String> devices;
    private MouseAdapter ma;
    RightClickMenu rcm;

    public PnlKorisnik(Vector<PnlKorisnik> pnlPool, boolean header) {
        this.setSize(new Dimension(0, 50));
        this.setMinimumSize(new Dimension(10, 50));
        this.instance = this;
        this.setBackground(Color.WHITE);
        this.header = header;
        this.pnlPool = pnlPool;
        if (header) {
            this.setGradient(new Color(3, 103, 214), new Color(255, 255, 255), GRADIENT_NORTH_SOUTH);
            this.setPaintGradient(true);
        }
        this.ma = this.getClickAdapter();
        this.addMouseListener(this.ma);
        if (!this.isHeader()) {
            this.rcm = new RightClickMenu(this);
        }
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.setBorder(new MatteBorder(0, 0, 1, 0, new Color(192, 192, 192)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[4];
        nArray[0] = 27;
        nArray[1] = 10;
        nArray[2] = 58;
        gridBagLayout.columnWidths = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 25;
        nArray2[1] = 25;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.lblIconStatus = new JLabel("");
        this.lblIconStatus.setHorizontalAlignment(0);
        this.lblIconStatus.setIcon(new ImageIcon(PnlKorisnik.class.getResource("/rs/pezar/msg/widget/resource/green.png")));
        GridBagConstraints gbc_lblIconStatus = new GridBagConstraints();
        gbc_lblIconStatus.fill = 1;
        gbc_lblIconStatus.insets = new Insets(0, 0, 5, 5);
        gbc_lblIconStatus.gridx = 0;
        gbc_lblIconStatus.gridy = 0;
        this.add(this.lblIconStatus, gbc_lblIconStatus);
        this.lblUserName = new JLabel("Korisnik Korisnikovic");
        this.lblUserName.setPreferredSize(new Dimension(0, 0));
        this.lblUserName.setMinimumSize(new Dimension(10, 10));
        this.lblUserName.setFont(new Font("Tahoma", 1, 11));
        GridBagConstraints gbc_lblUserName = new GridBagConstraints();
        gbc_lblUserName.gridwidth = 2;
        gbc_lblUserName.fill = 1;
        gbc_lblUserName.insets = new Insets(0, 0, 5, 5);
        gbc_lblUserName.gridx = 1;
        gbc_lblUserName.gridy = 0;
        this.add(this.lblUserName, gbc_lblUserName);
        this.lblPosition = new JLabel("Glavni baja u firmi");
        this.lblPosition.setPreferredSize(new Dimension(0, 0));
        this.lblPosition.setMinimumSize(new Dimension(10, 10));
        this.lblPosition.setFont(new Font("Tahoma", 2, 11));
        GridBagConstraints gbc_lblPosition = new GridBagConstraints();
        gbc_lblPosition.fill = 1;
        gbc_lblPosition.insets = new Insets(0, 0, 0, 5);
        gbc_lblPosition.gridx = 1;
        gbc_lblPosition.gridy = 1;
        this.add(this.lblPosition, gbc_lblPosition);
        this.pnlIcons = new PnlIcons(this);
        this.pnlIcons.setBorder(new EmptyBorder(0, 0, 0, 3));
        this.pnlIcons.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.pnlIcons.setMinimumSize(new Dimension(10, 10));
        GridBagConstraints gbc_pnlIcons = new GridBagConstraints();
        gbc_pnlIcons.fill = 1;
        gbc_pnlIcons.gridx = 2;
        gbc_pnlIcons.gridy = 1;
        this.add((Component)((Object)this.pnlIcons), gbc_pnlIcons);
        if (header) {
            this.label = new JLabel("");
            this.label.setIconTextGap(10);
            this.label.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    PnlKorisnik.this.onSettingsClicked();
                }
            });
            this.label.setHorizontalTextPosition(0);
            this.label.setHorizontalAlignment(0);
            this.label.setIcon(new ImageIcon(PnlKorisnik.class.getResource("/rs/pezar/msg/widget/resource/gear_small.png")));
            GridBagConstraints gbc_label = new GridBagConstraints();
            gbc_label.anchor = 13;
            gbc_label.fill = 3;
            gbc_label.insets = new Insets(0, 0, 5, 0);
            gbc_label.gridx = 2;
            gbc_label.gridy = 0;
            this.add(this.label, gbc_label);
        }
        this.smaller = new PnlKorisnikSmaller();
        this.smaller.setStatus(this.state);
        this.smaller.setText(this.lblUserName.getText());
    }

    public void setUserName(String user) {
        this.userName = user;
        this.pzUser = StringUtils.substringBefore((String)user, (String)"(");
        this.imePrezime = StringUtils.substringBetween((String)user, (String)"(", (String)")");
        if (this.imePrezime != null && this.imePrezime.length() == 0) {
            this.imePrezime = "[" + this.pzUser + "]";
        }
        this.lblUserName.setText(this.imePrezime);
        this.smaller.setText(this.imePrezime);
    }

    public boolean isHeader() {
        return this.header;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRemoteId() {
        return this.remoteId;
    }

    public void setRemoteId(String remoteId) {
        this.remoteId = remoteId;
        this.pnlIcons.updateRemoteId(remoteId);
    }

    private void onSettingsClicked() {
        PnlSettings.showChatSettings();
    }

    public void setStatus(String status) {
        if (status == null || status.equals(this.state)) {
            return;
        }
        String icon = "";
        if (status.equals("A")) {
            icon = "/rs/pezar/msg/widget/resource/green.png";
            this.lblPosition.setEnabled(true);
            this.lblUserName.setEnabled(true);
            this.smaller.setEnabled(true);
            this.pnlIcons.setEnabled(true);
            this.state = "A";
            this.lblIconStatus.setToolTipText("Dostupan");
        } else if (status.equals("I")) {
            icon = "/rs/pezar/msg/widget/resource/yellow.png";
            this.lblPosition.setEnabled(true);
            this.lblUserName.setEnabled(true);
            this.pnlIcons.setEnabled(true);
            this.state = "I";
            this.lblIconStatus.setToolTipText("Nije pored ra\u010dunara");
        } else if (status.equals("O")) {
            icon = "/rs/pezar/msg/widget/resource/gray.png";
            this.lblPosition.setEnabled(false);
            this.lblUserName.setEnabled(false);
            this.pnlIcons.setEnabled(false);
            this.smaller.setEnabled(false);
            this.state = "O";
            this.lblIconStatus.setToolTipText("Nedostupan");
        } else if (status.equals("B")) {
            icon = "/rs/pezar/msg/widget/resource/red.png";
            this.lblPosition.setEnabled(true);
            this.lblUserName.setEnabled(true);
            this.pnlIcons.setEnabled(true);
            this.state = "B";
            this.lblIconStatus.setToolTipText("Zauzet");
        } else if (status.equals("W")) {
            icon = "/rs/pezar/msg/widget/resource/blue.png";
            this.lblPosition.setEnabled(true);
            this.lblUserName.setEnabled(true);
            this.pnlIcons.setEnabled(true);
            this.state = "W";
            this.lblIconStatus.setToolTipText("Odsutan");
        }
        this.lblIconStatus.setIcon(new ImageIcon(PnlKorisnik.class.getResource(icon)));
        this.smaller.setStatus(this.state);
        this.repaint();
    }

    public void setPosition(String position) {
        this.lblPosition.setText(position);
    }

    public String getStatus() {
        return this.state;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.setBackground(new Color(45, 66, 255));
            this.lblPosition.setForeground(new Color(255, 255, 255));
            this.lblUserName.setForeground(new Color(255, 255, 255));
        } else {
            this.setBackground(Color.WHITE);
            this.lblPosition.setForeground(new Color(0, 0, 0));
            this.lblUserName.setForeground(new Color(0, 0, 0));
        }
        this.setActions(this.actions);
        this.selected = selected;
    }

    public void setUserQueue(String queue) {
        this.queue = queue;
    }

    public void setActions(Vector<String> actions) {
        this.actions = actions;
        this.pnlIcons.updateActions(actions);
    }

    public void setDevices(Vector<String> devices) {
        this.devices = devices;
        this.pnlIcons.updateDevices(devices);
    }

    public String getUserQueue() {
        return this.queue;
    }

    public Vector<String> getDevices() {
        return this.devices;
    }

    public Vector<String> getActions() {
        return this.actions;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.lblUserName.setText(String.valueOf(this.imePrezime) + " @ " + company);
        this.smaller.setText(this.lblUserName.getText());
        this.company = company;
    }

    public synchronized void onDoubleClicked() {
        MsgProtocol msgProtocol = PzExtensionLoader.getInstance().getMsgProtocol();
        if (msgProtocol != null) {
            TextMessageReceiverInterface receiver = msgProtocol.getMessageReceiver();
            if (receiver != null) {
                receiver.createNewMessageWindow(this.queue.replace("queue.", ""));
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Chat klijent nije aktivan.", "Uups", 1);
            }
        }
    }

    public MouseAdapter getClickAdapter() {
        if (this.ma != null) {
            return this.ma;
        }
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (arg0.getButton() == 3) {
                    PnlKorisnik.this.showPopup(arg0);
                }
                if (!PnlKorisnik.this.header) {
                    int i = 0;
                    while (i < PnlKorisnik.this.pnlPool.size()) {
                        PnlKorisnik.this.pnlPool.get(i).setSelected(false);
                        ++i;
                    }
                    if (PnlKorisnik.this.selected) {
                        PnlKorisnik.this.setSelected(false);
                    } else {
                        PnlKorisnik.this.setSelected(true);
                    }
                }
                if (arg0.getClickCount() > 1 && !PnlKorisnik.this.header) {
                    PnlKorisnik.this.onDoubleClicked();
                }
            }
        };
    }

    private void showPopup(MouseEvent e) {
        if (this.rcm != null) {
            this.rcm.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public PnlKorisnikSmaller getSmaller() {
        return this.smaller;
    }
}

