/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.service.stanja.preracunKolicina;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.jdesktop.swingx.JXTable;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzEntityManager;
import rs.pezar.db.PzEntityManagerFactory;
import rs.pezar.db.commons.PzParameter;
import rs.pezar.db.entity.Radnajedinica;
import rs.pezar.sifarnici.util.AnalitikaHelper;
import rs.pezar.swing.PzBusyPainterUI;
import rs.pezar.swing.PzDialog;
import rs.pezar.swing.PzGenericTableDialog;
import rs.pezar.swing.PzPanel;
import rs.pezar.swing.PzPanelHeader;
import rs.pezar.swing.exceptionhandlers.PzMysqlExceptionHandler;
import rs.pezar.swing.util.PzSwingUtility;

public class PzDialogPreracunKolicina
extends PzDialog {
    private static final long serialVersionUID = 9122292667234523951L;
    private PzPanel pnlContent;
    private JScrollPane scp;
    private JButton btnPrikazi;
    private PzPanel pnlButtons;
    private JXTable table;
    private PzPanelHeader header;
    private JButton btnIzniveliiKoliine;
    private JButton btnKartica;
    private PzBusyPainterUI layerUI;
    private JXLayer<PzPanel> layer;
    private ArrayList<String> oznake;
    private Object[][] array;
    protected Boolean kolVred;
    protected List<Radnajedinica> radnejedinice;

    public PzDialogPreracunKolicina(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.pnlContent = new PzPanel();
            GridBagLayout pnlContentLayout = new GridBagLayout();
            pnlContentLayout.rowWeights = new double[]{0.0, 0.1, 0.0};
            pnlContentLayout.rowHeights = new int[]{7, 7, 7};
            pnlContentLayout.columnWeights = new double[]{0.1};
            pnlContentLayout.columnWidths = new int[]{7};
            this.pnlContent.setLayout((LayoutManager)pnlContentLayout);
            this.layerUI = new PzBusyPainterUI();
            this.layer = new JXLayer((Component)this.pnlContent, (LayerUI)this.layerUI);
            this.getContentPane().add((Component)this.layer, "Center");
            this.header = new PzPanelHeader();
            this.header.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getClassLoader().getResource("rs/pezar/service/stanja/resource/img/calculator.png")));
            this.header.setTitle("Prera\u010dun koli\u010dina");
            this.header.setText("Prera\u010dun stanja koli\u010dina na svim radnim jedinicama");
            this.pnlContent.add((Component)this.header, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.scp = new JScrollPane();
            this.pnlContent.add((Component)this.scp, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
            this.pnlButtons = new PzPanel();
            this.pnlContent.add((Component)this.pnlButtons, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.btnPrikazi = new JButton("Prika\u017ei neslaganja");
            this.btnPrikazi.addActionListener((ActionListener)((Object)this));
            this.btnPrikazi.setActionCommand("prikazi");
            this.btnPrikazi.setIcon(new ImageIcon(PzDialogPreracunKolicina.class.getResource("/rs/pezar/service/stanja/resource/img/view.png")));
            this.pnlButtons.add((Component)this.btnPrikazi);
            this.btnIzniveliiKoliine = new JButton("Izniveli\u0161i koli\u010dine");
            this.btnIzniveliiKoliine.addActionListener((ActionListener)((Object)this));
            this.btnIzniveliiKoliine.setActionCommand("iznivelisi");
            this.btnIzniveliiKoliine.setIcon(new ImageIcon(PzDialogPreracunKolicina.class.getResource("/rs/pezar/service/stanja/resource/img/checks.png")));
            this.pnlButtons.add((Component)this.btnIzniveliiKoliine);
            this.btnKartica = new JButton("Kartica artikla");
            this.btnKartica.setIcon(new ImageIcon(PzDialogPreracunKolicina.class.getResource("/rs/pezar/service/stanja/resource/img/checks.png")));
            this.pnlButtons.add((Component)this.btnKartica);
            this.btnKartica.addActionListener((ActionListener)((Object)this));
            this.btnKartica.setActionCommand("kartica");
            this.setSize(453, 560);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void trazi() {
        this.layerUI.setLocked(true);
        SwingWorker<List<Object[]>, Object> worker = new SwingWorker<List<Object[]>, Object>(){

            @Override
            protected List<Object[]> doInBackground() throws Exception {
                EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                PzDialogPreracunKolicina.this.kolVred = PzParameter.getBoolean((String)"KOLICINE_U_VRED_PROD", (boolean)Boolean.FALSE);
                PzDialogPreracunKolicina.this.radnejedinice = em.createQuery("SELECT r FROM Radnajedinica r WHERE r.gTip='E' AND r.pTip='V'").getResultList();
                Vector<Object[]> res = new Vector<Object[]>();
                List ukList = em.createNativeQuery(PzDialogPreracunKolicina.this.createQueryUkupna()).getResultList();
                List alocList = em.createNativeQuery(PzDialogPreracunKolicina.this.createQueryAlocirana()).getResultList();
                List stNullList = em.createNativeQuery(PzDialogPreracunKolicina.this.createQueryStanjeNull()).getResultList();
                res.addAll(ukList);
                res.addAll(alocList);
                res.addAll(stNullList);
                em.close();
                return res;
            }

            @Override
            protected void done() {
                try {
                    List res = (List)this.get();
                    ArrayList<Object[]> prikaz = new ArrayList<Object[]>();
                    if (res.size() == 0) {
                        return;
                    }
                    try {
                        for (Object[] objects : res) {
                            BigDecimal kolStanje;
                            BigDecimal kolPreracun = objects[3] instanceof BigDecimal ? (BigDecimal)objects[3] : BDConverter.getKolicina((double)((Double)objects[3]));
                            BigDecimal bigDecimal = kolStanje = objects[4] instanceof BigDecimal ? (BigDecimal)objects[4] : BDConverter.getKolicina((double)((Double)objects[4]));
                            if (kolPreracun.compareTo(kolStanje) == 0) continue;
                            if (!PzDialogPreracunKolicina.this.isVrednosnaMaloprodaja((String)objects[0])) {
                                prikaz.add(objects);
                                continue;
                            }
                            if (!PzDialogPreracunKolicina.this.kolVred.booleanValue()) continue;
                            prikaz.add(objects);
                        }
                        PzDialogPreracunKolicina.this.array = new Object[prikaz.size()][4];
                        int i = 0;
                        while (i < prikaz.size()) {
                            ((PzDialogPreracunKolicina)PzDialogPreracunKolicina.this).array[i] = (Object[])prikaz.get(i);
                            ++i;
                        }
                        DefaultTableModel model = new DefaultTableModel();
                        model.setDataVector(PzDialogPreracunKolicina.this.array, new String[]{"RJ", "\u0160ifra", "Naziv", "Sumirana koli\u010dina", "Zate\u010dena koli\u010dina", "Vrsta"});
                        if (PzDialogPreracunKolicina.this.table == null) {
                            PzDialogPreracunKolicina.this.table = new JXTable();
                            PzDialogPreracunKolicina.this.table.setModel((TableModel)model);
                            PzDialogPreracunKolicina.this.scp.setViewportView((Component)PzDialogPreracunKolicina.this.table);
                        } else {
                            PzDialogPreracunKolicina.this.table.setModel((TableModel)model);
                        }
                        PzDialogPreracunKolicina.this.table.packAll();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Component)((Object)PzDialogPreracunKolicina.this), (Throwable)e);
                    }
                }
                finally {
                    PzDialogPreracunKolicina.this.layerUI.setLocked(false);
                }
            }
        };
        worker.execute();
    }

    private void kartica() {
        if (this.table == null || this.table.getSelectedRow() == -1) {
            return;
        }
        AnalitikaHelper.getInstance().getHelper().karticaArtikla((PzDialog)this, (String)this.table.getValueAt(this.table.getSelectedRow(), 1), "1", (String)this.table.getValueAt(this.table.getSelectedRow(), 0));
    }

    private String createQueryStanjeNull() {
        return "SELECT DISTINCT d.oznRj, a.sfrProizvod, a.naziv, -1.00, 0.00, 'STNULL' FROM Artikaldokument a, Dokument d WHERE a.idDok = d.idDok and d.arhiviran=1 AND (a.vrsta='I' OR a.vrsta='U') AND NOT EXISTS(SELECT s.* FROM Stanje s WHERE s.sfrProizvod=a.sfrProizvod and s.oznRj = d.oznRj ) ";
    }

    private String createQueryUkupna() {
        return "SELECT s.oznRj,a.sfrProizvod,a.naziv,(CASE WHEN t.oznTarGr NOT LIKE 'U%' THEN (COALESCE(sum(CASE WHEN ((au.vrsta='U' AND d.storno=0) OR (au.vrsta='I' AND d.storno=1))  THEN au.kolicina ELSE 0 END) - sum(CASE WHEN ((au.vrsta='I' AND d.storno=0) OR (au.vrsta='U' AND d.storno=1))  THEN au.kolicina ELSE 0 END), 0) + COALESCE(s.kolPop, 0)) ELSE 0 END),COALESCE(s.kolicina, 0),'UK' FROM (((Artikal a LEFT JOIN Stanje s ON a.sfrProizvod=s.sfrProizvod) LEFT JOIN TGArtikal t ON s.sfrProizvod=t.sfrProizvod) LEFT JOIN ArtikalDokument au ON s.sfrProizvod = au.sfrProizvod) LEFT JOIN Dokument d ON au.idDok = d.idDok AND d.oznRj=s.oznRj AND d.arhiviran = 1 GROUP BY a.sfrProizvod,a.naziv,s.kolicina,s.kolPop,s.oznRj,t.oznTarGr ORDER BY s.oznRj,a.sfrProizvod";
    }

    private String createQueryAlocirana() {
        boolean nalog = false;
        try {
            nalog = PzParameter.getBoolean((String)"INT_NAL_FORM_ALOC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "(SELECT * FROM ( SELECT s.oznRj, a.sfrProizvod, a.naziv, COALESCE(SUM(pfr.kolicina), 0) + COALESCE(SUM(CASE WHEN (f.storno=1 AND f.tip='OTPREMNICA') THEN af.kolicina*(-1) ELSE af.kolicina END), 0) + COALESCE(SUM(aod.kolicina), 0) " + (nalog ? "+COALESCE(SUM(air.kolicina), 0)" : "") + " AS sumKolicina, " + "s.alocKolicina," + "CAST('ALOC' as VARCHAR)" + " FROM " + "Artikal a, " + "Radnajedinica rj LEFT JOIN Stanje s on rj.oznRj=s.oznRj and rj.gTip<>'T'" + "LEFT JOIN (ProizvodFiskalniRacun pfr LEFT JOIN FiskalniRacun fr ON pfr.idDok = fr.idDok) ON s.sfrProizvod = pfr.sfrProizvod AND s.oznRj = fr.oznRj AND fr.arhiviran=0 " + "LEFT JOIN (ArtikalFaktura af LEFT JOIN Faktura f ON af.idDok = f.idDok) ON s.sfrProizvod = af.sfrProizvod AND s.oznRj = f.oznRj AND ((f.arhiviran=0 AND f.tip IN ('FAKTURA', 'PRENOSNICA_SA_KONSIGNACIJE')) OR (f.tip='OTPREMNICA' AND f.faktura IS NULL AND f.arhiviran<>-1)) " + "LEFT JOIN (ArtikalOpstiDokument aod LEFT JOIN OpstiDokument od ON aod.idDok = od.idDok) ON s.sfrProizvod = aod.sfrProizvod AND s.oznRj = od.oznRj AND od.arhiviran=0 AND od.tip='FISKALNI_IZVESTAJ' " + (nalog ? "LEFT JOIN (ArtikalInterniRacun air LEFT JOIN InterniRacun ir ON ir.idDok = air.idDok) ON s.sfrProizvod = air.sfrProizvod AND s.oznRj=ir.izlaznaRJ AND ir.arhiviran=0 and ir.tip='INTERNI_NALOG' " : "") + " WHERE a.sfrProizvod=s.sfrProizvod GROUP BY a.sfrProizvod, s.alocKolicina, a.naziv, s.oznRj " + ") x " + " WHERE x.sumKolicina <> x.alocKolicina" + " ORDER BY " + "x.oznRj," + "x.sfrProizvod) " + " UNION " + "(select * from ( " + "select" + "\ts.oznrj, " + "\ts.sfrproizvod , " + "\tCAST('' as VARCHAR) as naziv, " + "\tsum(coalesce(a.kolsakons, 0))+coalesce((select sum(kolicina) from artikalfaktura a1, faktura f1 where a1.sfrproizvod=s.sfrproizvod and a1.iddok=f1.iddok and f1.tip in ('FAKTURA', 'OTPREMNICA') and f1.arhiviran=0 and f1.oznrj=s.oznrj),0) as suma, " + "\ts.alockolicina," + "\tCAST('ALOC' as VARCHAR) " + "FROM " + "((radnajedinica rj left join stanje s on rj.oznrj=s.oznrj and rj.gtip='T') left join " + "\t(artikalfaktura a right join faktura f on a.iddok=f.iddok and f.arhiviran=1 and f.storno=0) on s.sfrproizvod=a.sfrproizvod and s.oznrj=a.konsignacija and a.kolsakons>0 and a.indp=0) " + "group by" + "\ts.sfrproizvod," + "\ts.oznrj," + "\ts.alockolicina " + "order by" + "\ts.oznrj," + "\ts.sfrproizvod" + ") res " + "where " + "\tsuma<>alockolicina)";
    }

    public void actionPerformed(ActionEvent e) {
        String command = ((JButton)e.getSource()).getActionCommand();
        if (command.equals("prikazi")) {
            this.trazi();
        } else if (command.equals("kartica")) {
            this.kartica();
        } else if (command.equals("iznivelisi")) {
            this.iznivelisi();
        }
    }

    private void iznivelisi() {
        int choice = PzSwingUtility.daNeDijalog((Component)((Object)this), (Object)"Ova opcija \u0107e prepisati zate\u010dene koli\u010dine prera\u010dunatim. Da li ste sigurni da to \u017eelite?", (String)"Azuriranje koli\u010dina", null, (boolean)true);
        if (choice != 0) {
            return;
        }
        try {
            List rj = PzGenericTableDialog.showDialog((PzDialog)this, Radnajedinica.class, (List)PzEntityManager.selectAll(Radnajedinica.class), (String)"Izbor radnih jedinica", (String)"Izaberite radne jedinice iz kojih se uzimaju kolicine", (int)0, null);
            if (rj == null || rj.size() == 0) {
                return;
            }
            this.layerUI.setLocked(true);
            this.oznake = new ArrayList();
            for (Radnajedinica radnajedinica : rj) {
                this.oznake.add(radnajedinica.getId().getOznRj());
            }
            SwingWorker<Object, Object> worker = new SwingWorker<Object, Object>(){

                @Override
                protected Object doInBackground() throws Exception {
                    EntityManager em = PzEntityManagerFactory.getInstance().createEm();
                    try {
                        em.getTransaction().begin();
                        int i = 0;
                        while (i < PzDialogPreracunKolicina.this.array.length) {
                            String vrsta = (String)PzDialogPreracunKolicina.this.array[i][5];
                            if (!vrsta.equals("STNULL")) {
                                String polje;
                                String string = polje = vrsta.equals("UK") ? "s.kolicina" : "s.alocKolicina";
                                if (PzDialogPreracunKolicina.this.oznake.contains(PzDialogPreracunKolicina.this.array[i][0])) {
                                    em.createQuery("UPDATE Stanje s SET " + polje + " = :kol WHERE s.id.oznRj=:rj AND s.id.sfrProizvod=:sfr").setParameter("kol", (Object)BDConverter.getKolicina((double)((Double)PzDialogPreracunKolicina.this.array[i][3]))).setParameter("rj", PzDialogPreracunKolicina.this.array[i][0]).setParameter("sfr", PzDialogPreracunKolicina.this.array[i][1]).executeUpdate();
                                }
                            }
                            ++i;
                        }
                        em.getTransaction().commit();
                    }
                    catch (Exception e) {
                        if (em.getTransaction().isActive()) {
                            em.getTransaction().rollback();
                        }
                        throw e;
                    }
                    return null;
                }

                @Override
                protected void done() {
                    try {
                        this.get();
                        PzDialogPreracunKolicina.this.trazi();
                    }
                    catch (Exception e) {
                        PzMysqlExceptionHandler.handle((Throwable)e);
                        PzDialogPreracunKolicina.this.layerUI.setLocked(false);
                    }
                }
            };
            worker.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isVrednosnaMaloprodaja(String oznrj) {
        boolean found = false;
        Iterator<Radnajedinica> iterator = this.radnejedinice.iterator();
        while (iterator.hasNext() && !found) {
            Radnajedinica rj = iterator.next();
            if (!rj.getId().getOznRj().equals(oznrj)) continue;
            found = true;
        }
        return found;
    }
}

