/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Date;
import org.xBaseJ.DBF;
import org.xBaseJ.Util;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class DateField
extends Field {
    private static final long serialVersionUID = 1L;
    private Calendar value;

    @Override
    public Object clone() throws CloneNotSupportedException {
        DateField tField = (DateField)super.clone();
        tField.Name = this.Name;
        tField.Length = 8;
        return tField;
    }

    public DateField(String iName, ByteBuffer inBuffer) throws xBaseJException {
        super.setField(iName, 8, inBuffer);
    }

    public DateField(String iName) throws IOException, xBaseJException {
        super.setField(iName, 8, null);
        this.put("");
    }

    private DateField() throws xBaseJException {
        this.Length = 8;
        this.buffer = new byte[this.Length];
        this.put("");
    }

    @Override
    public char getType() {
        return 'D';
    }

    @Override
    public void put(String inValue) throws xBaseJException {
        if (!Util.dontTrimFields()) {
            inValue = inValue.trim();
        }
        boolean allspaces = true;
        int i = 0;
        while (i < inValue.length()) {
            if (inValue.charAt(i) != ' ') {
                allspaces = false;
            }
            ++i;
        }
        int blankbyte = 32;
        if (inValue.length() == 0 || allspaces) {
            i = 0;
            while (i < 8) {
                this.buffer[i] = blankbyte;
                ++i;
            }
            return;
        }
        if (inValue.length() != 8) {
            throw new xBaseJException("Invalid length for date Field");
        }
        i = 0;
        while (i < 8) {
            if (!Character.isDigit(inValue.charAt(i))) {
                throw new xBaseJException("Invalid format for date Field, " + inValue + " non numeric at position " + i);
            }
            ++i;
        }
        int yea = Integer.parseInt(inValue.substring(0, 4));
        int mo = Integer.parseInt(inValue.substring(4, 6));
        if (mo < 1 || mo > 12) {
            throw new xBaseJException("Invalid format for date Field (month) " + inValue);
        }
        int da = Integer.parseInt(inValue.substring(6, 8));
        if (da < 1) {
            throw new xBaseJException("Invalid format for date Field (day) " + inValue);
        }
        int[] nArray = new int[13];
        nArray[1] = 31;
        nArray[2] = 28;
        nArray[3] = 31;
        nArray[4] = 30;
        nArray[5] = 31;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 31;
        nArray[9] = 30;
        nArray[10] = 31;
        nArray[11] = 30;
        nArray[12] = 31;
        int[] month = nArray;
        if (yea == 2000 || yea % 4 == 0 && yea % 100 != 0) {
            month[2] = month[2] + 1;
        }
        if (da > month[mo]) {
            throw new xBaseJException("Invalid format for date Field, number of days > days in month");
        }
        super.put(inValue);
    }

    public void put(Date inValue) throws xBaseJException {
        this.value.setTime(inValue);
        this.put(this.value);
    }

    public void put(Calendar inValue) throws xBaseJException {
        super.put(String.valueOf(inValue.get(1) * 10000 + (inValue.get(2) + 1) * 100 + inValue.get(5)));
    }

    public void put(long inValue) throws xBaseJException {
        this.put(Long.toString(inValue));
    }

    public int compareTo(DateField compareThis) {
        return this.get().compareTo(compareThis.get());
    }

    public int compareTo(Calendar compareThis) throws xBaseJException {
        DateField compareDateField = new DateField();
        compareDateField.put(compareThis);
        return this.compareTo(compareDateField);
    }

    public Calendar getCalendar() throws xBaseJException {
        Calendar getter = Calendar.getInstance();
        getter.set(1, Integer.parseInt(this.get(1)));
        getter.set(2, Integer.parseInt(this.get(2)) - 1);
        getter.set(5, Integer.parseInt(this.get(5)));
        return getter;
    }

    public String get(int field) throws xBaseJException {
        switch (field) {
            case 1: {
                return new String(this.buffer, 0, 4);
            }
            case 2: {
                return new String(this.buffer, 4, 2);
            }
            case 5: {
                return new String(this.buffer, 6, 2);
            }
        }
        throw new xBaseJException("Field type invalid");
    }

    public void set(int field, int value) throws xBaseJException {
        NumberFormat numFormat = NumberFormat.getNumberInstance();
        switch (field) {
            case 1: {
                byte[] byter;
                numFormat.setMinimumIntegerDigits(4);
                numFormat.setMaximumIntegerDigits(4);
                String setter = numFormat.format(value);
                try {
                    byter = setter.getBytes(DBF.encodedType);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    byter = setter.getBytes();
                }
                this.buffer[0] = byter[0];
                this.buffer[1] = byter[1];
                this.buffer[2] = byter[2];
                this.buffer[3] = byter[3];
                break;
            }
            case 2: {
                if (value < 1 || value > 12) {
                    throw new xBaseJException("Month value out of range");
                }
                numFormat.setMinimumIntegerDigits(2);
                numFormat.setMaximumIntegerDigits(2);
                String setter = numFormat.format(value);
                byte[] byter = setter.getBytes();
                this.buffer[4] = byter[0];
                this.buffer[5] = byter[1];
                break;
            }
            case 5: {
                if (value < 1 || value > 31) {
                    throw new xBaseJException("Day value out of range");
                }
                numFormat.setMinimumIntegerDigits(2);
                numFormat.setMaximumIntegerDigits(2);
                String setter = numFormat.format(value);
                byte[] byter = setter.getBytes();
                this.buffer[6] = byter[0];
                this.buffer[7] = byter[1];
                break;
            }
            default: {
                throw new xBaseJException("Field type invalid");
            }
        }
    }
}

