/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormatSymbols;
import org.xBaseJ.fields.NumField;
import org.xBaseJ.xBaseJException;

public class FloatField
extends NumField {
    private static final long serialVersionUID = 1L;
    private byte decPosition = 0;
    static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    static char decimalSeparator = dfs.getDecimalSeparator();

    public FloatField() {
    }

    public FloatField(String iName, int iLength, int DecPoint, ByteBuffer inBuffer) throws xBaseJException {
        super(iName, iLength, DecPoint, inBuffer);
        this.decPosition = (byte)DecPoint;
    }

    public FloatField(String iName, int iLength, int DecPoint) throws xBaseJException, IOException {
        super(iName, iLength, DecPoint);
        this.decPosition = (byte)DecPoint;
    }

    @Override
    public char getType() {
        return 'F';
    }

    @Override
    public void put(String inValue) throws xBaseJException {
        boolean signOn = false;
        if (inValue.trim().length() == 0) {
            super.put("");
            return;
        }
        int i = 0;
        while (i < inValue.length()) {
            if (inValue.charAt(i) == '-') {
                signOn = true;
            }
            if (Character.isDigit(inValue.charAt(i)) || inValue.charAt(i) == decimalSeparator) break;
            ++i;
        }
        if (i == inValue.length()) {
            super.put(" ");
            return;
        }
        int start = i;
        while (i < inValue.length()) {
            if (!Character.isDigit(inValue.charAt(i)) && inValue.charAt(i) != decimalSeparator) break;
            ++i;
        }
        String workstring = inValue.substring(start, i);
        char[] charray = new char[this.Length];
        Double inDouble = new Double(workstring);
        double duble = inDouble;
        i = 0;
        while (i < this.decPosition) {
            duble *= 10.0;
            ++i;
        }
        inDouble = new Double(duble);
        long longv = inDouble.longValue();
        if (longv < 0L) {
            longv *= -1L;
            signOn = true;
        }
        int realdp = this.Length - this.decPosition;
        String numstring = new String("0123456789");
        i = this.Length;
        while (i > 0) {
            if (realdp == i && this.decPosition > 0) {
                charray[i - 1] = 46;
            } else {
                long longleft = longv % 10L;
                int whatsleft = (int)longleft;
                if (whatsleft < 0) {
                    whatsleft *= -1;
                }
                charray[i - 1] = numstring.charAt(whatsleft);
                longv /= 10L;
            }
            --i;
        }
        if (signOn) {
            charray[0] = 45;
        }
        i = 0;
        while (i < charray.length - 1) {
            if (charray[i] != '0') break;
            charray[i] = 32;
            ++i;
        }
        super.put(new String(charray).replace(decimalSeparator, '.'));
    }

    @Override
    public void put(long inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    @Override
    public void put(int inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    @Override
    public void put(float inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    @Override
    public void put(double inValue) throws xBaseJException {
        double d = inValue;
        double d10 = Math.pow(10.0, this.Length - this.decPosition);
        d %= d10;
        d10 = Math.pow(0.1, this.decPosition + 1);
        if (d > 0.0) {
            d += d10;
        }
        if (d < 0.0) {
            d -= d10;
        }
        this.put(String.valueOf(d));
    }
}

