/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Vector;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.Transformer.HCPTransformer;
import rs.pezar.kasa.databaseEngine.DatabaseEngine;
import rs.pezar.kasa.databaseEngine.DatabaseFunctions;
import rs.pezar.kasa.putGetEngine.PutGetInterface;
import rs.pezar.kasa.putGetEngine.filesystem.DataGetter;
import rs.pezar.kasa.putGetEngine.filesystem.PutGetEngine;
import rs.pezar.kasa.putGetEngine.socket.PutGetEngineSocket;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.cashregister.data.CashRegisterControl;
import rs.pezar.msg.device.cashregister.data.DeviceData;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegisterControlInterface;

public class HCPResidentialService {
    public static final String BILL_TYPE = "BILL_TYPE";
    public static final String CONTROL_TYPE = "CONTROL_TYPE";
    public static final String ARTICLE_TYPE = "ARTICLE_TYPE";
    public static final String BASE_NAME = "HCPDB";
    public static final String WORKING_SUBFOLDER = "HCP";
    public static final String REQUIRED_VERSION = "ver.5.03";
    private PutGetInterface putGetEngine;
    private DatabaseEngine databaseEngine;
    private Integer maxPLU;
    private String addTempArticleBeforeOrAfter;
    private static HCPResidentialService instance;

    public HCPResidentialService(HashMap<String, String> params) throws UnknownHostException, IOException {
        String socketMode = params.get("PARAM3");
        this.putGetEngine = socketMode.equals("YES") ? new PutGetEngineSocket(params) : new PutGetEngine(params);
        this.maxPLU = params.get("PARAM4") != null ? Integer.parseInt(params.get("PARAM4")) : 15000;
        this.addTempArticleBeforeOrAfter = params.get("PARAM5") != null ? params.get("PARAM5") : "BEFORE";
        instance = this;
    }

    public void run() throws Exception {
        String workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        this.databaseEngine = new DatabaseEngine(workingFolder, WORKING_SUBFOLDER, BASE_NAME);
    }

    public HashMap<String, String> runWithTheBill(DeviceDataInterface data) {
        Vector returnData = new Vector();
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        try {
            if (bill.isPreBill()) {
                result.put("CODE", "ERROR");
                result.put("MESSAGE", "Greska! Ova funkcija jos uvek nije implementirana.");
            } else {
                String hcpArt = HCPTransformer.transformArticle(data);
                System.out.println(hcpArt);
                restemp = this.putGetEngine.putGet(hcpArt, ARTICLE_TYPE);
                result = this.formatReturnedData(restemp, result);
                String hcpBill = HCPTransformer.transformBill(data);
                System.out.println(hcpBill);
                restemp = this.putGetEngine.putGet(hcpBill, BILL_TYPE);
                result = this.formatReturnedData(restemp, result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.put("MESSAGE", e.getMessage());
            result.put("CODE", "ERROR");
        }
        if (result.get("CODE") == null) {
            result.put("CODE", "SUCCESS");
            int i = 0;
            while (i < returnData.size()) {
                result.put("MESSAGE", (String)returnData.elementAt(i));
                ++i;
            }
        }
        String error1 = restemp.get(DataGetter.INFO_COMM_ERROR) == null ? "" : restemp.get(DataGetter.INFO_COMM_ERROR);
        String error2 = restemp.get(DataGetter.INFO_NOPAPER) == null ? "" : restemp.get(DataGetter.INFO_NOPAPER);
        result.put("INFO", "L|" + error1 + ";" + error2);
        return result;
    }

    public DatabaseEngine getDatabaseEngine() {
        return this.databaseEngine;
    }

    public HashMap<String, String> runWithTheControl(DeviceDataInterface data) {
        CashRegisterControl cntrl = (CashRegisterControl)data.getData();
        HashMap<String, String> result = cntrl.getControlCode() == "CODE_DELETE_ALL_ART" ? this.deleteAllArticles(cntrl) : this.executeControl(cntrl);
        return result;
    }

    public HashMap<String, String> executeControl(CashRegisterControl cntrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        try {
            String tempControl = HCPTransformer.transformControl((CashRegisterControlInterface)cntrl);
            System.out.println(tempControl);
            restemp = this.putGetEngine.putGet(tempControl, CONTROL_TYPE);
            result = this.formatReturnedData(restemp, result);
        }
        catch (Exception e) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", e.getMessage());
        }
        String info = "L|OK.";
        info = String.valueOf(info) + result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    public HashMap<String, String> deleteAllArticles(CashRegisterControl cntrl) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, String> restemp = new HashMap();
        try {
            if (this.addTempArticleBeforeOrAfter.equalsIgnoreCase("BEFORE")) {
                this.addTempArticle();
            }
            this.putGetEngine.extendWaitTime(300000);
            DatabaseFunctions.dropTable(this.databaseEngine.getConnection(), BASE_NAME);
            String tempControl = HCPTransformer.transformControl((CashRegisterControlInterface)cntrl);
            System.out.println(tempControl);
            restemp = this.putGetEngine.putGet(tempControl, CONTROL_TYPE);
            result = this.formatReturnedData(restemp, result);
            if (this.addTempArticleBeforeOrAfter.equalsIgnoreCase("AFTER")) {
                this.addTempArticle();
            }
        }
        catch (Exception e) {
            result.put("CODE", "ERROR");
            result.put("MESSAGE", e.getMessage());
        }
        String info = "L|OK.";
        info = String.valueOf(info) + (String)result.get("INFO");
        result.put("INFO", info);
        return result;
    }

    private void addTempArticle() throws Exception {
        DeviceData data = new DeviceData();
        CashRegisterBill bill = new CashRegisterBill();
        Article article = new Article();
        article.setName("Temp artikal");
        article.setPLU(this.maxPLU);
        article.setTaxRate('d');
        article.setQuantity(new BigDecimal(1.0));
        article.setPrice(new BigDecimal(1.0));
        article.setSifra("" + this.maxPLU);
        bill.addArticle(article);
        data.setData((Object)bill);
        String hcpArt = HCPTransformer.transformArticle((DeviceDataInterface)data);
        this.putGetEngine.putGet(hcpArt, ARTICLE_TYPE);
    }

    private HashMap<String, String> formatReturnedData(HashMap<String, String> returnedData, HashMap<String, String> appender) {
        if (appender == null) {
            appender = new HashMap();
        }
        if (returnedData.containsKey(DataGetter.INFO_ERROR)) {
            String error1 = returnedData.get(DataGetter.INFO_COMM_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_COMM_ERROR);
            String error3 = returnedData.get(DataGetter.INFO_ERROR) == null ? "" : returnedData.get(DataGetter.INFO_ERROR);
            appender.put("CODE", "ERROR");
            appender.put("MESSAGE", error1 + "." + error3);
        }
        if (returnedData.containsKey(DataGetter.INFO_OK)) {
            returnedData.get(DataGetter.INFO_OK);
            appender.put("CODE", "SUCCESS");
            appender.put("MESSAGE", "OK");
        }
        if (returnedData.size() == 0) {
            appender.put("CODE", "ERROR");
            appender.put("MESSAGE", "HCP Residential Service ne vraca podatke, proverite da li ste upalili HCP-ov usluzni program i dobro podesili foldere za komunikaciju sa njim. Za podesavanje pogledajte uputstvo za HCPResidentialService!");
        }
        return appender;
    }

    public static HCPResidentialService getInstance() {
        return instance;
    }

    public static void setInstance(HCPResidentialService instance) {
        HCPResidentialService.instance = instance;
    }
}

