/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.Transformer;

import java.sql.Connection;
import java.util.Vector;
import rs.pezar.kasa.Control.HCPControl;
import rs.pezar.kasa.HCPResidentialService;
import rs.pezar.kasa.article.HCPArtHeader;
import rs.pezar.kasa.article.HCPArticleDefine;
import rs.pezar.kasa.bill.HCPBill;
import rs.pezar.kasa.bill.HCPBillHeader;
import rs.pezar.kasa.databaseEngine.DatabaseFunctions;
import rs.pezar.msg.device.cashregister.data.Article;
import rs.pezar.msg.device.cashregister.data.CashRegisterBill;
import rs.pezar.msg.device.interfaces.DeviceDataInterface;
import rs.pezar.msg.device.interfaces.cashRegister.BillInterface;
import rs.pezar.msg.device.interfaces.cashRegister.CashRegisterControlInterface;

public class HCPTransformer {
    public static String transformArticle(DeviceDataInterface data) throws Exception {
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        HCPTransformer.setPlus(bill.getArticles());
        String header = HCPArtHeader.getHeader();
        String artPart = HCPArticleDefine.getHcpArt(bill);
        String completeArt = String.format(header, artPart);
        return completeArt;
    }

    public static String transformBill(DeviceDataInterface data) throws Exception {
        CashRegisterBill bill = (CashRegisterBill)data.getData();
        HCPTransformer.setPlus(bill.getArticles());
        String header = HCPBillHeader.getHeader();
        String billPart = HCPBill.getHcpBill((BillInterface)bill);
        String completeBill = String.format(header, billPart);
        return completeBill;
    }

    public static String transformControl(CashRegisterControlInterface control) throws Exception {
        String temp = HCPControl.gethcpControl(control);
        return temp;
    }

    private static void setPlus(Vector<Article> articles) throws Exception {
        int i = 0;
        while (i < articles.size()) {
            if (articles.get(i).getPLU() == null) {
                String sifra = articles.get(i).getSifra();
                String naziv = articles.get(i).getName();
                Connection conn = HCPResidentialService.getInstance().getDatabaseEngine().getConnection();
                Integer pl = DatabaseFunctions.getPlu(conn, "HCPDB", sifra);
                String nazivIzBaze = DatabaseFunctions.getNaziv(conn, "HCPDB", sifra);
                if (nazivIzBaze != null && !naziv.equals(nazivIzBaze) && !naziv.equals(pl + " " + nazivIzBaze)) {
                    throw new Exception("U bazi postoji artikal sa razlicitim nazivom a istom sifrom, izpraznite i bazu i artikle iz stampaca.");
                }
                if (pl != null) {
                    articles.get(i).setPLU(pl);
                } else {
                    Integer maxPlu = DatabaseFunctions.getMaxPlu(conn, "HCPDB");
                    maxPlu = maxPlu + 1;
                    DatabaseFunctions.addNewData(conn, maxPlu, sifra, naziv, "HCPDB");
                    articles.get(i).setPLU(maxPlu);
                }
            }
            ++i;
        }
    }
}

