/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.article;

import java.math.BigDecimal;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import rs.pezar.msg.device.cashregister.data.Article;

public class HCPArticle {
    public static final String ART_PLU = "PLU";
    public static final String ART_DESC = "DESC";
    public static final String ART_TAX = "VAT";
    public static final String ART_BCR = "BCR";
    public static final String ART_PRC = "PRC";
    public static final String ART_DEP = "DEP";
    public static final String ART_UNIT = "MES";
    public static final String ART_QUANTITY = "AMN";
    public static final String ART_CMD = "CMD";
    static HashMap<String, String> taxRates = new HashMap();

    static {
        taxRates.put("A", "0");
        taxRates.put("G", "1");
        taxRates.put("D", "2");
        taxRates.put("d", "3");
        taxRates.put("E", "4");
        taxRates.put("Z", "5");
        taxRates.put("I", "6");
        taxRates.put("J", "7");
        taxRates.put("K", "8");
    }

    public static String getHcpArticleDefineFormat(Article article) throws Exception {
        String temp = "";
        String.valueOf(article.getPLU());
        String code = article.getSifra();
        String taxRate = taxRates.get(String.valueOf(article.getTaxRate()));
        String name = String.format("%s                                ", article.getName());
        name = name.substring(0, 30);
        String price = StringUtils.substringBefore((String)String.valueOf(article.getPrice().multiply(new BigDecimal(100))), (String)".");
        String quantity = String.valueOf(article.getQuantity());
        String.valueOf(article.getUnit());
        if (taxRate == null || taxRate.length() == 0) {
            throw new Exception("Artikal " + code + " nema podesenu stopu poreza.");
        }
        if (name == null || name.length() == 0) {
            throw new Exception("Artikal " + code + " ne moze imati prazan naziv.");
        }
        if (price == null) {
            throw new Exception("Artikal " + code + " nema definisanu cenu.");
        }
        if (quantity == null || quantity.equals("0")) {
            throw new Exception("Artikal " + code + " ne moze imati cenu 0 ili cena nije definisana.");
        }
        if (code == null || code.length() == 0) {
            throw new Exception("Na racunu je detektovan artikal sa nedefinisanom sifrom.");
        }
        name = name.replaceAll("\u00c5\u00a0", "S");
        name = name.replaceAll("\u00c5\u00a1", "s");
        name = name.replaceAll("\u00c4\u2018", "d");
        name = name.replaceAll("\u00c4\ufffd", "D");
        name = name.replaceAll("\u00c5\u00be", "z");
        name = name.replaceAll("\u00c5\u00bd", "Z");
        name = name.replaceAll("\u00c4\ufffd", "c");
        name = name.replaceAll("\u00c4\u0152", "C");
        name = name.replaceAll("\u00c4\u2021", "c");
        name = name.replaceAll("\u00c4\u2020", "C");
        name = name.replaceAll(",", " ");
        name = name.replaceAll("'", " ");
        name = name.replaceAll("\"", " ");
        name = name.replaceAll("`", " ");
        name = name.replaceAll("&", " ");
        temp = String.valueOf(temp) + "PLU='" + article.getPLU() + "' ";
        temp = String.valueOf(temp) + "DESC='" + name + "' ";
        temp = String.valueOf(temp) + "VAT='" + taxRate + "' ";
        temp = String.valueOf(temp) + "BCR='-1' ";
        temp = String.valueOf(temp) + "PRC='" + price + "' ";
        temp = String.valueOf(temp) + "DEP='0' ";
        temp = String.valueOf(temp) + "MES='0' ";
        temp = String.valueOf(temp) + "AMN='0' ";
        temp = String.valueOf(temp) + "CMD=\"N\" ";
        temp = " <DATA " + temp + " /> ";
        return temp;
    }

    public static String getHcpArticleBillFormat(Article article) throws Exception {
        String temp = "";
        String code = article.getSifra();
        String taxRate = taxRates.get(String.valueOf(article.getTaxRate()));
        String price = String.valueOf(article.getPrice());
        String quantity = String.valueOf(article.getQuantity());
        if (taxRate == null || taxRate.length() == 0) {
            throw new Exception("Artikal " + code + " nema podesenu stopu poreza.");
        }
        if (price == null) {
            throw new Exception("Artikal " + code + " nema definisanu cenu.");
        }
        if (quantity == null || quantity.equals("0")) {
            throw new Exception("Artikal " + code + " ne moze imati cenu 0 ili cena nije definisana.");
        }
        if (code == null || code.length() == 0) {
            throw new Exception("Na racunu je detektovan artikal sa nedefinisanom sifrom.");
        }
        temp = String.valueOf(temp) + "BCR='" + article.getPLU() + "' ";
        temp = String.valueOf(temp) + "PRC='" + price + "' ";
        temp = String.valueOf(temp) + "AMN='" + quantity + "' ";
        temp = " <DATA " + temp + " /> ";
        return temp;
    }
}

