/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.kasa.putGetEngine.socket;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import rs.pezar.core.PzApplication;
import rs.pezar.kasa.putGetEngine.PutGetInterface;
import rs.pezar.kasa.putGetEngine.filesystem.DataGetter;
import rs.pezar.kasa.putGetEngine.filesystem.DataPutter;

public class PutGetEngineSocket
implements PutGetInterface {
    private static final String SUBFOLDER = "HCP";
    private static final Integer WAIT_FOR_RESPONSE = 10000;
    private static final Integer RETRY_TIME = WAIT_FOR_RESPONSE / 10;
    private String workingFolder;
    private String inFolder;
    private String outFolder;
    private DataPutter dataPutter;
    private Integer sequence;
    private Timer timer;
    private TimerTask t;
    private boolean timeOver = false;
    private Integer timeCounter = 0;
    private Integer waitForResponse = WAIT_FOR_RESPONSE;
    private Integer retryTime = RETRY_TIME;
    private Socket socket;
    private OutputStream soutput;
    private static byte[] buffer = new byte[0x100000];

    public PutGetEngineSocket(HashMap<String, String> params) throws UnknownHostException, IOException {
        this.workingFolder = PzApplication.getApplication().getDataFolder().getPath();
        this.outFolder = params.get("PARAM1");
        this.inFolder = params.get("PARAM2");
        this.dataPutter = new DataPutter();
        this.sequence = 1;
    }

    @Override
    public void put(String data, String type) throws IOException {
        this.sendCommand(data);
    }

    @Override
    public HashMap<String, String> get() {
        DataGetter.dataGet(this.outFolder, this.sequence);
        return null;
    }

    private TimerTask getTimerTask() {
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                PutGetEngineSocket putGetEngineSocket = PutGetEngineSocket.this;
                putGetEngineSocket.timeCounter = putGetEngineSocket.timeCounter + PutGetEngineSocket.this.retryTime;
                if (PutGetEngineSocket.this.timeCounter >= PutGetEngineSocket.this.waitForResponse) {
                    PutGetEngineSocket.this.timeOver = true;
                }
            }
        };
        return t;
    }

    @Override
    public synchronized HashMap<String, String> putGet(String data, String type) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        this.timeOver = false;
        this.timeCounter = 0;
        try {
            this.put(data, type);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Exception("H|Nije moguce snimiti fajl u ulazni direktorijum programa posrednika, da li ste dobro podesili?");
        }
        String response = this.readCommand();
        if (!response.contains("DESCRIPTION=\"OK\"")) {
            result.put(DataGetter.INFO_ERROR, response);
        } else {
            result.put(DataGetter.INFO_OK, response);
        }
        return result;
    }

    public void extendWaitTime(Integer toMilliseconds) {
        this.waitForResponse = toMilliseconds;
        this.retryTime = this.waitForResponse / 10;
    }

    private void resetTimeSettings() {
        this.waitForResponse = WAIT_FOR_RESPONSE;
        this.retryTime = RETRY_TIME;
    }

    private String readCommand() throws Exception {
        long time = System.currentTimeMillis();
        InputStream sinput = this.socket.getInputStream();
        int pos = 0;
        int t = 0;
        while ((t = sinput.read(buffer, pos, buffer.length - pos)) >= 0) {
            pos += t;
            if (System.currentTimeMillis() - time <= 60000L) continue;
            throw new Exception("TIMEOUT!");
        }
        return new String(buffer, 0, pos);
    }

    private void sendCommand(String txt) throws UnknownHostException, IOException {
        this.socket = new Socket("localhost", 3535);
        this.soutput = this.socket.getOutputStream();
        this.soutput.write(txt.getBytes());
        this.soutput.flush();
        this.socket.shutdownOutput();
    }

    @Override
    public void extendWaitTime(int i) {
    }
}

