/*
 * Decompiled with CFR 0.152.
 */
package rs.pezar.reports.dokumentResolver;

import java.math.BigDecimal;
import java.math.RoundingMode;
import rs.pezar.core.format.BDConverter;
import rs.pezar.db.PzDokument;
import rs.pezar.db.PzEntity;
import rs.pezar.db.entity.Fiskalniracun;
import rs.pezar.db.entity.Proizvodfiskalniracun;
import rs.pezar.reports.engine.dokument.PzDokumentResolver;

public class FiskalniRacunResolver
extends PzDokumentResolver {
    private Fiskalniracun od;

    @Override
    public Object[] getValues(PzEntity ad) {
        Proizvodfiskalniracun aod = (Proizvodfiskalniracun)ad;
        BigDecimal kolicina = BDConverter.getKolicina((double)aod.getKolicina());
        BigDecimal procenatRabata = BDConverter.getProcRabata100((double)aod.getProcRabata());
        BigDecimal cenaSaPorezom = BDConverter.getIznos((BigDecimal)BDConverter.getIznos((double)aod.getCena()).divide(new BigDecimal(1).subtract(procenatRabata), RoundingMode.HALF_UP));
        BigDecimal vrednost = BDConverter.getIznos((BigDecimal)kolicina.multiply(cenaSaPorezom));
        BigDecimal iznosRabara = BDConverter.getIznos((BigDecimal)vrednost.multiply(procenatRabata));
        return new Object[]{aod.getSifra(), aod.getNaziv(), aod.getJm(), kolicina, cenaSaPorezom, BDConverter.getProcRabata((double)aod.getProcRabata()), iznosRabara, iznosRabara.doubleValue() == 0.0 ? vrednost : BDConverter.getIznos((BigDecimal)vrednost.subtract(iznosRabara)), aod.getBliziOpis()};
    }

    @Override
    public void setDokument(PzDokument dokument) {
        this.od = (Fiskalniracun)dokument;
    }

    @Override
    public PzDokument getDokument() {
        return this.od;
    }
}

